<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class StudentModel extends CI_Model {
    public function __construct(){
        parent::__construct();
        }
    public function check_student($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function add_new_student($table,$data_array){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }    
    
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }
    public function update_student($id,$table,$data_array_update){
        $this->db->where('status',1);
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();    
    }
    
    public function get_leaving_certificate($id){
        $info=array();
        $this->db->select('*');
        $this->db->from('student');
        $this->db->where('id',$id);
        // $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }


    public function my_class_students($my_class,$my_class_section){
        $info=array();
        $this->db->select('*');
        $this->db->from('student');
        $this->db->where('class',$my_class);
        $this->db->where('section',$my_class_section);
        $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function get_student_data($sid,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_student($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class','');
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function check_student_data($sid,$table){
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        return $this->db->get()->num_rows();    
    }    
    public function add_document($sid,$document,$field,$table){
        $tid=$this->session->userdata("tid");
        $data_array=array("sid"=>$sid,$field=>$document,"cat"=>date('Y-m-d H:i:s'),"uat"=>date("Y-m-d H:i:s"),"created_by"=>$tid);
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();      
    }

    public function update_document($sid,$document,$field,$table){
        $tid=$this->session->userdata("tid");
        $data_array_update=array("$field"=>$document,"uat"=>date("Y-m-d H:i:s"),"updated_by"=>$tid);
        $this->db->where("sid",$sid);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();    
    }

    public function get_student_documents_data($sid,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_table_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function update_student_courses_data($sid,$acedemic_session,$student_course_data_array_update,$student_courses_table){
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where("sid",$sid);
        $this->db->update($student_courses_table,$student_course_data_array_update);
        return $this->db->affected_rows();
    }   
    
    public function get_student_courses_data_by_acedemic_session($sid,$acedemic_session){
        $table="student_courses_data";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_Session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    
}
?>