<?php
class ReportCardModel extends CI_MODEL{
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }

    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','DESC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_data_asc($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_exist($acedemic_session,$exam_title,$exam_type){
        $table='all_exams';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('exam_title',$exam_title);
        $this->db->where('exam_type',$exam_type);
        // $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_shift_exist($exam_id,$acedemic_session,$exam_start_time,$exam_end_time){
        $table='exam_shift';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('start_time',$exam_start_time);
        $this->db->where('end_time',$exam_end_time);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function get_exam_shifts($exam_id,$exam_shift_table){
        $table='exam_shift';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_course_exam_subject_exist($acedemic_session,$course_id,$subject){
        $table='exam_subjects_2';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('subject',$subject);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function check_course_exam_head_exist($acedemic_session,$course_id,$exam_head){
        $table='exam_heads_2';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('exam_head',$exam_head);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_subjects_data($course_id,$acedemic_session,$subjects_table){
        // $table='exam_subjects_2';
        $info=array();
        $this->db->select('*');
        $this->db->from($subjects_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('subject_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function update_item_data($id,$data_array_update,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_exam_heads_data($course_id,$acedemic_session,$exam_heads_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_heads_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        // $this->db->where('subject',$subject);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function exam_data($exam_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_schedule_exist($exam_id,$course_id,$acedemic_session,$exam_paper,$exam_schedule_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_schedule_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('exam_paper_name',$exam_paper);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_date_exist($exam_id,$acedemic_session,$exam_date,$exam_date_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_date_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('exam_date',$exam_date);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exam_schedule($exam_id,$exam_shift_id,$exam_date_id){
        $info=array();
        $this->db->select('*');
        $exam_schedule_table='exam_schedule';
        $this->db->from($exam_schedule_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('exam_shift',$exam_shift_id);
        $this->db->where('exam_date_id',$exam_date_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_students_in_alpha_order(){
        $table='student'; 
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('student_name','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function student_course_data($course_id,$sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_subjects($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('subject_order','ASC');
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_active_subjects($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('subject_order','ASC');
        $this->db->where('course_id',$course_id);
        $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function student_course_info($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exam_heads($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->order_by('head_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function get_course_exam_heads($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('head_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_active_exam_heads($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('head_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_log_item_data($sid,$ehid,$subject_id,$elog_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($elog_table);
        $this->db->where('sid',$sid);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('exam_head',$ehid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table){
        $this->db->where('sid',$sid);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('exam_head',$ehid);
        $this->db->update($elog_table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_student_subjects($sid,$course_id,$acedemic_session){
        $table='student_subjects';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function student_subject_info($sid,$course_id,$acedemic_session,$subjectid){
        $table='student_subjects';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('course_id',$course_id);
        $this->db->where('subject_id',$subjectid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exam_head_for_session_for_exam($exam_title,$course_id,$acedemic_session,$exam_head_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_head_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('exam_mode',$exam_title);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
}
