<?php
class OpeningBalanceModel extends CI_Model {
    
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    public function get_student_info($name,$fname,$course){
        $table='student';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$course);
        $this->db->where('student_name',$name);
        $this->db->where('father_name',$fname);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_student_info_new($sid){
        $table='student';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_opening_balancce($sid){
        $table='opening_balance';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_opening_balancce_fee($sid){
        $table='opening_balance_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function insert_data($data_array,$table){
    $this->db->insert($table,$data_array);
    return $this->db->insert_id();
    }
    
    public function get_opening_balance($sid,$table){
    $info=array();
    $this->db->select('*');
    $this->db->from($table);
/*    $this->db->where('id',$sid);*/
    $info=$this->db->get()->result_array();
    return $info; 
    }
    
    public function update_opening_fee($sid,$data_array_update){
        $table='opening_balance';
        $this->db->where("sid",$sid);
        $this->db->update($table,$data_array_update);    
        return $this->db->affected_rows();   
    }

    public function get_course_strength($course,$acedemic_session){
        $table='student_courses_data';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where("class",$course);
        $this->db->where("status",1);
        $this->db->where("acedemic_session",$acedemic_session);
        return $this->db->count_all_results();
    }
    
    public function get_student_courses_data($course_id,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        // $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_student_opening_fee($sid,$opening_fee_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($opening_fee_table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;       
    }
    
    public function get_received_opening_fee_for_student($sid){
        $opening_fee_table='opening_balance_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($opening_fee_table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;       
    }
    
    public function get_course_opening_data($course){
        $table='opening_balance';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$course);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    public function get_opening_fee_invoice_info($fee_no){
        $opening_fee_table='opening_balance_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($opening_fee_table);
        $this->db->where('id',$fee_no);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_del_invoice_info($fee_no,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('inv_no',$fee_no);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function delete_opening_balance_fee_invoice_permanently($fee_no,$table){
        $this->db->where('id',$fee_no);
        $this->db->delete($table);
        return $this->db->affected_rows();
    }
    
    public function delete_opening_balance_deleted_fee_invoice_permanently($item_id,$del_fee_table){
        $this->db->where('inv_no',$item_id);
        $this->db->delete($del_fee_table);
        return $this->db->affected_rows();
    }
    
}