<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class School extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('SchoolModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('DeveloperModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function profile(){
        $data['success'] = ''; $data['error'] = '';    
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/profile',$data);
        $this->load->view('erp/footer'); 
    }
    
    public function profile_update(){
        $data['success'] = ''; $data['error'] = '';    
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/update-profile-new',$data);
        $this->load->view('erp/footer'); 
    }

    public function update_profile(){
        $this->load->library('form_validation');	
        $this->form_validation->run() == FALSE;
        $data['success'] = ''; $data['error'] = '';
        
        $this->form_validation->set_rules('salutation', 'Salutation', 'required');    
    
        $this->form_validation->set_rules('teacher_name', 'First Name', 'trim|alpha_numeric_spaces|max_length[30]');
        $this->form_validation->set_rules('father_name', 'Father Name', 'trim|alpha_numeric_spaces|max_length[30]');
        $this->form_validation->set_rules('dob', 'Date', '');
        $this->form_validation->set_rules('marital_status', 'Marital Status', 'required');
        $this->form_validation->set_rules('gender', 'Gender', 'required');

        $this->form_validation->set_rules('aadhar_no', 'Aadhar Number', 'trim');

        $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'trim|max_length[13]');

        $this->form_validation->set_rules('alt_mobile_number', 'Alt Mobile Number', 'trim|max_length[13]');

        $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|max_length[50]');


        $this->form_validation->set_rules('address', 'Address', 'trim|max_length[100]');

        $this->form_validation->set_rules('permanent_address', 'Permanent Address', 'trim|max_length[100]');


        $this->form_validation->set_rules('educational_qualification_1', 'Educational Qqualifications', 'trim|max_length[100]');

        $this->form_validation->set_rules('educational_qualification_2', 'Educational Qqualifications', 'trim|max_length[100]');

        $this->form_validation->set_rules('educational_qualification_3', 'Educational Qqualifications', 'trim|max_length[100]');

        $this->form_validation->set_rules('total_teaching_experience', 'Total Teachiing  Experience', 'trim|max_length[2]');

        $this->form_validation->set_rules('designation', 'Designation', 'trim|min_length[2]|max_length[100]');

        $this->form_validation->set_rules('teaching_classes', 'Teaching Classes', 'trim');

        $this->form_validation->set_rules('emp_nature', 'Employee Nature', 'trim');

        $this->form_validation->set_rules('staff_category', 'Staff Category', 'trim');

        $this->form_validation->set_rules('subject1', 'Subject Taught', 'trim');

        $this->form_validation->set_rules('subject2', 'Subject Taught', 'trim');

        $this->form_validation->set_rules('subject3', 'Subject Taught', 'trim');

        $this->form_validation->set_rules('bank_name', 'Bank Name', 'trim|alpha|max_length[100]');

        $this->form_validation->set_rules('ifsc_code', 'IFSC Code', 'trim|alpha_numeric|max_length[100]');

        $this->form_validation->set_rules('account_number', 'Bank Account Number', 'trim|numeric|max_length[50]');

        $this->form_validation->set_rules('branch_address', 'Branch Address', 'trim|max_length[100]');


        if ($this->form_validation->run() == FALSE){
            // $this->load->view('enquiry/signup',$data);
            // $this->load->view('enquiry/footer');
        }else{
            if(isset($_POST['update_profile'])){
                $salutation =htmlspecialchars($this->input->post('salutation'));    
                $teacher_name = htmlspecialchars($this->input->post('teacher_name'));
                $father_name = htmlspecialchars($this->input->post('father_name'));
                $dob = htmlspecialchars($this->input->post('dob'));
                $marital_status = htmlspecialchars($this->input->post('marital_status'));
                $gender = htmlspecialchars($this->input->post('gender'));
                $aadhar_no = htmlspecialchars($this->input->post('aadhar_no'));
                
                $mobile_number = htmlspecialchars($this->input->post('mobile_number'));
                $alt_mobile_number = htmlspecialchars($this->input->post('alt_mobile_number'));
                $email = htmlspecialchars($this->input->post('email'));
                $address =htmlspecialchars($this->input->post('address'));
                $permanent_address =htmlspecialchars($this->input->post('permanent_address'));
                
                $educational_qualification_1 = htmlspecialchars($this->input->post('educational_qualification_1'));
                $educational_qualification_2 = htmlspecialchars($this->input->post('educational_qualification_2'));
                $educational_qualification_3 = htmlspecialchars($this->input->post('educational_qualification_3'));
                $highest_qualification =htmlspecialchars($this->input->post('highest_qualification'));
                $date_of_joining = htmlspecialchars($this->input->post('date_of_joining'));
                $total_teaching_experience = htmlspecialchars($this->input->post('total_teaching_experience'));

                $designation = htmlspecialchars($this->input->post('designation'));
                $teaching_classes = htmlspecialchars($this->input->post('teaching_classes'));
                $emp_nature = htmlspecialchars($this->input->post('emp_nature'));

                $staff_category = htmlspecialchars($this->input->post('staff_category'));

                $subject1 = htmlspecialchars($this->input->post('subject1'));
                $subject2 = htmlspecialchars($this->input->post('subject2'));
                $subject3 = htmlspecialchars($this->input->post('subject3'));

                $bank_name = htmlspecialchars($this->input->post('bank_name'));
                $account_number = htmlspecialchars($this->input->post('account_number'));
                $ifsc_code = htmlspecialchars($this->input->post('ifsc_code'));
                $branch_address = htmlspecialchars($this->input->post('branch_address'));
   
                $id=$this->input->post('id');

                $uptodate =date('d-m-y');

                $data_array_update = array("salutation"=>$salutation,"name"=>$teacher_name,"father_name"=>$father_name,"dob"=>$dob,"marital_status"=>$marital_status,"gender"=>$gender,"aadhar_no"=>$aadhar_no,"mobile_number"=>$mobile_number,"alt_mobile_number"=>$alt_mobile_number,"email"=>$email,"address"=>$address,"permanent_address"=>$permanent_address,"educational_qualification1"=>$educational_qualification_1,"educational_qualification2"=>$educational_qualification_2,"educational_qualification3"=>$educational_qualification_3,"highest_qualification"=>$highest_qualification,"date_of_joining"=>$date_of_joining,"total_teaching_experience"=>$total_teaching_experience,"designation"=>$designation,"teaching_classes"=>$teaching_classes,"employee_nature"=>$emp_nature,"staff_category"=>$staff_category,"subject_taught1"=>$subject1,"subject_taught2"=>$subject2,"subject_taught3"=>$subject3,"bank_name"=>$bank_name,"account_no"=>$account_number,"ifsc"=>$ifsc_code,"branch_address"=>$branch_address,"updated_at"=>$uptodate);

                $table='school_staff';
                $update=$this->SchoolModel->update_school_staff($id,$table,$data_array_update);

                if($update){$data['success'] ="Profile Updated Successfully";
                    redirect(base_url().'school/profile',$data);    
                }else{$data['error'] ="Error in Updating Profile";}

            }
        }


        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');  
        $this->load->view('erp/sidebar');
        $this->load->view('erp/update-profile',$data);
        $this->load->view('erp/footer'); 

        // $this->load->view('entab/feemanagement/user/header');
        // $this->load->view('entab/nav');

        // $this->load->view('entab/feemanagement/user/footer');
    }

    public function circular(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/circular/all-circular');
        $this->load->view('erp/footer');     
    }

    public function courses(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/courses');
        $this->load->view('erp/footer');     
    }

    public function add_courses(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_course'])){
            $course=$this->input->post('course');
            $subject_stream=$this->input->post('subject_stream');

            $table='courses';
            $data_array=array("course"=>$course,"subject_stream"=>$subject_stream);
            $check_course_exist=$this->WelcomeModel->check_course_exist($course,$subject_stream);
            if($check_course_exist){
                $data['error']="Already Exist";
            }else{
                $add_new_course=$this->WelcomeModel->insert_data($data_array,$table);    
                if($add_new_course){
                    $data['success']='Added Successfully';
                }
            }

        }
    
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/addcourse',$data);
        $this->load->view('erp/footer');     
    }

    public function students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/students/students');
        $this->load->view('erp/footer');     
    }
    public function students_academic_session_wise(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/students/all-students');
        $this->load->view('erp/footer');     
    }   



    public function manage_student_profile($id){
        $data['success']=""; $data['error']="";
        if(isset($_POST['add_student_review'])){
            $sid=$_POST['sid'];
            $academic_session=$this->session->userdata("acedemic_session");
            $review_type=$_POST['review_type'];
            $review_date=$_POST['review_date'];
            $student_review=$_POST['student_review'];
            
            $cat=date("Y-m-d H:i:s");
            
            $tid=$this->session->userdata("tid");
             	 	 	 	 	 	 	
            $data_array=array("sid"=>$sid,"academic_session"=>$academic_session,"review_type"=>$review_type,"review_date"=>$review_date,"student_review"=>$student_review,"created_at"=>$cat,"created_by"=>$tid,"updated_at"=>$cat,"updated_by"=>$tid);
            $table=" student_reviews";
            $add_student_remark=$this->WelcomeModel->insert_data($data_array,$table);
            if($add_student_remark){
                $data['success']="Student remark aaded successfully !";
            }else{
                $data['error']="Error while adding student remark !";
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/manage-student-profile');
        $this->load->view('erp/management/view-student-courses');
        $this->load->view("erp/management/student-reviews-and-feedback",$data);
        $this->load->view('erp/footer');
    }

    public function course_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/view-course-students');
        $this->load->view('erp/footer');
    }
    public function student_pdf(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/course_wise_students_pdf');
        $this->load->view('erp/footer');
    }
    
    public function pdf($course_id){
        // $course_id=$this->uri->segment('3');
        
        $course_table='courses';
        $course='';
        $subject_stream='';
        
        $get_course_data=$this->NewFeeModel->get_item_data($course_id,$course_table);
        if($get_course_data){
            foreach($get_course_data as $course_data){
                $course=$course_data['course'];
                $subject_stream=$course_data['subject_stream'];
            }
        }
        $title=$course."".$subject_stream."-Students-".date("Y-m-d-H-i-s");
        $this->load->view('erp/management/course_wise_students_pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }   
    
    
    public function students_list(){
        $title="Student_List_Without_Sch_No";
        $this->load->view('erp/management/Student_List_Without_Sch_No_Pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }

    public function view_all_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/students/view-all-students');
        $this->load->view('erp/footer');
    }
    
    public function update_personal_information(){
        $data['success']=''; $data['error']='';
        $this->load->library('form_validation');	
        $this->form_validation->run() == FALSE;
        $this->form_validation->set_rules('salutation', 'Salutation', 'required');    
        $this->form_validation->set_rules('teacher_name', 'First Name', 'trim|alpha_numeric_spaces|max_length[30]');
        $this->form_validation->set_rules('father_name', "Father's Name", 'trim|alpha_numeric_spaces|max_length[30]');
        $this->form_validation->set_rules('dob', 'Date', '');
        $this->form_validation->set_rules('marital_status', 'Marital Status', 'required');
        $this->form_validation->set_rules('gender', 'Gender', 'required');
        $this->form_validation->set_rules('aadhar_no', 'Aadhar Number', 'trim');
            
        if ($this->form_validation->run() == FALSE){
                
        }else{
            if(isset($_POST['update_personal_information'])){
                $tid=$this->input->post('tid');
                $salutation =htmlspecialchars($this->input->post('salutation'));    
                $teacher_name = htmlspecialchars($this->input->post('teacher_name'));
                $father_name = htmlspecialchars($this->input->post('father_name'));
                $dob = htmlspecialchars($this->input->post('dob'));
                $marital_status = htmlspecialchars($this->input->post('marital_status'));
                $gender = htmlspecialchars($this->input->post('gender'));
                $aadhar_no = htmlspecialchars($this->input->post('aadhar_no'));    
                
                
                $uptodate =date('Y-m-d');

                $data_array_update = array("salutation"=>$salutation,"name"=>$teacher_name,"father_name"=>$father_name,"dob"=>$dob,"marital_status"=>$marital_status,"gender"=>$gender,"aadhar_no"=>$aadhar_no,"updated_at"=>$uptodate);
                $table='school_staff';
                $update=$this->SchoolModel->update_school_staff($tid,$table,$data_array_update);

                if($update){
                    $data['success'] ="Profile Updated Successfully";
                    redirect(base_url().'school/profile',$data);    
                }else{$data['error'] ="Error in Updating Profile";}
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/profiles/update-personal-information',$data);
        $this->load->view('erp/footer');
    }
    
    public function update_contact_information(){
        $data['success']='';$data['error']='';
        $this->load->library('form_validation');	
        $this->form_validation->run() == FALSE;
        $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'trim|max_length[13]');
        $this->form_validation->set_rules('alt_mobile_number', 'Alt Mobile Number', 'trim|max_length[13]');
        $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|max_length[50]');
        $this->form_validation->set_rules('address', 'Address', 'trim|max_length[100]');
        $this->form_validation->set_rules('permanent_address', 'Permanent Address', 'trim|max_length[100]');
        
        if ($this->form_validation->run() == FALSE){
                
        }else{
            if(isset($_POST['update_contact_information'])){
                $tid=$this->input->post('tid');
                $mobile_number = htmlspecialchars($this->input->post('mobile_number'));
                $alt_mobile_number = htmlspecialchars($this->input->post('alt_mobile_number'));
                $email = htmlspecialchars($this->input->post('email'));
                $address =htmlspecialchars($this->input->post('address'));
                $permanent_address =htmlspecialchars($this->input->post('permanent_address'));
                
                $uptodate =date('Y-m-d');
                $data_array_update = array("mobile_number"=>$mobile_number,"alt_mobile_number"=>$alt_mobile_number,"email"=>$email,"address"=>$address,"permanent_address"=>$permanent_address,"updated_at"=>$uptodate);
                $table='school_staff';
                $update=$this->SchoolModel->update_school_staff($tid,$table,$data_array_update);
                if($update){
                    $data['success'] ="Profile Updated Successfully";
                    redirect(base_url().'school/profile',$data);    
                }else{$data['error'] ="Error in Updating Profile";}
                
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/profiles/update-contact-information',$data);
        $this->load->view('erp/footer');
    }
    
    public function update_educational_information(){
        $data['success']='';$data['error']='';
        $this->load->library('form_validation');	
        $this->form_validation->run() == FALSE;
        $this->form_validation->set_rules('educational_qualification_1', 'Educational Qqualifications', 'trim|max_length[100]');
        $this->form_validation->set_rules('educational_qualification_2', 'Educational Qqualifications', 'trim|max_length[100]');
        $this->form_validation->set_rules('educational_qualification_3', 'Educational Qqualifications', 'trim|max_length[100]');
        $this->form_validation->set_rules('total_teaching_experience', 'Total Teachiing  Experience', 'trim|max_length[2]');
        $this->form_validation->set_rules('designation', 'Designation', 'trim|min_length[2]|max_length[100]');
        $this->form_validation->set_rules('teaching_classes', 'Teaching Classes', 'trim');
        $this->form_validation->set_rules('emp_nature', 'Employee Nature', 'trim');
        $this->form_validation->set_rules('staff_category', 'Staff Category', 'trim');
        $this->form_validation->set_rules('subject1', 'Subject Taught', 'trim');
        $this->form_validation->set_rules('subject2', 'Subject Taught', 'trim');
        $this->form_validation->set_rules('subject3', 'Subject Taught', 'trim');
        
        if ($this->form_validation->run() == FALSE){
                
        }else{
            if(isset($_POST['update_educational_information'])){
                $tid=$this->input->post('tid');
                
                $educational_qualification_1 = htmlspecialchars($this->input->post('educational_qualification_1'));
                $educational_qualification_2 = htmlspecialchars($this->input->post('educational_qualification_2'));
                $educational_qualification_3 = htmlspecialchars($this->input->post('educational_qualification_3'));
                $highest_qualification =htmlspecialchars($this->input->post('highest_qualification'));
                $date_of_joining = htmlspecialchars($this->input->post('date_of_joining'));
                $total_teaching_experience = htmlspecialchars($this->input->post('total_teaching_experience'));
                $designation = htmlspecialchars($this->input->post('designation'));
                $teaching_classes = htmlspecialchars($this->input->post('teaching_classes'));
                $emp_nature = htmlspecialchars($this->input->post('emp_nature'));
                $staff_category = htmlspecialchars($this->input->post('staff_category'));
                $subject1 = htmlspecialchars($this->input->post('subject1'));
                $subject2 = htmlspecialchars($this->input->post('subject2'));
                $subject3 = htmlspecialchars($this->input->post('subject3'));
                
                $uptodate =date('Y-m-d');
                
                $data_array_update = array("educational_qualification1"=>$educational_qualification_1,"educational_qualification2"=>$educational_qualification_2,"educational_qualification3"=>$educational_qualification_3,"highest_qualification"=>$highest_qualification,"date_of_joining"=>$date_of_joining,"total_teaching_experience"=>$total_teaching_experience,"designation"=>$designation,"teaching_classes"=>$teaching_classes,"employee_nature"=>$emp_nature,"staff_category"=>$staff_category,"subject_taught1"=>$subject1,"subject_taught2"=>$subject2,"subject_taught3"=>$subject3,"updated_at"=>$uptodate);
                $table='school_staff';
                $update=$this->SchoolModel->update_school_staff($tid,$table,$data_array_update);
                if($update){
                    $data['success'] ="Profile Updated Successfully";
                    redirect(base_url().'school/profile',$data);    
                }else{$data['error'] ="Error in Updating Profile";}
                
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/profiles/update-educational-information',$data);
        $this->load->view('erp/footer');
    }
    
    public function update_bank_information(){
        $data['success']='';$data['error']='';
        $this->load->library('form_validation');	
        $this->form_validation->run() == FALSE;
        
        $this->form_validation->set_rules('bank_name', 'Bank Name', 'trim|alpha|max_length[100]');

        $this->form_validation->set_rules('ifsc_code', 'IFSC Code', 'trim|alpha_numeric|max_length[100]');

        $this->form_validation->set_rules('account_number', 'Bank Account Number', 'trim|numeric|max_length[50]');

        $this->form_validation->set_rules('branch_address', 'Branch Address', 'trim|max_length[100]');
        
        if ($this->form_validation->run() == FALSE){
                
        }else{
            if(isset($_POST['update_bank_information'])){
                $tid=$this->input->post('tid');
                
                $bank_name = htmlspecialchars($this->input->post('bank_name'));
                $account_number = htmlspecialchars($this->input->post('account_number'));
                $ifsc_code = htmlspecialchars($this->input->post('ifsc_code'));
                $branch_address = htmlspecialchars($this->input->post('branch_address'));
                
                $uptodate =date('Y-m-d');
                
                $data_array_update = array("bank_name"=>$bank_name,"account_no"=>$account_number,"ifsc"=>$ifsc_code,"branch_address"=>$branch_address,"updated_at"=>$uptodate);
                $table='school_staff';
                $update=$this->SchoolModel->update_school_staff($tid,$table,$data_array_update);
                if($update){
                    $data['success'] ="Profile Updated Successfully";
                    redirect(base_url().'school/profile',$data);    
                }else{$data['error'] ="Error in Updating Profile";}
                
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/profiles/update-bank-information',$data);
        $this->load->view('erp/footer');
    }
    
    public function student_profile($id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/school/student-profile');
        $this->load->view('erp/footer');
    }
    
    public function scholor_register($sid){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_new_course'])){
            $sid=$this->input->post('sid');
            $course_id=$this->input->post('course_id');
            $acedemic_session=$this->input->post('acedemic_session');
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $student_courses_data_array=array("sid"=>$sid,"course_id"=>$course_id,"acedemic_session"=>$acedemic_session,"cat"=>$cat,"cat_by"=>$tid);
            $check_acedemic_session_exist=$this->SchoolModel->student_course_data($sid,$acedemic_session);
            if($check_acedemic_session_exist){
                $data['error']='Acedemic Session Already Exist';
            }else{
                $student_courses_data_table='student_courses_data';
                $add_new_course=$this->SchoolModel->insert_data($student_courses_data_table,$student_courses_data_array);    
                if($add_new_course){
                    $data['success']='Added Successfully';
                }else{
                    $data['error']='Error in adding data';
                }
            }
            
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/school/student-scholor-register');
        $this->load->view('erp/school/student-courses-data',$data);
        // $this->load->view('erp/school/scholor-register');
        $this->load->view('erp/footer');
    }
    
    public function update_scholor_register(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['update_scholor_register'])){
            $log_id=$this->input->post('log_id');
            $sid=$this->input->post('sid');
            $course_id=$this->input->post('course_id');
            $date_of_admission=$this->input->post('date_of_admission');
            $date_of_promotion=$this->input->post('date_of_promotion');
            $date_of_removal=$this->input->post('date_of_removal');
            $cause_of_removal=$this->input->post('cause_of_removal');
            $acedemic_year=$this->input->post('acedemic_year');
            $conduct_and_work=$this->input->post('conduct_and_work');
            $cat=date('Y-m-d H:i:s');
            $date=date('Y-m-d');
            $tid=$this->session->userdata('tid');
            
            $table='student_courses_data';
            $data_array_update=array("course_id"=>$course_id,"date_of_admission"=>$date_of_admission,"date_of_promotion"=>$date_of_promotion,"date_of_removal"=>$date_of_removal,"cause_of_removal"=>$cause_of_removal,"conduct_and_work"=>$conduct_and_work,"uat"=>$cat,"upd_by"=>$tid);
            
            $update_scholor_register=$this->SchoolModel->update_item_data($log_id,$table,$data_array_update);
            if($update_scholor_register){
                $data['success']='Updated Successfully';
            }else{
                $data['error']='Error in updating scholor register';
            }
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/school/student-scholor-register');
        // $this->load->view('erp/school/student-courses-data',$data);
        $this->load->view('erp/school/update-scholor-register',$data);
        $this->load->view('erp/school/student-courses-data',$data);
        $this->load->view('erp/footer');
    }
    
    
}