<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Management extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('SchoolModel');
        $this->load->model('StudentModel');
        // $this->load->model('FeeModel');
        $this->load->model('AttendenceModel');
        $this->load->model('CalenderModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('DeveloperModel');

        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function index(){
        if($this->session->userdata('admin')!=1){
            redirect(base_url().'Welcome/');
        }    
    }
    public function add_teacher_1(){
        if($this->session->userdata('admin')!=1){
            redirect(base_url().'Welcome/');
        }    
    
    
        $data['success']='';    $data['error']='';

        if (isset($_POST['add_teacher'])){

            $teacher_name = $this->input->post('teacher_name');
            $mobile_number = $this->input->post('mobile_number');
            // $email = htmlspecialchars($this->input->post('teacher_email'));

            $data_array=array("name"=>$teacher_name,"mobile_number"=>$mobile_number,"password"=>$mobile_number,"user_status"=>1);
            $table ='school_staff';
            $cat=date('Y-m-d H:i:s');
            $check_staff = $this->SchoolModel->check_staff($mobile_number,$table); 


            if($check_staff ==0){


                $add_staff = $this->SchoolModel->add_staff($table,$data_array);
                if($add_staff){
                    $data['success'] = 'Added Successfully'; 
                    $login_data_array=array("user_id"=>$add_staff,"username"=>$mobile_number,"Name"=>$teacher_name,"mob_number"=>$mobile_number,"usertype"=>'staff',"status"=>1,"password"=>md5($mobile_number),"cat"=>$cat);
                    $cred_table='login_credentials';
                    $add_login_credentials=$this->SchoolModel->add_new_data($cred_table,$login_data_array);
                    if($add_login_credentials){
                        $data['success']="Login Credentials Added Successfully";
                    }else{
                        $data['error']="Error in adding login cred.";
                    }

                }else{
                    $data['error']="something wrong with you";    
                }

            }else{
                $data['error']="Already Registred";    
            }
        }
        $this->load->view('erp/header');   
        // $this->load->view('erp/staff-nav');  
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/add-teacher',$data);    
        $this->load->view('erp/footer');
    }  
    
    
    
    
    
    public function add_teacher(){
        if($this->session->userdata('admin')!=1){
            redirect(base_url().'Welcome/');
        }    
        
        $data['success']='';    $data['error']='';
        if (isset($_POST['add_teacher'])){

            // $teacher_name = $this->input->post('teacher_name');
            // $mobile_number = $this->input->post('mobile_number');
            // $email = htmlspecialchars($this->input->post('teacher_email'));
            $salutation=$_POST['salutation'];
            $teacher_name=$_POST['teacher_name'];
            $designation=$_POST['designation'];
            $gender=$_POST['gender'];
            $dob=$_POST['dob'];
            $mobile_number=$_POST['mobile_number'];
            $alt_mobile_number=$_POST['alt_mobile_number'];
            $email=$_POST['email'];
            $address=$_POST['address'];
            $permanent_address=$_POST['permanent_address'];
            
            
            $staff_category=$_POST['staff_category'];
            $status=$_POST['status'];
            
            $user_profile_picture="";
        	$user_profile_picture_with_url="";
        	if($_FILES['user_profile_picture']['name']){
            	$user_profile_picture = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['user_profile_picture']['name']);
            	$user_profile_picture = mt_rand(999999,9999999).'-'.$user_profile_picture;
            	move_uploaded_file($_FILES['user_profile_picture']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/profile_picture/".$user_profile_picture);
            	$user_profile_picture_with_url =base_url().'assets/profile_picture/'.$user_profile_picture;
        	}
        	
        	$signature="";
        	$signature_with_url="";
        	if($_FILES['signature']['name']){
            	$signature = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['signature']['name']);
            	$signature = mt_rand(999999,9999999).'-'.$signature;
            	move_uploaded_file($_FILES['signature']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/signature/".$signature);
            	$signature_with_url =base_url().'assets/signature/'.$signature;
        	}
        	
        	$accounts=0;
        	if(isset($_POST['accounts'])){
        	    $accounts=$_POST['accounts'];
        	}
        	
            $student_attendance=0;
            if(isset($_POST['student_attendance'])){
                $student_attendance=$_POST['student_attendance'];
            }
            $staff_attendance=0;
            if(isset($_POST['staff_attendance'])){
                $staff_attendance=$_POST['staff_attendance'];
            }
            $courses=0;
            if(isset($_POST['courses'])){
                $courses=$_POST['courses'];
            }
            $enquiry=0;
            if(isset($_POST['enquiry'])){
                $enquiry=$_POST['enquiry'];
            }
            $admission=0;
            if(isset($_POST['admission'])){
                $admission=$_POST['admission'];
            }
            $fee_structure=0;
            if(isset($_POST['fee_structure'])){
                $fee_structure=$_POST['fee_structure'];
            }
            $exam=0;
            if(isset($_POST['exam'])){
                $exam=$_POST['exam'];
            }
            $fee=0;
            if(isset($_POST['fee'])){
                $fee=$_POST['fee'];
            }
            $documents=0;
            if(isset($_POST['documents'])){
                $documents=$_POST['documents'];
            }
            $staff=0;
            if(isset($_POST['staff'])){
                $staff=$_POST['staff'];
            }
            $transport=0;
            if(isset($_POST['transport'])){
                $transport=$_POST['transport'];
            }
            $students=0;
            if(isset($_POST['students'])){
                $students=$_POST['students'];
            }
            $fee_defaulter=0;
            if(isset($_POST['fee_defaulter'])){
                $fee_defaulter=$_POST['fee_defaulter'];
            }
            
            $delete_fee_invoice=0;
            if(isset($_POST['delete_fee_invoice'])){
                $delete_fee_invoice=$_POST['delete_fee_invoice'];
            }
            
            $delete_student=0;
            if(isset($_POST['delete_student'])){
                $delete_student=$_POST['delete_student'];
            }
            
            
            $acedemic_session_permission=0;
            if(isset($_POST['acedemic_session_permission'])){
                $acedemic_session_permission=$_POST['acedemic_session_permission'];
            }
            
            $circular=0;
            if(isset($_POST['circular'])){
                $circular=$_POST['circular'];
            }
            $admin=0;
            if(isset($_POST['admin'])){
                $admin=$_POST['admin'];
            }
            $time_table=0;
            if(isset($_POST['time_table'])){
                $time_table=$_POST['time_table'];
            }
            
            $edit_fee=0;
            if(isset($_POST['edit_fee'])){
                $edit_fee=$_POST['edit_fee'];
            }
            $back_date_fee=0;
            if(isset($_POST['back_date_fee'])){
                $back_date_fee=$_POST['back_date_fee'];
            }
            
            
            $table ='school_staff';
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata("tid");
            
            $data_array=array(
                "salutation"=>$salutation,
                "name"=>$teacher_name,
                "mobile_number"=>$mobile_number,
                "alt_mobile_number"=>$alt_mobile_number,
                "email"=>$email,
                "address"=>$address,
                "permanent_address"=>$permanent_address,
                "gender"=>$gender,
                "dob"=>$dob,
                "designation"=>$designation,
                "profile_pic"=>$user_profile_picture,
                "signature"=>$signature,
                "password"=>$mobile_number,
                "user_status"=>$status,
                "staff_category"=>$staff_category,
                "created_at"=>$cat,
                "created_by"=>$tid,
                "updated_at"=>$cat,
                "updated_by"=>$tid
            );
            
            // $check_staff = $this->SchoolModel->check_staff($mobile_number,$table); 
            $get_staff_data_with_mobile_no=$this->SchoolModel->check_staff($mobile_number,$table);

            if($get_staff_data_with_mobile_no){
                $data['error']="Already Registred";
            }else{
                $add_staff = $this->SchoolModel->add_staff($table,$data_array);
                if($add_staff){
                    $data['success'] = 'Added Successfully'; 
                    $login_data_array=array("user_id"=>$add_staff,"username"=>$mobile_number,"Name"=>$teacher_name,"mob_number"=>$mobile_number,"usertype"=>'staff',"status"=>1,"password"=>md5($mobile_number),"cat"=>$cat);
                    $cred_table='login_credentials';
                    $add_login_credentials=$this->SchoolModel->add_new_data($cred_table,$login_data_array);
                    if($add_login_credentials){
                        $data['success']="Login Credentials Added Successfully";
                    }else{
                        $data['error']="Error in adding login cred.";
                    }
                    
                    $permission_array=array(
                        "emp_id"=>$add_staff,
                        "accounts"=>$accounts,
                        "student_attendance"=>$student_attendance,
                        "staff_attendance"=>$staff_attendance,
                        "courses"=>$courses,
             	        "enquiry"=>$enquiry,
             	        "admission"=>$admission,
             	        "fee_structure"=>$fee_structure,
             	        "exam"=>$exam,
             	        "fee"=>$fee,
             	        "documents"=>$documents,
             	        "staff"=>$staff,
             	        "transport"=>$transport,
             	        "students"=>$students,
             	        "fee_defaulter"=>$fee_defaulter,
             	        "delete_fee_invoice"=>$delete_fee_invoice,
             	        "delete_student"=>$delete_student,
             	        "acedemic_session"=>$acedemic_session_permission,
             	        "circular"=>$circular,
                        "admin"=>$admin,
                        "time_table"=>$time_table,
                        "edit_fee"=>$edit_fee,
                        "back_date_fee"=>$back_date_fee,
             	        "created_at"=>$cat,
             	        "created_by"=>$tid,
             	        "updated_at"=>$cat,
             	        "updated_by"=>$tid
                    );
                    $staff_permissions_table="staff_permissions";
                    $add_permissions=$this->SchoolModel->insert_data($staff_permissions_table,$permission_array);

                }else{
                    $data['error']="something wrong with you";    
                }
            }
            // if($check_staff ==0){
            //     $add_staff = $this->SchoolModel->add_staff($table,$data_array);
            //     if($add_staff){
            //         $data['success'] = 'Added Successfully'; 
            //         $login_data_array=array("user_id"=>$add_staff,"username"=>$mobile_number,"Name"=>$teacher_name,"mob_number"=>$mobile_number,"usertype"=>'staff',"status"=>1,"password"=>md5($mobile_number),"cat"=>$cat);
            //         $cred_table='login_credentials';
            //         $add_login_credentials=$this->SchoolModel->add_new_data($cred_table,$login_data_array);
            //         if($add_login_credentials){
            //             $data['success']="Login Credentials Added Successfully";
            //         }else{
            //             $data['error']="Error in adding login cred.";
            //         }

            //     }else{
            //         $data['error']="something wrong with you";    
            //     }

            // }else{
            //     $data['error']="Already Registred";    
            // }
        }
        $this->load->view('erp/header');   
        // $this->load->view('erp/staff-nav');  
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/add-teacher',$data);    
        $this->load->view('erp/footer');    
    }  
    
    
    public function edit_staff(){
        $data['success']="";    $data['error']="";
        if(isset($_POST['update_teacher'])){
            $staff_id=$_POST['staff_id'];
            $salutation=$_POST['salutation'];
            $teacher_name=$_POST['teacher_name'];
            $designation=$_POST['designation'];
            $gender=$_POST['gender'];
            $dob=$_POST['dob'];
            $mobile_number=$_POST['mobile_number'];
            $alt_mobile_number=$_POST['alt_mobile_number'];
            $email=$_POST['email'];
            $address=$_POST['address'];
            $permanent_address=$_POST['permanent_address'];
            $staff_category=$_POST['staff_category'];
            $status=$_POST['status'];
            
            $user_profile_picture="";
        	$user_profile_picture_with_url="";
        	if($_FILES['user_profile_picture']['name']){
            	$user_profile_picture = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['user_profile_picture']['name']);
            	$user_profile_picture = mt_rand(999999,9999999).'-'.$user_profile_picture;
            	move_uploaded_file($_FILES['user_profile_picture']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/profile_picture/".$user_profile_picture);
            	$user_profile_picture_with_url =base_url().'assets/profile_picture/'.$user_profile_picture;
        	}
        	
        	$signature="";
        	$signature_with_url="";
        	if($_FILES['signature']['name']){
            	$signature = preg_replace("/[^a-zA-Z0-9.-]+/", "", $_FILES['signature']['name']);
            	$signature = mt_rand(999999,9999999).'-'.$signature;
            	move_uploaded_file($_FILES['signature']['tmp_name'], $_SERVER['DOCUMENT_ROOT']."/assets/signature/".$signature);
            	$signature_with_url =base_url().'assets/signature/'.$signature;
        	}
        	
        	$accounts=0;
        	if(isset($_POST['accounts'])){
        	    $accounts=$_POST['accounts'];
        	}
        	
            $student_attendance=0;
            if(isset($_POST['student_attendance'])){
                $student_attendance=$_POST['student_attendance'];
            }
            $staff_attendance=0;
            if(isset($_POST['staff_attendance'])){
                $staff_attendance=$_POST['staff_attendance'];
            }
            $courses=0;
            if(isset($_POST['courses'])){
                $courses=$_POST['courses'];
            }
            $enquiry=0;
            if(isset($_POST['enquiry'])){
                $enquiry=$_POST['enquiry'];
            }
            $admission=0;
            if(isset($_POST['admission'])){
                $admission=$_POST['admission'];
            }
            $fee_structure=0;
            if(isset($_POST['fee_structure'])){
                $fee_structure=$_POST['fee_structure'];
            }
            $exam=0;
            if(isset($_POST['exam'])){
                $exam=$_POST['exam'];
            }
            $fee=0;
            if(isset($_POST['fee'])){
                $fee=$_POST['fee'];
            }
            $documents=0;
            if(isset($_POST['documents'])){
                $documents=$_POST['documents'];
            }
            $staff=0;
            if(isset($_POST['staff'])){
                $staff=$_POST['staff'];
            }
            $transport=0;
            if(isset($_POST['transport'])){
                $transport=$_POST['transport'];
            }
            $students=0;
            if(isset($_POST['students'])){
                $students=$_POST['students'];
            }
            $fee_defaulter=0;
            if(isset($_POST['fee_defaulter'])){
                $fee_defaulter=$_POST['fee_defaulter'];
            }
            
            $delete_fee_invoice=0;
            if(isset($_POST['delete_fee_invoice'])){
                $delete_fee_invoice=$_POST['delete_fee_invoice'];
            }
            
            $delete_student=0;
            if(isset($_POST['delete_student'])){
                $delete_student=$_POST['delete_student'];
            }
            
            $acedemic_session_permission=0;
            if(isset($_POST['acedemic_session_permission'])){
                $acedemic_session_permission=$_POST['acedemic_session_permission'];
            }
            
            $circular=0;
            if(isset($_POST['circular'])){
                $circular=$_POST['circular'];
            }
            $admin=0;
            if(isset($_POST['admin'])){
                $admin=$_POST['admin'];
            }
            $time_table=0;
            if(isset($_POST['time_table'])){
                $time_table=$_POST['time_table'];
            }
            
            $edit_fee=0;
            if(isset($_POST['edit_fee'])){
                $edit_fee=$_POST['edit_fee'];
            }
            $back_date_fee=0;
            if(isset($_POST['back_date_fee'])){
                $back_date_fee=$_POST['back_date_fee'];
            }
            
            $table ='school_staff';
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata("tid");
            
            $data_array_update=array(
                "salutation"=>$salutation,
                "name"=>$teacher_name,
                "mobile_number"=>$mobile_number,
                "alt_mobile_number"=>$alt_mobile_number,
                "email"=>$email,
                "address"=>$address,
                "permanent_address"=>$permanent_address,
                "gender"=>$gender,
                "dob"=>$dob,
                "designation"=>$designation,
                "profile_pic"=>$user_profile_picture,
                "signature"=>$signature,
                "password"=>$mobile_number,
                "user_status"=>$status,
                "staff_category"=>$staff_category,
                "updated_at"=>$cat,
                "updated_by"=>$tid
            );
            
            
            $permission_array=array(
                "emp_id"=>$staff_id,
                "accounts"=>$accounts,
                "student_attendance"=>$student_attendance,
                "staff_attendance"=>$staff_attendance,
                "courses"=>$courses,
             	"enquiry"=>$enquiry,
             	"admission"=>$admission,
             	"fee_structure"=>$fee_structure,
             	"exam"=>$exam,
             	"fee"=>$fee,
             	"documents"=>$documents,
             	"staff"=>$staff,
             	"transport"=>$transport,
             	"students"=>$students,
             	"fee_defaulter"=>$fee_defaulter,
             	"delete_fee_invoice"=>$delete_fee_invoice,
             	"delete_student"=>$delete_student,
             	"acedemic_session"=>$acedemic_session_permission,
             	"circular"=>$circular,
                "admin"=>$admin,
                "time_table"=>$time_table,
                "edit_fee"=>$edit_fee,
                "back_date_fee"=>$back_date_fee,
             	"created_at"=>$cat,
             	"created_by"=>$tid,
             	"updated_at"=>$cat,
             	"updated_by"=>$tid
            );
            
            $permission_update_array=array(
                "emp_id"=>$staff_id,
                "accounts"=>$accounts,
                "student_attendance"=>$student_attendance,
                "staff_attendance"=>$staff_attendance,
                "courses"=>$courses,
             	"enquiry"=>$enquiry,
             	"admission"=>$admission,
             	"fee_structure"=>$fee_structure,
             	"exam"=>$exam,
             	"fee"=>$fee,
             	"documents"=>$documents,
             	"staff"=>$staff,
             	"transport"=>$transport,
             	"students"=>$students,
             	"fee_defaulter"=>$fee_defaulter,
             	"delete_fee_invoice"=>$delete_fee_invoice,
             	"delete_student"=>$delete_student,
             	"acedemic_session"=>$acedemic_session_permission,
             	"circular"=>$circular,
                "admin"=>$admin,
                "time_table"=>$time_table,
                "edit_fee"=>$edit_fee,
                "back_date_fee"=>$back_date_fee,
             	"updated_at"=>$cat,
             	"updated_by"=>$tid
            );
            
            $staff_table="school_staff";
            $staff_permission_table="staff_permissions";
            $get_staff_data=$this->SchoolModel->get_item_data($staff_id,$staff_table);
            if($get_staff_data){
                $update_staff_data=$this->SchoolModel->update_item_data($staff_id,$staff_table,$data_array_update);
                if($update_staff_data){
                    $usertype="staff";
                    $login_credential_data_array_update=array(
                        "Name"=>$teacher_name,
                        "username"=>$mobile_number,
                        "mob_number"=>$mobile_number,
                        "uat"=>$cat,
                        "upd_by"=>$tid
                    );
                    $login_credential_table="login_credentials";
                    $update_staff=$this->SchoolModel->update_staff_login_data($staff_id,$usertype,$login_credential_data_array_update,$login_credential_table);
                    if($update_staff){
                        
                    }
                    
                    $check_permission_data_exists=$this->SchoolModel->get_staff_permissons($staff_id,$staff_permission_table);
                    if($check_permission_data_exists){
                        $update_permission_data=$this->SchoolModel->update_permission_data($staff_id,$staff_permission_table,$permission_update_array);
                        $data['success']="Staff information updated successfully.";
                    }else{
                        $add_permissions=$this->SchoolModel->insert_data($staff_permission_table,$permission_array);
                        $data['success']="Staff information updated successfully.";
                    }
                    
                    
                }else{
                    $data['error']="Error in updating information.";
                }
            }else{
                
            }
        }
        
        $this->load->view('erp/header');   
        // $this->load->view('erp/staff-nav');  
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/feemanagement/edit-teachers',$data);    
        $this->load->view('erp/footer');
    }
    
    
    public function view_staff(){
        $this->load->view('erp/header');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/view-teachers');    
        $this->load->view('erp/footer');       
    }    
    
    public function update_staff_credentials(){
        $data['success']="";
        $data['error']="";
        $userid=$this->session->userdata('tid');
        if(isset($_POST['update_staff_credentials'])){
            $id=$_POST['id'];
            $password=trim($_POST['password']);
            $cpassword=trim($_POST['cpassword']);
            
            if($password == $cpassword && strlen($password) >=6){
                $new_password=md5($password);
                $cat=date('Y-m-d H:i:s');
                // $userid=$this->session->userdata('tid');
                // $userid=$this->
                $usertype="staff";
                $data_array_update=array("password"=>$new_password,"updated_at"=>$cat,"updated_by"=>$userid);
                $table="login_credentials";
                $school_staff_table="school_staff";
                // $update_credentials=$this->SchoolModel->update_staff_credentials($userid,$usertype,$data_array_update,$table);
                $update_credentials=$this->SchoolModel->update_item_data($id,$school_staff_table,$data_array_update);
                if($update_credentials){
                    $data['success']="Password Updated Successfully";
                }
            }else{
                if($password != $cpassword  && strlen($password) < 6){
                    $data['error']="Password and Confirm Password and Password Length should be minimum 6. Not Matching Try Again";
                }
                else if($password == $cpassword){
                    $data['error']="Password and Confirm Password Not Matching Try Again";
                }else if(strlen($password) < 6){
                    $data['error']="Password Length should be minimum 6. Try Again";
                }
            }
        }
        
        $this->load->view('erp/header');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/update-staff-credentials',$data);    
        $this->load->view('erp/footer');
    }
    
    public function all_active_staff(){
        $this->load->view('erp/header');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/all-active-staff');    
        $this->load->view('erp/footer');
    }
    public function staff($id){
        $this->load->view('erp/header');   
        // $this->load->view('erp/staff-nav'); 
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/view-teacher-profile');    
        $this->load->view('erp/footer');           
    }

    public function add_class_teacher(){
        $data['success'] =""; $data['error'] ="";    
        if(isset($_POST['add_class_teacher'])){
            $course_id=$_POST['course_id'];
            $section=$_POST['section'];
            $teacher=$_POST['teacher'];
            $acedemic_session=$this->session->userdata('acedemic_session');
            $table='school_classes_structure';
            
            $class='';
            $courses_table='courses';
            $get_course_info=$this->SchoolModel->get_item_data($course_id,$courses_table);
            if($get_course_info){
                foreach($get_course_info as $course_info){
                    $class=$course_info['course'];
                }
            }
            $cat=date("Y-m-d H:i:s");
            $userid=$this->session->userdata("tid");
            $data_array  =array("acedemic_session"=>$acedemic_session,"class"=>$class,"section"=>$section,"class_teacher"=>$teacher,"created_at"=>$cat,"created_by"=>$userid,"updated_at"=>$cat,"updated_by"=>$userid);
            // $check_class_section_teacher =$this->SchoolModel->check_class_section($acedemic_session,$course_id,$class,$section,$table);

            // if($check_class_section_teacher ){
                $check_class_teacher =$this->SchoolModel->check_teacher_duplicacy($acedemic_session,$course_id,$class,$section,$teacher);    
                if($check_class_teacher){
                    $data['error']="Already Section Alloted.";    
                }else{
                    
                    $add_class_teacher= $this->SchoolModel->insert_data($table,$data_array);
                    // $update_class_teacher=$this->SchoolModel->update_class_teacher($acedemic_session,$course_id,$class,$section,$teacher,$table);    
    
                    // $updt = $this->SchoolModel->update_class_teacher_profile($course_id,$class,$section,$teacher);
                    if($add_class_teacher){
                        $data['success']="Updated Successfully";    
                    }    
                }    


            // }else{
    
                // $check_class_teacher =$this->SchoolModel->check_teacher_duplicacy($acedemic_session,$course_id,$class,$section,$teacher,$table);    

                // if($check_class_teacher == 1){
                //     $data['error']="Already Section Alloted.";    
                // }else{
                //     $add_class_teacher= $this->SchoolModel->add_class_teacher($table,$data_array); 
                //     $updt = $this->SchoolModel->update_class_teacher_profile($course_id,$class,$section,$teacher);

                //     if($add_class_teacher){
                //         $data['success']="Added Successfully";      
                //     }
    
                // }    
    

            // }
        }

    
        $this->load->view('erp/header');   
        // $this->load->view('erp/staff-nav');  
        $this->load->view('erp/sidebar');
        $this->load->view('erp/add-class-teacher',$data);    
        $this->load->view('erp/footer');       
    }

    public function active_inactive_teacher(){
        $val=$_POST['val'];
        $id=$_POST['id'];
        $table=$_POST['table'];
        if($val==0){$status=1;}else if($val==1){$status=0;}
        $usertype='staff';

        $update_status=$this->SchoolModel->update_teacher_login_status($status,$id,$table);

        $update_login_credentials=$this->SchoolModel->update_login_credentials($status,$id,$usertype);



        if($update_status && $update_login_credentials){
            echo "Login Status  Updated Successfully";    
        }

    }

    public function official_permissions(){
        $data['success']=''; $data['error']='';

    
        if(isset($_POST['add_to_official'])){
            $permission_type=$this->input->post('permission_type'); 
            $staff=$this->input->post('staff');

            $table='school_staff';
            $official_permission=$this->SchoolModel->official_permission($permission_type,$staff,$table);
            if($official_permission){
                $data['success']='Added Successfully';
            }else{
                $data['error']='Error in updation';    
            }

        }    
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/official-permissions',$data);
        $this->load->view('erp/footer'); 
    }




    public function remove_admin(){

        if($this->session->userdata('admin')==1  ||  $this->session->userdata('all_permission')==1){}else{
            redirect(base_url().'login/');    
        }
        $tid=$_POST['tid'];
        $table='school_staff';
        $remove_admin=$this->SchoolModel->remove_admin($tid,$table);
        if($remove_admin){
            echo "Admin removed Successfully.";}
        }


    public function remove_management(){
            if($this->session->userdata('admin')==1  ||  $this->session->userdata('all_permission')==1){
                
            }else{
                redirect(base_url().'login/');    
            }
            $tid=$_POST['tid'];
            $table='school_staff';
            $remove_admin=$this->SchoolModel->remove_management($tid,$table);
            if($remove_admin){echo "Admin removed Successfully.";}    
    }

    public function remove_fee_admin(){
        if($this->session->userdata('admin')==1  ||  $this->session->userdata('all_permission')==1){}else{
            redirect(base_url().'login/');    
        }
        $tid=$_POST['tid'];
        $table='school_staff';
        $remove_admin=$this->SchoolModel->remove_fee_admin($tid,$table);
        if($remove_admin){echo "Admin removed Successfully.";}        
    }


    public function remove_document_admin(){
        if($this->session->userdata('admin')==1  ||  $this->session->userdata('all_permission')==1){}else{
            redirect(base_url().'login/');    
        }
        $tid=$_POST['tid'];
        $table='school_staff';
        $remove_admin=$this->SchoolModel->remove_document_admin($tid,$table);
        if($remove_admin){echo "Admin removed Successfully.";}        
    }    
    
    
    
    public function duplicate_fees(){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/new/sidebar');
        $this->load->view('erp/duplicate-fees');
        $this->load->view('erp/footer');
    }



    public function active_inactive_student(){
        $val=$_POST['val'];
        $id=$_POST['id'];
        $reason=$_POST['reason'];
        $table=$_POST['table'];
        if($val==0){$status=1;}else if($val==1){$status=0;}
    
        $usertype='student';
        $update_status=$this->SchoolModel->update_student_status($status,$id,$reason,$table);
        $update_login_credentials=$this->SchoolModel->update_login_credentials($status,$id,$usertype);
        if($update_status && $update_login_credentials){
            echo "Status  Updated Successfully";    
        }   
    }

    public function attendance(){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/attendance');
        $this->load->view('erp/footer');  
    }

    public function class_attendance_log($class,$section){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/new/sidebar');
        $this->load->view('erp/attendance/class-wise-attendance');
        $this->load->view('erp/footer');    
    }

    public function make_attendance_open(){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/new/sidebar');
        $this->load->view('erp/attendance/open_attendance');
        $this->load->view('erp/footer');
    
    }
    public function mark_open(){
        $date=$_POST['edate'];
        $eclass=$_POST['eclass'];
        $section=$_POST['section'];
    
        $tid=$this->session->userdata('tid');
        $cat=date('Y:m:d H:i:s');
        $make_open=$this->AttendenceModel->make_open_attendance($date,$eclass,$section);
        $add_log=$this->AttendenceModel->add_log($date,$eclass,$section,$tid,$cat);
        if($make_open>0){
            echo $make_open;    
        }
    }

    public function attendance_history(){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/attendance-history-calender');
        $this->load->view('erp/footer');    
    }
    public function draw_attendance_history_calendar(){
        $month =$_POST['month'];
        $year =$_POST['year'];
        $d=1;
        $month_name = date("F", mktime(0, 0, 0, $month, 10));	
        $calendar='';
        $calendar .='<div class="table-responsive">';
        $calendar.="".$month_name."-".$year."";  
	    $calendar .= '<table  class="table table-bordered calendar">';
        /* table headings */
        $headings = array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
        $calendar.= '<tr class="calendar-row"><td class="calendar-day-head">'.implode('</td><td class="calendar-day-head">',$headings).'</td></tr>';
    
	    /* days and weeks vars now ... */
        $running_day = date('w',mktime(0,0,0,$month,1,$year));
        $days_in_month = date('t',mktime(0,0,0,$month,1,$year));
        $days_in_this_week = 1;
        $day_counter = 0;
        $dates_array = array();
    
	    /* row for week one */
        $calendar.= '<tr class="calendar-row">';
        
	    /* print "blank" days until the first of the current week */
	    for($x = 0; $x < $running_day; $x++):
    		$calendar.= '<td class="calendar-day-np"> </td>';
		    $days_in_this_week++;
	    endfor;
    
	    /* keep going with days.... */
	    for($list_day = 1; $list_day <= $days_in_month; $list_day++):
    		$calendar.= '<td class="calendar-day"><a href="'.base_url().'Management/attendance_log/'.$list_day.'/'.$month.'/'.$year.'">';
			/* add in the day number */
			
			$check_holiday=$this->CalenderModel->check_holiday_date($list_day,$month,$year);
			if($check_holiday){
			    foreach($check_holiday as $holiday){
			    $calendar .='<div class="event  text-danger text-center  font-weight-bold width:70%;">'.$holiday['holiday_detail'].'</div>';    
			    }
			    }
			    
			$calendar.= '<div class="day-number">'.$list_day.'</div>';

			/** QUERY THE DATABASE FOR AN ENTRY FOR THIS DAY !!  IF MATCHES FOUND, PRINT THEM !! **/
			$calendar.= str_repeat('<p> </p>',2);
			
	    	$calendar.= '</a></td>';
    		if($running_day == 6):
			    $calendar.= '</tr>';
			    if(($day_counter+1) != $days_in_month):
    				$calendar.= '<tr class="calendar-row">';
			    endif;
			    $running_day = -1;
			    $days_in_this_week = 0;
		    endif;
		    $days_in_this_week++; $running_day++; $day_counter++;
	    endfor;

	    /* finish the rest of the days in the week */
	    if($days_in_this_week < 8):
    		for($x = 1; $x <= (8 - $days_in_this_week); $x++):
			    $calendar.= '<td class="calendar-day-np"> </td>';
		    endfor;
	    endif;

	    /* final row */
	    $calendar.= '</tr>';

    	/* end the table */
    	$calendar.= '</table></div>';
	
    	$calendar .='<div class="table-responsive">
    	<table class="table table-bordered table-striped"><tbody>';
        $check_holiday=$this->CalenderModel->get_holidays_in_month($month,$year);
        if($check_holiday){
	        foreach($check_holiday as $holiday){
	            $calendar .='<tr>
	                <th>'.date('d-M-Y',strtotime($holiday['holiday_date'])).'</th>
	                <td>'.$holiday['holiday_detail'].'</td>
	            </tr>';
	        }
        }
	            $calendar .='</tbody>
	        </table
	    <div>';
	
	
	    /* all done, return result */
	    echo $calendar;    
    }


    public function attendance_log($day,$month,$year){
        $this->load->view('erp/header');    
        $this->load->view('erp/sidebar');
        $check_holiday=$this->CalenderModel->check_day_holiday($day,$month,$year);    
        if($check_holiday){
            foreach($check_holiday as $holiday){
                $date=$holiday['holiday_date'];
                // echo $holiday['holiday_detail'];
                $this->load->view('erp/management/holiday-view');
            }    
        }else{
            $this->load->view('erp/management/day-attendance');
        }
        $this->load->view('erp/footer');    
    }

    public function attendance_update(){ 
        $get_rows=$this->AttendenceModel->get_attendance_row();
        $count=0;
        if($get_rows){
            foreach($get_rows as $get_row){
                $a_date=$get_row['date'];
                $d=date('d',strtotime($a_date));
                $m=date('m',strtotime($a_date));
                $y=date('Y',strtotime($a_date));
                $id=$get_row['id'];
                $data_array=array("day"=>$d,"month"=>$m,"year"=>$y);
                $update_attendance=$this->AttendenceModel->attendance_dmy_update($id,$data_array);
                if($update_attendance){
                    $count ++;    
                }
            }
        }

        echo $count;    
    }


    public function publish_circular(){
        $data1['success'] = ''; $data1['error'] = '';
        if(isset($_POST['edit'])){
            $data1['data'] = $_POST['edit'];
        }

        $attachment_file='';
        if(isset($_POST['circular_submit'])){
            $id = $this->input->post('id');  
            $subject = htmlspecialchars($this->input->post('subject'));
            $notice_community=$this->input->post('notice_community');
            $circular_content=htmlspecialchars($this->input->post('circular_content'));
            $attachment_type=$this->input->post('circular_attachment');
            // $attachment_file_old=$this->input->post('attachment_file_old');
    


            $config['file_ext_tolower'] =TRUE;
            $config['encrypt_name'] =TRUE;
            $config['upload_path']= './assets/circular/';
            $config['allowed_types']= 'jpeg|jpg|png|mp4';
            $config['max_size']= 5120;
            // $config['max_width']= 1024;
            // $config['max_height']= 768;
    
            $this->load->library('upload', $config);

            if ( ! $this->upload->do_upload('attachment_file')){
                    // $data['error1'] = array('error' => $this->upload->display_errors());
                    $data['error1']='Error in uploading image';
            }else{
                $data1 = array('upload_data' => $this->upload->data());
                foreach($data1 as $img_data){
                    $attachment_file=''.base_url().'assets/circular/'.$img_data['file_name'].'';
                }
            }

            $cat=date('Y-m-d-h-i-s');
            $table='circular';
            $data_array=array("subject"=>$subject,"notice_community"=>$notice_community,"message"=>$circular_content,"attachment_type"=>$attachment_type,"attachment"=>$attachment_file,"cat"=>$cat);
            $publish_circular=$this->SchoolModel->publish_circular($data_array,$table);    
            if($publish_circular){
                $data1['success']="Circular Published Successfully";
                redirect(base_url().'School/circular');
            }else{
                $data1['error']="Error in adding circular";
    
            }
        }

        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/circular/add-circular',$data1);
        $this->load->view('erp/footer');
    }
    public function all_circulars(){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/new/sidebar');
        $this->load->view('erp/all-circular');
        $this->load->view('erp/footer');
    }

    public function circular($id){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/new/sidebar');
        $this->load->view('erp/circular');
        $this->load->view('erp/footer');    
    }
    public function attendance_detail($date,$tid){
        // echo $date;
        // if($this->session->userdata('class_teacher')!=''){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/attendance-detail');
        $this->load->view('erp/footer');    
    }
    
    public function class_date_wise_attendance_pdf($date,$tid,$class,$section){
        $title='Class-'.$class.'-'.$section.'-'.$date.'-Attendance';
        $this->load->view('erp/management/class_date_wise_attendance_pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "5120M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }
    
    public function all_courses_attendance_report(){
        $title="Attendance-report";
        $this->load->view('erp/management/all-class-attendance-report-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "5120M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }
    public function all_courses(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/all-courses');
        $this->load->view('erp/footer');    
    }

    public function students($course){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/course_students');
        $this->load->view('erp/footer');    
    }

    public function promote_students($course,$section){
        $acedemic_session=2;
        $ac_year='2021-2022';
        $new_course='10';
        $count =0;
        $active_s=0;
        $course_count=0;
        $acedemic_session_1=$this->session->userdata('acedemic_session');
        $fetch_all_student_for_class = $this->WelcomeModel->get_students_ac_session_by_class($acedemic_session_1,$course,$section);
        if($fetch_all_student_for_class){
            foreach($fetch_all_student_for_class as $students_list){
    
                $table='student';


                $get_student_data=$this->WelcomeModel->get_item_data($students_list['sid'],$table);
                if($get_student_data ){
                    foreach($get_student_data as $students){
                        $sid=$students['id'];
                        if($students['status'] ==1 && $students['class']==$course && $students['section']==$section){
                            // if($students['status'] ==1){
                            $count++;

                            $apr=0;
                            $may=0;
                            $jun=0;
                            $jul=0;
                            $aug=0;
                            $sep=0;
                            $oct=0;
                            $nov=0; 
                            $dec=0;
                            $jan=0; 
                            $feb=0;
                            $mar=0;
    
                            $fee_info=$this->NewFeeModel->get_fee_data_for($students['id'],$acedemic_session_1);
                            if($fee_info){
                                foreach($fee_info as $fee){

                                    if($fee['april']==1){
                                        $apr=$apr + 1;
                                    }
                                    if($fee['may']==1){
                                        $may=$may + 1;
                                    }
                                    if($fee['june']==1){
                                        $jun=$jun + 1;
                                    }

                                    if($fee['july']==1){
                                        $jul=$jul + 1;
                                    }
        
                                    if($fee['august']==1){
                                        $aug=$aug + 1;
                                    }
    
                                    if($fee['september']==1){
                                        $sep=$sep + 1;
                                    }
    
                                    if($fee['october']==1){
                                        $oct=$oct + 1;
                                    }

                                    if($fee['november']==1){
                                        $nov=$nov + 1;
                                    }


                                    if($fee['december']==1){
                                        $dec=$dec + 1;
                                    }   


                                    if($fee['january']==1){
                                        $jan=$jan + 1;
                                    }


                                    if($fee['february']==1){
                                        $feb=$feb + 1;
                                    }


                                    if($fee['march']==1){   
                                        $mar=$mar + 1;
                                    }

                                }
                            }

                        if($apr == 1 && $may ==1 && $jun ==1 && $jul ==1 && $aug ==1 && $sep==1 && $oct==1 && $nov ==1 && $dec ==1 && $jan==1 && $feb==1 && $mar ==1){
                            $active_s=$active_s + 1;


                            $data_array=array("sid"=>$students['id'],"acedemic_session"=>$acedemic_session,"class"=>$new_course,"section"=>$students['section'],"ac_year"=>$ac_year);
                            print_r($data_array);echo "<br>";

                            $check_student=$this->DeveloperModel->check_student_session($sid,$acedemic_session);
                            if($check_student){
                                echo "Already Added";
                            }else{
                                $course_table='student_courses_data';
                                $add_student_course=$this->DeveloperModel->insert_data($data_array,$course_table);
    
                                if($add_student_course){
                                    $course_count=$course_count + 1;    
                                    $students_data_array=array("class"=>$new_course);
                                    $student_table='student';
                                    $update__student_data=$this->DeveloperModel->update_data($students_data_array,$sid,$student_table);
                                    if($update__student_data){
                                        echo "Added<br>";
                                    }
                                }


                            }


                        }


                    }

                }
            }


            }
        }
        echo "Fee Paid :";
        echo $active_s;
        echo "<br>";
            echo "Active Students:";echo $count;
    }

    public function view_class_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/view-class-students');
        $this->load->view('erp/footer');
    }
    

    public function all_staff(){
        $this->load->view('erp/header');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/all-staff');    
        $this->load->view('erp/footer');   
    }

    public function drop_out_list(){
        $this->load->view('erp/header');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/drop-out-list');
        $this->load->view('erp/footer');   
    }

    public function change_academic_session(){
        $data['success']='';   $data['error']='';

        if(isset($_POST['change_ac_session'])){
            $new_course=$this->input->post('new_course');
            $new_section=$this->input->post('new_section');
            $new_acedemic_session=$this->input->post('new_acedemic_session');
            $tid=$this->session->userdata('tid');
            $cat=date('Y-m-d H:i:s');
            $sid=$this->input->post('sid');
            $data_array_update=array("class"=>$new_course,"section"=>$new_section);
            $data_array=array("sid"=>$sid,"acedemic_session"=>$new_acedemic_session,"class"=>$new_course,"section"=>$new_section,"ac_year"=>"2021-2022","cat"=>$cat,"promoted_by"=>$tid);
            $check_student_exist=$this->WelcomeModel->get_student_in_acedemic_session($sid,$new_acedemic_session);
            if($check_student_exist){
                $data['error']="Already Added";
            }else{
                $table='student_courses_data';
                $add_to_new_session=$this->WelcomeModel->insert_data($data_array,$table);
                if($add_to_new_session){
                    $table_student='student';
                    $update_student_data=$this->WelcomeModel->update_item_data($data_array_update,$sid,$table_student);
                    if($update_student_data){
                        $data['success'] ="Student Promoted successfully.";
                    }
                }
            }
    
    
        }

        $this->load->view('erp/header');   
        $this->load->view('erp/sidebar');
        $this->load->view('erp/management/change_academic_session',$data);
        $this->load->view('erp/footer');     
    }

    public function view_class_students_pdf($tid,$course,$section){
        $title='Class-'.$course.'-'.$section;
        $this->load->view('erp/teachers/view-class-students-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "5120M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }
}
?>