<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Holiday extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('StudentModel');
        $this->load->model('AttendenceModel');
        $this->load->model('NewFeeModel');
        $this->load->model('CalenderModel');
        $this->load->model('WelcomeModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
    }
    
    public function index(){
        $data['success']=""; $data['error']="";
        if(isset($_POST['add_holiday'])){
            $holiday_date=$_POST['holiday_date'];
            $holiday_detail=$_POST['holiday_detail'];
            $academic_session=$_POST['academic_session'];
            $cat=date("Y-m-d H:i:s");
            $tid=$this->session->userdata("tid");
            $table="school_calender";
            
            $ac_sess_table="academic_session_details";
            $get_ac_sess_info=$this->CalenderModel->get_item_data($academic_session,$ac_sess_table);
            $academic_year="";
            if($get_ac_sess_info){
                foreach($get_ac_sess_info as $sess_info){
                    $academic_year=$sess_info["year_long"];        
                }
            }
            
            $day=date("d",strtotime($holiday_date));
            $month=date("m",strtotime($holiday_date));
            $year=date("Y",strtotime($holiday_date));
            $data_array=array(
                "academic_session"=>$academic_session,
                "academic_year"=>$academic_year,
                "holiday_date"=>$holiday_date,
                "holiday_detail"=>$holiday_detail,
                "day"=>$day,
                "month"=>$month,
                "year"=>$year,
                "created_at"=>$cat,
                "created_by"=>$tid,
                "updated_at"=>$cat,
                "updated_by"=>$tid
            );
            
            $check_holiday=$this->CalenderModel->check_holiday($holiday_date,$table);
            if($check_holiday){
                $data['error']="Holiday already exists";
            }else{
                $add_holiday=$this->CalenderModel->insert_holiday($data_array,$table);
                if($add_holiday){
                    $data['success']="Holiday Record Added Successfully.";
                }
            }
        }
        
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/holiday/all-holidays',$data);
        $this->load->view('erp/footer');
    }
    
    public function view(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/holiday/all-holiday-view');
        $this->load->view('erp/footer');
    }
    
}