<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fee extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('OpeningBalanceModel');
        $this->load->model('InvoiceModel');
        $this->load->model('LedgerModel');
        $this->load->model('TransportModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
        $this->load->library("pagination");
    }

    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/dashboard');
        $this->load->view('erp/footer');
    }
    
    public function open_scanner(){
        if(isset($_POST['scan_barcode'])){
            $userid=$_POST['userid'];
            $sid=substr($userid,5);
            if($userid !=''){
                redirect(base_url().'Fee/pay/'.$sid);    
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/scan-students');
        $this->load->view('erp/footer');
    }

    public function dashboard(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/fee-dashboard');
        $this->load->view('erp/footer');
    }

    public function heads(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
         $this->load->view('erp/new-fee/new-fee-heads');
        // $this->load->view('erp/new-fee/fee-heads');
        $this->load->view('erp/footer');
    }
    
    public function edit_fee_head(){
        
        $data['success']='';
        $data['error']='';
        if(isset($_POST['update_fee_head'])){
            $id=$_POST['id'];
            $academic_session=$_POST['academic_session'];
            $fee_head=$_POST['fee_head'];
            $fee_type=$_POST['fee_type'];
            $status=$_POST['status'];
            $cat=date("Y-m-d H:i:s");
            $tid=$this->session->userdata("tid");
            
            
            $data_array_update=array("title"=>$fee_head,"status"=>$status,"acedemic_session"=>$academic_session,"updated_at"=>$cat,"updated_by"=>$tid);
            $table="fee_heads";
            $update_fee_head_data=$this->NewFeeModel->update_item_data($id,$data_array_update,$table);
            if($update_fee_head_data){
                $data['success']="Fee head information updated successfully.";
            }else{
                $data['error']='Error while updating fee head information !';
            }
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
         $this->load->view('erp/new-fee/edit-fee-head',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_new_fee_head(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_fee_head'])){
        $acedemic_session=$this->input->post('acdemic_session');
        $fee_head=$this->input->post('fee_head');
        $fee_type=$this->input->post('fee_type');
        // $courses_table='courses';
        // $get_courses=$this->NewFeeModel->get_data($courses_table);
        // if($get_courses){
        // foreach($get_courses as $courses){
        // $course=$courses['course'];
        $data_array=array("acedemic_session"=>$acedemic_session,"title"=>$fee_head,"fee_type"=>$fee_type);

        // }
        // }
        $table='fee_heads';
        $check_fee_head_exist=$this->NewFeeModel->check_fee_head_exist($acedemic_session,$fee_head,$table);
        if($check_fee_head_exist){
            $data['error']="Fee Head Already Exist";
        }else{
            $add_fee_head=$this->NewFeeModel->insert_data($data_array,$table);
            if($add_fee_head){
                $data['success']='Fee Head Added Successfully';
            }else{
                $data['error']='Error in adding fee head';
            }
        }

    }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/add-fee-head',$data);
        $this->load->view('erp/footer');
    }

    public function structure(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/all-courses-fee-structure');
        $this->load->view('erp/footer');
    }

    public function add_acedemic_session(){

        $data['success']='';
        $data['error']='';
        if(isset($_POST['add_academic_session'])){
            $y1=$this->input->post('y1');
            $y2=$this->input->post('y2');
            $full_session=$this->input->post('full_session');
            $short_session=$this->input->post('short_session');
            $data_array=array("year_long"=>$full_session,"year_short"=>$short_session,"y1"=>$y1,"y2"=>$y2);
            $table='academic_session_details';
            $check_session_exist=$this->NewFeeModel->check_session_exist($y1,$y2);
        if($check_session_exist){

            $data['error'] ='Already Exist';    
        }else{

                $add_session=$this->NewFeeModel->insert_data($data_array,$table);
                if($add_session){
                    $data['success']='Added Successfully';
                }else{
                    $data['error']='Error in adding session';
                }

            }

        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/add_acedemic_session',$data);
        $this->load->view('erp/footer');
    }
    public function all_acedemic_sessions(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/all_acedemic_sessions');
        $this->load->view('erp/footer');
    }



    public function add_fee_structure($fee_head){
        $data['success']='';
        $data['error']='';
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/add-fee',$data);
        $this->load->view('erp/footer');
    }

    public function add_fee_structure_monthly(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/add-fee-monthly');
        $this->load->view('erp/footer');
    }


    public function add_structure(){
        $ac_session=$_POST['ac_session']; 
        $course=$_POST['course']; 
        $course_id=$_POST['course_id'];
        $fee_head_id=$_POST['fee_head_id'];
        $fee_value =$_POST['fee_value']; 
    
        $status_4=$_POST['status_4']; 
        $status_5=$_POST['status_5']; 
        $status_6=$_POST['status_6']; 
        $status_7 = $_POST['status_7']; 
        
        $status_8=$_POST['status_8'];
        $status_9=$_POST['status_9'];
        $status_10=$_POST['status_10'];
        $status_11=$_POST['status_11'];
        
        $status_12=$_POST['status_12'];
        $status_1=$_POST['status_1'];
        $status_2=$_POST['status_2'];
        $status_3=$_POST['status_3'];
    
        $check_data_exist=$this->NewFeeModel->check_fee_structure_exist_for_course_id($course_id,$ac_session,$fee_head_id);
        if($check_data_exist){
            // echo "Update data !";
            $data_array_update=array("amount"=>$fee_value,"april"=>$status_4,"may"=>$status_5,"june"=>$status_6,"july"=>$status_7,"august"=>$status_8,"september"=>$status_9,"october"=>$status_10,"november"=>$status_11,"december"=>$status_12,"january"=>$status_1,"february"=>$status_2,"march"=>$status_3,);
            $table='fee_structure';
            $update_fee_structure=$this->NewFeeModel->update_fee_structure($ac_session,$course_id,$fee_head_id,$data_array_update);
            if($update_fee_structure){
                echo "Updated Successfully";
            }
        }else{
            $data_array=array("acedemic_session"=>$ac_session,"course"=>$course,"course_id"=>$course_id,"fee_head"=>$fee_head_id,"amount"=>$fee_value,"april"=>$status_4,"may"=>$status_5,"june"=>$status_6,"july"=>$status_7,"august"=>$status_8,"september"=>$status_9,"october"=>$status_10,"november"=>$status_11,"december"=>$status_12,"january"=>$status_1,"february"=>$status_2,"march"=>$status_3,);
            $table='fee_structure';
            $add_fee_structure=$this->NewFeeModel->insert_data($data_array,$table);
            if($add_fee_structure){
                echo "Added Successfully";
            }
        }
    }


    public function all_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/all-students');
        $this->load->view('erp/footer');
    }

    public function pay(){
        $data['error']='';$data['success']='';
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }

        if(isset($_POST['opening_balance_submit'])){
            $sid=$this->input->post('sid');
            $opening_fee_amount=$this->input->post('opening_fee_amount');
            $fee_for_ac_sess=$this->input->post('fee_for_ac_sess');
            
            $fee_note=$this->input->post('fee_note');
            $table='opening_balance';
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $data_array=array("fee_note"=>$fee_note,"sid"=>$sid,"opening_fee_amount"=>$opening_fee_amount,"cat"=>$cat,"cat_by"=>$tid,"fee_for_ac_sess"=>$fee_for_ac_sess);
            $check_opening_balance=$this->OpeningBalanceModel->check_opening_balancce($sid);
            if($check_opening_balance){
                foreach($check_opening_balance as $opening_balance){
                    
                }
                $data['error']='Already Added';
            }else{
                $add_opening_balance=$this->OpeningBalanceModel->insert_data($data_array,$table);
                if($add_opening_balance){
                    $data['success']='Added Successfully';
                }else{
                    $data['error']='Error in adding opening balance';
                }

            }
        }
        $data['success1']='';  $data['error1']='';
        if(isset($_POST['update_course_id'])){
            
            $sid=$this->input->post('sid');
            $course_id=$this->input->post('course_id');
            $course=$this->input->post('course');
            $acedemic_session=$this->session->userdata('acedemic_session');
            
            
            $check_student_course_data_for_session=$this->NewFeeModel->get_studdents_current_course_data($sid,$acedemic_session);
            if($check_student_course_data_for_session){
                foreach($check_student_course_data_for_session as $course_data){
                    $active_course_id=$course_data['course_id'];
                    $active_course=$course_data['class'];
                    
                    if($course_id ==$active_course_id){
                        $data['error1']='Course is same as old';
                    }else if($course_id !=$active_course_id && $active_course == $course){
                        $data_array_update=array("course_id"=>$course_id);
                        $update_course_data=$this->NewFeeModel->update_course_data($sid,$acedemic_session,$data_array_update);
                        if($update_course_data){
                            $data['success1']='Student Course Updated Successfully';
                        }
                    }
                    
                }
            }
            
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/pay-fee',$data);
        $this->load->view('erp/footer');
    }


    public function get_months(){
        $sid=$_POST['sid'];
        $course=$_POST['course'];
        $acedemic_session=$_POST['acedemic_session'];
        $april =0;
        $may =0;
        $june=0;
        $july=0;
        $august=0;
        $september=0;
        $october=0;
        $november=0;
        $december=0;
        $january=0;
        $february=0;
        $march=0;

        $get_fee_data=$this->NewFeeModel->get_fee_data_for($sid,$acedemic_session);
        if($get_fee_data){
            foreach($get_fee_data as $row){
                if($row['april'] ==1){
                    $april =1;
                }
                if($row['may'] ==1){
                    $may =1;
                }
                if($row['june'] ==1){
                    $june =1;
                }
                if($row['july'] ==1){
                    $july =1;
                }
                if($row['august'] ==1){
                    $august =1;
                }
                if($row['september'] ==1){
                    $september =1;
                }
                if($row['october'] ==1){
                    $october =1;
                }
                if($row['november'] ==1){
                    $november =1;
                }
                if($row['december'] ==1){
                    $december =1;
                }
                if($row['january'] ==1){
                    $january =1;
                }
                if($row['february'] ==1){
                    $february =1;
                }
                if($row['march'] ==1){
                    $march =1;
                }
            }
        }
        
        $new_admission="";
        $get_student_course_data=$this->NewFeeModel->get_student_course_data($sid,$acedemic_session);
        if($get_student_course_data){
            foreach($get_student_course_data as $sc_data){
                $new_admission=$sc_data['new_admission'];
            }
        }

        $april_fee =0;$may_fee =0;$june_fee=0;$july_fee=0;$august_fee=0;$september_fee=0;$october_fee=0;$november_fee=0;$december_fee=0;$january_fee=0;$february_fee=0;$march_fee=0;
        $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session($acedemic_session,$course);
        if($get_fee_structure){
            foreach($get_fee_structure as $fee_structure){
                if($fee_structure['april'] ==1){
                    if($new_admission == "Yes"){
                        $april_fee= $april_fee + $fee_structure['amount'];    
                    }else{
                        if($fee_structure['fee_head'] == 2){
                            
                        }else{
                            $april_fee= $april_fee + $fee_structure['amount'];
                        }
                    }
                    
                }

                if($fee_structure['may'] == 1){
                    $may_fee=$may_fee + $fee_structure['amount'];    
                }

                if($fee_structure['june'] == 1){
                    $june_fee=$june_fee + $fee_structure['amount'];    
                }
    
                if($fee_structure['july'] ==1){
                    $july_fee=$july_fee + $fee_structure['amount'];    
                }

                if($fee_structure['august'] ==1){
                    $august_fee=$august_fee + $fee_structure['amount'];    
                }

                if($fee_structure['september'] ==1){
                    $september_fee=$september_fee + $fee_structure['amount'];    
                }

                if($fee_structure['october'] ==1){
                    $october_fee=$october_fee + $fee_structure['amount'];    
                }

                if($fee_structure['november'] ==1){
                    $november_fee=$november_fee + $fee_structure['amount'];    
                }

                if($fee_structure['december'] ==1){
                    $december_fee=$december_fee + $fee_structure['amount'];    
                }
                if($fee_structure['january'] ==1){
                    $january_fee=$january_fee + $fee_structure['amount'];    
                }
                if($fee_structure['february'] ==1){
                    $february_fee=$february_fee + $fee_structure['amount'];    
                }
                if($fee_structure['march'] ==1){
                    $march_fee=$march_fee + $fee_structure['amount'];    
                }
            }
        }
        
        if($april ==0){
            echo "
            <div class='month-item'>
                <label class='form-group-1'>Apr
                    <input type='checkbox' name='4'  value='".$april_fee."' class='fee' id='4' month='april' onclick='myFunction()'>
                    <span class='checkmark'></span>
                    <span value=".$april_fee." class='4' id='april'></span>
                </label>
            </div> 
            ";    
        }

        if($may == 0){
            echo "
                <div class='month-item'>
                <label class='form-group-1'>May
                <input type='checkbox' name='5'  value='".$may_fee."' class='fee' id='5' month='may' onclick='myFunction()'>
                <span class='checkmark'></span>
                <span value=".$may_fee." class='5' id='May'></span>
                </label>
                </div> 
            ";
        }

        if($june ==0){
            echo "
            <div class='month-item'>
                <label class='form-group-1'>Jun
                <input type='checkbox' name='6'  value='".$june_fee."' class='fee' id='6' month='june' onclick='myFunction()'>
                <span class='checkmark'></span>
                <span value=".$june_fee." class='6' id='June'></span>
                </label>
            </div> 
            ";    
        }   

        if($july ==0){
            echo "<div class='month-item'>
                    <label class='form-group-1'>Jul
                        <input type='checkbox' name='7'  value='".$july_fee."' class='fee' id='7' month='july' onclick='myFunction()'>
                        <span class='checkmark'></span>
                        <span value=".$july_fee." class='7' id='July'></span>
                    </label>
                </div> ";    
        }


        if($august ==0){
            echo "<div class='month-item'>
                    <label class='form-group-1'>Aug
                        <input type='checkbox' name='8'  value='".$august_fee."' class='fee' id='8' month='august' onclick='myFunction()'>
                        <span class='checkmark'></span>
                        <span value='".$august_fee."' class='8' id='August'></span>
                    </label>
                </div>";    
        }

        if($september ==0){
            echo "<div class='month-item'>
                <label class='form-group-1'>Sep
                    <input type='checkbox' name='9'  value='".$september_fee."' class='fee' id='9' month='september' onclick='myFunction()'>
                    <span class='checkmark'></span>
                    <span value=".$september_fee." class='9' id='September'></span>
                </label>
            </div>";    
        }

        if($october ==0){
            echo "<div class='month-item'>
                <label class='form-group-1'>Oct
                    <input type='checkbox' name='10'  value='".$october_fee."' class='fee' id='10' month='october' onclick='myFunction()'>
                    <span class='checkmark'></span>
                    <span value=".$october_fee." class='10' id='October'></span>
                </label>
                </div>";    
        }

        if($november ==0){
            echo "<div class='month-item'>
                <label class='form-group-1'>Nov
                    <input type='checkbox' name='11'  value='".$november_fee."' class='fee' id='11' month='november' onclick='myFunction()'>
                    <span class='checkmark'></span>
                    <span value=".$november_fee." class='11' id='November'></span>
                </label>
            </div>";    
        }

        if($december ==0){
            echo '<div class="month-item">
                <label class="form-group-1">Dec<input type="checkbox" name="12" value="'.$december_fee.'" class="fee" id="12" month="december" onclick="myFunction()"><span class="checkmark"></span></label></div>';    
        }

        if($january ==0){
            echo "<div class='month-item'>
            <label class='form-group-1'>Jan
            <input type='checkbox' name='1'  value='".$january_fee."' class='fee' id='1' month='january' onclick='myFunction()'>
            <span class='checkmark'></span>
            <span value=".$january_fee." class='1' id='january'></span></label></div>";
        }

        if($february ==0){
            echo "<div class='month-item'><label class='form-group-1'>Feb<input type='checkbox' name='2'  value='".$february_fee."' class='fee' id='2' month='february' onclick='myFunction()'><span class='checkmark'></span><span value=".$february_fee." class='2' id='February'></span></label></div>";    
        }

        if($march ==0){
            echo "<div class='month-item'><label class='form-group-1'>Mar<input type='checkbox' name='3'  value='".$march_fee."' class='fee' id='3' month='march' onclick='myFunction()'><span class='checkmark'></span><span value=".$march_fee." class='3' id='March'></span></label></div>";
        }



    }

    public function get_monthly_structure(){

        $acedemic_session=$_POST['acedemic_session'];
        $course=$_POST['course'];

        $status_4=$_POST['status_4'];
        $status_5=$_POST['status_5'];
        $status_6=$_POST['status_6'];

        $status_7=$_POST['status_7'];
        $status_8=$_POST['status_8'];
        $status_9=$_POST['status_9'];

        $status_10=$_POST['status_10'];
        $status_11=$_POST['status_11'];
        $status_12=$_POST['status_12'];

        $status_1=$_POST['status_1'];
        $status_2=$_POST['status_2'];
        $status_3=$_POST['status_3'];
        
        $sid=$_POST['sid'];
        $new_admission="";
        $get_student_course_data=$this->NewFeeModel->get_student_course_data($sid,$acedemic_session);
        if($get_student_course_data){
            foreach($get_student_course_data as $sc_data){
                $new_admission=$sc_data['new_admission'];
            }
        }
        // $month=$_POST['month'];
        $fee_heads_table='fee_heads';
        // $get_all_fee_heads=$this->NewFeeModel->get_ac_session_active_fee_heads($acedemic_session,$fee_heads_table);
        $get_all_fee_heads=$this->NewFeeModel->get_ac_session_active_fee_heads($fee_heads_table);
        $fee_total=0;
        echo "<tr>
            <th>Month</th>";

            $fee_heads_table='fee_heads';
            // $get_all_fee_heads=$this->NewFeeModel->get_ac_session_active_fee_heads($acedemic_session,$fee_heads_table);
            $get_all_fee_heads=$this->NewFeeModel->get_ac_session_active_fee_heads($fee_heads_table);
            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){

                    echo "<th>".$fee_heads['title']."</th>";

                }
            }

            echo "<th>Total</th>";
            echo "</tr>";
    
   
    
            if($status_4 ==1){
                $fee=0;
                echo "<tr>";
                    echo "<td>April</td>";

                if($get_all_fee_heads){
                    foreach($get_all_fee_heads as $fee_heads){
                        $head_id=$fee_heads['id'];
                        $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                        if($get_fee_structure){
                            foreach($get_fee_structure as $fee_structure){

                                if($fee_structure['april'] ==1){
                                    $april_amount=0;
                                    if($new_admission == "Yes"){
                                        $fee = $fee + $fee_structure['amount'];
                                        $april_amount=$april_amount + $fee_structure['amount'];
                                    }else{
                                        if($fee_structure['fee_head'] == 2){
                                            
                                        }else{
                                            $fee = $fee + $fee_structure['amount'];
                                            $april_amount=$april_amount + $fee_structure['amount'];
                                        }
                                    }
                                    
                                    echo "<td>".$april_amount."</td>";
                                }else if($fee_structure['april'] ==0){
                                    echo "<td>-</td>";    
                                }

                            }
                        }

                    }
                }
                echo "<td>".$fee."</td>";
                $fee_total=$fee_total + $fee;
                echo "</tr>";
            }



    
            if($status_5 ==1){
                $fee=0;
                echo "<tr>";
                echo "<td>May</td>";

                if($get_all_fee_heads){
                    foreach($get_all_fee_heads as $fee_heads){
                        $head_id=$fee_heads['id'];
                        $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                        if($get_fee_structure){
                            foreach($get_fee_structure as $fee_structure){

                                if($fee_structure['may'] ==1){
                                    $fee = $fee + $fee_structure['amount'];
                                    echo "<td>".$fee_structure['amount']."</td>";
                                }else if($fee_structure['may'] ==0){
                                    echo "<td>-</td>";    
                                }

                            }
                        }

                    }
                }
                    echo "<td>".$fee."</td>";
                    echo "</tr>";
                    $fee_total=$fee_total + $fee;
            }

    
            if($status_6 ==1){
                $fee=0;
                echo "<tr>";
                echo "<td>June</td>";

                if($get_all_fee_heads){
                    foreach($get_all_fee_heads as $fee_heads){
                        $head_id=$fee_heads['id'];
                        $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                        if($get_fee_structure){
                            foreach($get_fee_structure as $fee_structure){

                                if($fee_structure['june'] ==1){
                                    $fee = $fee + $fee_structure['amount'];
                                    echo "<td>".$fee_structure['amount']."</td>";
                                }else if($fee_structure['june'] ==0){
                                    echo "<td>-</td>";    
                                }

                            }
                        }

                    }
                }
                echo "<td>".$fee."</td>";
                echo "</tr>";
                $fee_total=$fee_total + $fee;
            }


            if($status_7 ==1){
                $fee=0;
                echo "<tr>";
                echo "<td>July</td>";

                if($get_all_fee_heads){
                    foreach($get_all_fee_heads as $fee_heads){
                        $head_id=$fee_heads['id'];
                        $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                        if($get_fee_structure){
                            foreach($get_fee_structure as $fee_structure){
                                if($fee_structure['july'] ==1){
                                    $fee = $fee + $fee_structure['amount'];
                                    echo "<td>".$fee_structure['amount']."</td>";
                                }else if($fee_structure['july'] ==0){
                                    echo "<td>-</td>";
                                }

                            }
                        }

                    }
                }
                echo "<td>".$fee."</td>";
                echo "</tr>";
                
                $fee_total=$fee_total + $fee;
            }



            if($status_8 ==1){
                $fee=0;
                echo "<tr>";
                echo "<td>August</td>";

                if($get_all_fee_heads){
                    foreach($get_all_fee_heads as $fee_heads){
                        $head_id=$fee_heads['id'];
                        $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                        if($get_fee_structure){
                            foreach($get_fee_structure as $fee_structure){

                                if($fee_structure['august'] ==1){
                                    $fee = $fee + $fee_structure['amount'];
                                    echo "<td>".$fee_structure['amount']."</td>";
                                }else if($fee_structure['august'] ==0){
                                    echo "<td>-</td>";    
                            }
                        }
                    }
                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
            
            $fee_total=$fee_total + $fee;
        }


        if($status_9 ==1){
            $fee=0;
            echo "<tr>";
            echo "<td>September</td>";

            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];
                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){
                            if($fee_structure['september'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['september'] ==0){
                                echo "<td>-</td>";
                            }
                        }
                    }
                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
            $fee_total=$fee_total + $fee;
        }

        if($status_10 ==1){
            $fee=0;
            echo "<tr>";
                echo "<td>October</td>";
    
            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];
                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){

                            if($fee_structure['october'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['october'] ==0){
                                echo "<td>-</td>";    
                            }
                        }
                    }
                }
            }   
                echo "<td>".$fee."</td>";
            echo "</tr>";
            
            $fee_total=$fee_total + $fee;
        }


        if($status_11 ==1){
            $fee=0;
            echo "<tr>";
            echo "<td>November</td>";

            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];

                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){

                            if($fee_structure['november'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['november'] ==0){
                                    echo "<td>-</td>";    
                            }

                        }
                    }

                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
                
            $fee_total=$fee_total + $fee;
        }


        if($status_12 ==1){
            $fee=0;
            echo "<tr>";
            echo "<td>December</td>";
        
            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];
                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){
                            if($fee_structure['december'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['december'] ==0){
                                echo "<td>-</td>";
                            }
                        }
                    }
                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
                
            $fee_total=$fee_total + $fee;
        }

        if($status_1 ==1){
            $fee=0;
            echo "<tr>";
            echo "<td>January</td>";
            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];
                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){

                            if($fee_structure['january'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['january'] ==0){
                                echo "<td>-</td>";    
                            }
                        }
                    }
                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
                
            $fee_total=$fee_total + $fee;
        }

        if($status_2 ==1){
            $fee=0;
            echo "<tr>";
            echo "<td>February</td>";

            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];
                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){
                            if($fee_structure['february'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['february'] ==0){
                                echo "<td>-</td>";    
                            }
                        }
                    }
                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
            
            $fee_total=$fee_total + $fee;
        }

        if($status_3 ==1){
            $fee=0;
            echo "<tr>";
            echo "<td>March</td>";
            if($get_all_fee_heads){
                foreach($get_all_fee_heads as $fee_heads){
                    $head_id=$fee_heads['id'];
                    $get_fee_structure=$this->NewFeeModel->course_fee_structure_for_session_with_head($acedemic_session,$course,$head_id);
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){
                            if($fee_structure['march'] ==1){
                                $fee = $fee + $fee_structure['amount'];
                                echo "<td>".$fee_structure['amount']."</td>";
                            }else if($fee_structure['march'] ==0){
                                echo "<td>-</td>";    
                            }
                        }
                    }
                }
            }
            echo "<td>".$fee."</td>";
            echo "</tr>";
            $fee_total=$fee_total + $fee;
        }
        echo "<tr>";
        echo "<th colspan='5'>Total</th>";
        echo "<th>".$fee_total."</th>";
        echo "</tr>";
    }

    public function add_fee(){
            // if($this->session->userdata('fee_permission')!=1){
                // redirect(base_url().'welcome');
            // }     

        $sid = $_POST['sid'];
        $schno = $_POST['schno'];
        $total = $_POST['total'];
        $fee_type = $_POST['fee_type'];
        $x = $_POST['x'];
        $y1 = $_POST['y1'];
        $y2 = $_POST['y2'];
        $table = $_POST['table'];
        $total_months_no = $_POST['total_months_no'];
        $field ="id";
        $fee_date =$_POST['fee_date'];
        // $fee_date=date('Y-m-d',strtotime($fee_date_1));
        $month = date('m',strtotime($fee_date));    
        $day = date('d',strtotime($fee_date)); 
        $year = date('Y',strtotime($fee_date)); 


        $fee_note =$_POST['fee_note'];
        $fee_mode =$_POST['fee_mode'];
        $transaction_info =$_POST['transaction_info'];
        $bill_book_no =$_POST['bill_book_no'];
        $received_amount=$_POST['received_amount'];
        $balance_amount=$_POST['balance_amount'];
        $extra_amount=$_POST['extra_amount'];
        // :received_amount,:balance_amount,extra_amount:
        $balance_amount_status=0;
        $extra_amount_status=0;
        if($balance_amount>0){
            $balance_amount_status=1;
        }

        if($extra_amount>0){
            $extra_amount_status =1;
        }

        // $student_data =$this->NewFeeModel->student_search($field,$sid);

        // if($student_data){
        //     foreach($student_data as $s_data){
        //         $student_class=$s_data['class'];
        //     }    
        // }

        $acedemic_session=$_POST['acedemic_session'];
        $discount_amount = $_POST['discount_amount'];
        $est_amount  =$_POST['est_amount'];
        $status_1 = $_POST['status_1'];
        $status_2 = $_POST['status_2'];
        $status_3 = $_POST['status_3'];
        $status_4 = $_POST['status_4'];
        $status_5 = $_POST['status_5'];
        $status_6 = $_POST['status_6'];
        $status_7 = $_POST['status_7'];
        $status_8 = $_POST['status_8'];
        $status_9 = $_POST['status_9'];
        $status_10 = $_POST['status_10'];
        $status_11 = $_POST['status_11'];
        $status_12 = $_POST['status_12'];
        $cat= date('y-m-d');    
        $cat_time= date('y-m-d H:i:s');
        $tid=$this->session->userdata('tid');


        $check_fee_entry=$this->NewFeeModel->check_fee_entry($sid,$schno,$status_1,$status_2,$status_3,$status_4,$status_5,$status_6,$status_7,$status_8,$status_9,$status_10,$status_11,$status_12,$total,$acedemic_session);
        if($check_fee_entry>0){
            echo "Already Submitted";    
        }else{
            $balance_amount_ref='';
            $extra_amount_ref='';

            $prev_balance_amount_added=0;
            $prev_extra_amount_used=0;
            $get_balance_amount_info=$this->NewFeeModel->get_balance_amount($sid,$fee_type,$acedemic_session);
            if($get_balance_amount_info){
                foreach($get_balance_amount_info as $balance_amount_info){
                    $balance_amount_ref=$balance_amount_info['fee_no'];
                    $prev_balance_amount_added =$prev_balance_amount_added + $balance_amount_info['balance_amount'];
                }
            }

            $get_extra_amount_info=$this->NewFeeModel->get_extra_amount($sid,$fee_type,$acedemic_session);
            if($get_extra_amount_info){
                foreach($get_extra_amount_info as $extra_amount_info){
                    $extra_amount_ref=$extra_amount_info['fee_no'];
                    $prev_extra_amount_used=$prev_extra_amount_used + $extra_amount_info['extra_amount'];
                }
            }
            $course_id='';
            $student_class="";
            $get_student_active_course_info=$this->NewFeeModel->get_studdents_current_course_data($sid,$acedemic_session);
            if($get_student_active_course_info){
                foreach($get_student_active_course_info as $active_course_info){
                    $course_id=$active_course_info['course_id'];
                    $student_class=$active_course_info['class'];
                }
            }

            $data_array=array(
                "course_id"=>$course_id,
                "sid"=>$sid,
                "sch_no"=>$schno,
                "total_amount"=>$total,
                "fee_type"=>$fee_type,
                "months"=>$x,
                "y1"=>$y1,
                "y2"=>$y2,
                "cat"=>$cat,
                "cat_time"=>$cat_time,
                "no_of_months"=>$total_months_no,
                "discount"=>$discount_amount,
                "estimate_amount"=>$est_amount,
                "january"=>$status_1,
                "february"=>$status_2,
                "march"=>$status_3,
                "april"=>$status_4,
                "may"=>$status_5,
                "june"=>$status_6,
                "july"=>$status_7,
                "august"=>$status_8,
                "september"=>$status_9,
                "october"=>$status_10,
                "november"=>$status_11,
                "december"=>$status_12,
                "month"=>$month,
                "day"=>$day,
                "year"=>$year,
                "student_class"=>$student_class,
                "fee_date"=>$fee_date,
                "txn_no"=>$transaction_info,
                "payment_mode"=>$fee_mode,
                "fee_note"=>$fee_note,
                "bill_book_no"=>$bill_book_no,
                "acedemic_session"=>$acedemic_session,
                "received_amount"=>$received_amount,
                "extra_amount"=>$extra_amount,
                "balance_amount"=>$balance_amount,
                "balance_amount_status"=>$balance_amount_status,
                "balance_amount_added"=>$prev_balance_amount_added,
                "balance_amount_added_refrence"=>$balance_amount_ref,
                "extra_amount_status"=>$extra_amount_status,
                "extra_amount_used"=>$prev_extra_amount_used,
                "extra_amount_used_refrence"=>$extra_amount_ref,
                "tid"=>$tid);
            $add_fee = $this->NewFeeModel->add_fee($data_array,$table);


            if($add_fee){

                $get_balance_amount = $this->NewFeeModel->get_balance_amount($sid,$fee_type,$acedemic_session);
                if($get_balance_amount){
                    foreach($get_balance_amount as $balance_amount_data){
                        if($balance_amount_data['fee_no'] == $add_fee){
                            
                        }else{
                            $update_balance_amount_status=$this->NewFeeModel->update_balance_amount_status($balance_amount_data['fee_no']);
                            if($update_balance_amount_status){
                                echo $update_balance_amount_status;
                            }
                        }
                    }
                }

                $get_extra_amount=$this->NewFeeModel->get_extra_amount($sid,$fee_type,$acedemic_session);
                if($get_extra_amount){
                    foreach($get_extra_amount as $extra_amount_data){
                        if($extra_amount_data['fee_no'] == $add_fee){
                            
                        }else{
                            $update_extra_amount_status=$this->NewFeeModel->update_extra_fee_amount_status($extra_amount_data['fee_no']);
                            if($update_extra_amount_status){
                                echo $update_extra_amount_status;
                            }
                        }
                    }
                }
                echo "Your Fee Submitted Succesfully";
                
                // Start Ledger Section
                $ledger_table='student_ledger'; 
                
                $monthly_fee_type='monthly_fee';
                $fee_invoice_array=array(
                    "particulars"=>"Monthly Fee",
                    "acedemic_session"=>$acedemic_session,
                    "fee_type"=>$monthly_fee_type,
                    "inv_no"=>$add_fee,
                    "trans_type"=>"Cr",
                    "sid"=>$sid,
                    "credit"=>$received_amount,
                    "payment_mode"=>$fee_mode,
                    "date"=>$fee_date,
                    "cat"=>$cat,
                    "cat_by"=>$tid,
                    "day"=>$day,
                    "month"=>$month,
                    "year"=>$year
                );
                $add_fee_invoice=$this->LedgerModel->insert_data($fee_invoice_array,$ledger_table);
                if($discount > 0){
                    $fee_discount_array=array(
                        "particulars"=>"Monthly Fee",
                        "acedemic_session"=>$acedemic_session,
                        "fee_type"=>$monthly_fee_type,
                        "inv_no"=>$add_fee,
                        "trans_type"=>"Cr",
                        "sid"=>$sid,
                        "credit"=>$discount,
                        "payment_mode"=>"Discount",
                        "date"=>$fee_date,
                        "cat"=>$cat,
                        "cat_by"=>$tid,
                        "day"=>$day,
                        "month"=>$month,
                        "year"=>$year
                    );
                    $add_fee_invoice=$this->LedgerModel->insert_data($fee_discount_array,$ledger_table);
                            }
                // End Ledger Section
            }
        }
    }

    public function getallfeeinvoices(){
        if($this->session->userdata('fee')!=1){
            redirect(base_url().'welcome/');
        }     
        $sid=$_POST['sid_url'];   
        $acedemic_session=$_POST['acedemic_session'];
        $data=$this->NewFeeModel->get_fee_invoices($sid,$acedemic_session);
        foreach ($data as $row){	
            echo "<tr>";
            echo "<td>".$row['fee_no']."</td>";
            echo "<td>".$row['sch_no']."</td>";
            echo "<td>".$row['bill_book_no']."</td>";
            echo "<td>".$row['estimate_amount']."</td>";
            echo "<td>".$row['discount']."</td>";
            echo "<td>".$row['received_amount']."</td>";
            echo "<td>".$row['extra_amount']."</td>";
            echo "<td>".$row['balance_amount']."</td>";
            echo "<td style='text-transform:uppercase;'>".$row['months']."</td>";
            echo "<td>".$row['no_of_months']."</td>";
            echo "<td>".$row['fee_type']."</td>";
            echo "<td>".date("d-m-Y", strtotime($row['fee_date']))."</td>";
            // echo "<td><a class='btn btn-info' href='".base_url()."StudentFee/feeInvoice/".$row['fee_no']."'>Print</a></td>";
            echo "<td><a class='btn btn-info btn-sm' href='".base_url()."Fee/invoice/".$row['fee_no']."' target='_blabk'>Invoice</a></td>";
            echo "<td><a href='".base_url()."Fee/edit_fee_data/".$row['fee_no']."' class='btn btn-warning btn-sm' target='_blank'>Edit</td>";
            
            if($this->session->userdata('delete_fee_invoice') ==1){
                echo '<td><button class="text-danger btn btn-sm" id="item_to_trash" item_id="'.$row['fee_no'].'"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash-fill" viewBox="0 0 16 16"><path d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 1 0z"/></svg></button></td>';
            }
                            
            echo "</tr>";
        }
    }
    public function profile($sid){
        $data['success']=''; $data['error']='';
        if (isset($_POST['add_rte_student'])) {
            $sid=$this->input->post('sid');
            $acedemic_session=$this->input->post('acedemic_session');
            $course_id=$this->input->post('course_id');
            $course_info=$this->input->post('course_info');
            $tid=$this->session->userdata('tid');
            $cat=date('Y-m-d H:i:s');
            $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"course_info"=>$course_info,"status"=>"active","tid"=>$tid,"cat"=>$cat);
            $table='rte_students';

            $check_student_exist=$this->NewFeeModel->check_student_rte_status($sid,$acedemic_session);
            if($check_student_exist){
                $data['error']='Already Exist';
            }else{
                $add_rte_student=$this->NewFeeModel->insert_data($data_array,$table);
                if($add_rte_student){
                    $data['success']='Added Successfully';
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/single-student');
        $this->load->view('erp/new-fee/add-rte-student',$data);
        $this->load->view('erp/footer');
    }

        
        
    public function defaulters(){
            
            
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/fee-defaulters');
        $this->load->view('erp/footer');
    }
        
    public function get_defaulter_links(){
        $defaulter_from_month=$_POST['defaulter_from_month'];
        $defaulter_to_month=$_POST['defaulter_to_month'];
        $month_array=array();

           
            
            
        if($defaulter_from_month < $defaulter_to_month){
            for($i=$defaulter_from_month;$i <=$defaulter_to_month; $i++){
                
                array_push($month_array,$i);
            }
        }else if($defaulter_from_month > $defaulter_to_month){
            for($i=$defaulter_from_month;$i <= 12; $i++){
                array_push($month_array,$i);
            }
            for($i=1;$i <= $defaulter_to_month; $i++){
                array_push($month_array,$i);
            }
        }else if($defaulter_from_month == $defaulter_to_month){
             array_push($month_array,$defaulter_from_month);
        }
        $array_count_values=sizeof($month_array);
        $def_req_table='defaulter_requests';
        $cat=date('Y-m-d H:i:s');
        $tid=$this->session->userdata('tid');
        $data_array=array("month_array"=>json_encode($month_array),"no_of_months"=>$array_count_values,"cat"=>$cat,"tid"=>$tid);
            $add_defaulter_request=$this->NewFeeModel->insert_data($data_array,$def_req_table);
            
            
            // print_r($array_count_values);
            // print_r($month_array);
        foreach($month_array as $montharray){
                // echo $montharray; 
                // echo "<br>";
        }
        if($add_defaulter_request){
            echo '<table class="table table-bordered table-striped">';
            echo '<thead>
            <tr>
            <th>Course</th>
            <th>View</th>
                        <th>PDF</th>
                    </tr>
                
                </thead>';
                echo '<tbody>';
                $courses_table='courses';
                $get_all_courses=$this->NewFeeModel->get_data($courses_table);
                if($get_all_courses){
                    foreach($get_all_courses as $courses){
                        echo '<tr>';
                            echo '<td>'.$courses['course'].' '.$courses['subject_stream'].'</td>';
                            // echo '<td></td>';
                            // echo '<td><a href="'.base_url().'Fee/get_defaulter_manually/'.$add_defaulter_request.'/'.$courses['id'].'" target="_blank">View</a></td>';
                            // echo '<td></td>';
                    echo '<td><a href="'.base_url().'Fee/get_defaulter_manually/'.$add_defaulter_request.'/'.$courses['id'].'" target="_blank">View</a></td>';            
                    echo '<td><a href="'.base_url().'Fee/defaulter_manual_pdf/'.$add_defaulter_request.'/'.$courses['id'].'" target="_blank">Download</a></td>';
                            // echo '<td></td>';
                        echo '</tr>';                        
                    }
                }
                echo '<tr><td>All Courses</td><td><a href="'.base_url().'Fee/all_course_fee_defaulter/'.$add_defaulter_request.'" target="_blank">View</a></td><td></td></tr>';
                echo '</tbody>';
                
            echo '</table>';
            
            }
        }
        
        public function get_balance_amount(){
            $acedemic_session=$_POST['acedemic_session'];
            $sid=$_POST['sid'];
            $fee_type=$_POST['fee_type'];
    
            $balance_fee_amount=0;
            $get_balance_amount=$this->NewFeeModel->get_balance_amount($sid,$fee_type,$acedemic_session);
            if($get_balance_amount){
                foreach($get_balance_amount as $balance_amount){
                    $balance_fee_amount=$balance_fee_amount + $balance_amount['balance_amount'];
                }
            }
            echo $balance_fee_amount;
        }

        public function get_extra_amount(){
            $acedemic_session=$_POST['acedemic_session'];
            $sid=$_POST['sid'];
            $fee_type=$_POST['fee_type'];
    
            $balance_fee_amount=0;
            $get_balance_amount=$this->NewFeeModel->get_extra_amount($sid,$fee_type,$acedemic_session);
            if($get_balance_amount){
                foreach($get_balance_amount as $balance_amount){
                    $balance_fee_amount=$balance_fee_amount + $balance_amount['extra_amount'];
                }
            }
            echo $balance_fee_amount;   
        }


        // public function invoice1($fee_no){
            //     $get_fee_info=$this->NewFeeModel->get_invoice_data($fee_no);
            //     if($get_fee_info){
                        //     $old_limit = ini_set("memory_limit", "1024M");
                        // $dompdf = new Pdf();
            
                        // $dompdf->set_paper('letter', 'portrait'); //landscape , portrait
                        // $html_content = '';        
                        // $html_content .= $this->NewFeeModel->fee_invoice($fee_no);
                        // $this->pdf->loadHtml($html_content);
                        // $this->pdf->render();
                        // $this->pdf->stream("".$fee_no.".pdf", array("Attachment"=>0));
            //     }
        // }

        public function pay_opening_balance($sid){
            $data['success']=''; $data['error']='';
            $this->load->view('erp/header');
            $this->load->view('erp/sidebar');
            $this->load->view('erp/new-fee/single-student');
            // $this->load->view('erp/new-fee/add-rte-student',$data);
            $this->load->view('erp/new-fee/opening-fee-invoices');
            $this->load->view('erp/new-fee/pay-opening-balance');
            $this->load->view('erp/footer');   
        }
    
        public function add_opening_fee(){
            $sid=$_POST['sid'];
            $discount=$_POST['discount'];
            $opening_fee_amount=$_POST['opening_fee_amount'];
            $opening_balance_note=$_POST['opening_balance_note'];
            $received_amount=$_POST['received_amount'];
            $fee_date=$_POST['fee_date'];
            $tid=$_POST['tid'];
            $fee_note=$_POST['fee_note'];
            $payment_mode=$_POST['payment_mode'];
            $balance_amount=$opening_fee_amount - $received_amount -$discount;
            $balance_fee_amount=$_POST['balance_fee_amount'];
            
            $cat=date('Y-m-d H:i:s');
            $acedemic_session=$this->session->userdata('acedemic_session');
            $fee_for_ac_sess=$_POST['fee_for_ac_sess'];
            $opening_balance_fee_table='opening_balance_fee';
            $date=date('Y-m-d');
            $day=date('d');
            $month=date('m');
            $year=date('Y');
            $fee_array=array("sid"=>$sid,"estimate_amount"=>$opening_fee_amount,"received_amount"=>$received_amount,"discount"=>$discount,"balance_amount"=>$balance_fee_amount,"cat"=>$cat,"date"=>$date,"day"=>$day,"month"=>$month,"year"=>$year,"acedemic_session"=>$acedemic_session,"fee_date"=>$fee_date,"tid"=>$tid,"fee_note"=>$fee_note,"fee_for_ac_sess"=>$fee_for_ac_sess,"payment_mode"=>$payment_mode);
            $check_opening_balance_fee=$this->NewFeeModel->check_opening_balance_fee_invoice($sid,$discount,$received_amount,$fee_date,$opening_fee_amount);
            if($check_opening_balance_fee){
                echo "Already Submited";
            }else{
                $add_fee=$this->NewFeeModel->insert_data($fee_array,$opening_balance_fee_table);
                if($add_fee){
                    echo "Fee Submitted";
                }
            }
        }
    
    public function edit_opening_balance($sid){
        $data['success']='';$data['error']='';
        if(isset($_POST['update_opening_balance_submit'])){
            $opening_fee_amount=$this->input->post('opening_fee_amount');
            $fee_note=$this->input->post('fee_note');
            $uat=date('Y-m-d H:i:s');
            $u_by=$this->session->userdata('tid');
            $data_array=array("opening_fee_amount"=>$opening_fee_amount,"fee_note"=>$fee_note,"uat"=>$uat,"u_by"=>$u_by);
            $sid=$this->input->post('sid');
            
            $update_opening_balance=$this->OpeningBalanceModel->update_opening_fee($sid,$data_array);
            if($update_opening_balance){
                $data['success']='Updated Successfully';
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/edit-opening-balance',$data);
        $this->load->view('erp/footer');        
    }
    
    public function invoices(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $table='student_fee';
        $config = array();
        $config["base_url"] = base_url() . "Fee/invoices";
        $config["total_rows"] = $this->NewFeeModel->get_count($acedemic_session,$table);
        $config["per_page"] = 20;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);

        $page = ($this->uri->segment(3));
        // ? $this->uri->segment(3) : 0;
        $data["links"] = $this->pagination->create_links();

        $data['all_invoices'] = $this->NewFeeModel->get_pagination_data($config["per_page"],$page,$table,$acedemic_session);
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/new-fee/all-invoices');
        $this->load->view('erp/new-fee/all-invoices-pagination',$data);
        $this->load->view('erp/footer');
    }
    
    public function cy_invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/all-invoices');
        // $this->load->view('erp/new-fee/all-invoices-pagination',$data);
        $this->load->view('erp/footer');
    }
    
    public function invoice_filter(){
        $class="";
        $section="";
        $start_date=date("Y-m-01");
        $end_date=date("Y-m-d");
        $student_name="";
        if(isset($_POST['invoice-filter'])){
            $start_date=$_POST['start_date'];
            $end_date=$_POST['end_date'];
            $class=$_POST['class'];
            $section=$_POST['section'];
            $student_name=$_POST['student_name'];
        }
        
        $this->session->set_userdata("search_filter_start_date",$start_date);
        $this->session->set_userdata("search_filter_end_date",$end_date);
        $this->session->set_userdata("search_filter_class",$class);
        $this->session->set_userdata("search_filter_section",$section);
        $this->session->set_userdata("search_filter_student_name",$student_name);
        $acedemic_session=$this->session->userdata('acedemic_session');
        $data['invoices']=$this->NewFeeModel->search_invoices($start_date,$end_date,$class,$section,$student_name,$acedemic_session);
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/all-invoices-with-filter',$data);
        // $this->load->view('erp/new-fee/all-invoices-pagination',$data);
        $this->load->view('erp/footer');
    }
    
    
    public function invoice($fee_no){
        
        $this->load->view('erp/new-fee/fee-receipt-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
    }
    
    public function course_fee_structure($course_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/course-fee-structure');
        $this->load->view('erp/footer');
    }
    
    public function delete_student(){
        $sid=$_POST['sid'];
        // echo $sid;
        $table='student';
        $deleted_table='students_deleted';
        $get_item_info=$this->NewFeeModel->get_item_data($sid,$table);
        $cat=date('Y-m-d H:i:s');
        $cat_by=$this->session->userdata('tid');
        if($get_item_info){
            foreach($get_item_info as $info){
                $data_array=array("sid"=>$info['id'],"student_name"=>$info['student_name'],"father_name"=>$info['father_name'],"mother_name"=>$info['mother_name'],"dob"=>$info['dob'],"class"=>$info['class'],"contact_no"=>$info['contact_no'],"sr_no"=>$info['sr_no'],"adm_no"=>$info['adm_no'],"gender"=>$info['gender'],"admission_date"=>$info['admission_date'],"religion"=>$info['religion'],"caste"=>$info['caste'],"password"=>$info['password'],"status_description"=>$info['status_description'],"status"=>$info['status'],"cat"=>$cat,"cat_by"=>$cat_by);
                $add_to_deleted=$this->NewFeeModel->insert_data($data_array,$deleted_table);
                if($add_to_deleted){
                    $delete_item=$this->NewFeeModel->delete_item($sid,$table);                        
                    if($delete_item){
                        echo "Deleted Successfully";
                    }
                }

            }
        }
    }
    
    public function edit_fee_data($fee_no){
        $data['success']=''; $data['error']='';
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/edit-fee-invoice-data',$data);
        $this->load->view('erp/footer');
    }
    
    public function today_fee_collection(){
        $from_date=$_POST['from_date'];
        $to_date=$_POST['to_date'];
        
        // $today_date=$_POST['today_fee_date'];
        $from_date=date('Y-m-d',strtotime($from_date));
        $to_date=date('Y-m-d',strtotime($to_date));
        $courses_table='courses';
        $total_cash=0;
        $total_other_then_cash=0;
        $invoices=0;
        $all_courses=$this->NewFeeModel->get_data($courses_table);
        $acedemic_session=$this->session->userdata('acedemic_session');
        
        
        echo "<tr>";
            echo "<th colspan='5'>Course wise fee collection on ".date('d-M-Y',strtotime($from_date))." to ".date('d-M-Y',strtotime($to_date))."</th>";
        echo "</tr>";
        echo "<tr>
                <th>Course</th>
                <th>Invoices</th>
                <th>Cash</th>
                <th>Other</th>
                <th></th>
            </tr>";
        if($all_courses){
            foreach($all_courses as $courses){
                $course_id=$courses['id'];

                
                $course_invoices=0;
                $cash_count=0;
                $cash_amount=0;
                $other_then_cash_count=0;
                $other_then_cash_amount=0;
                // $get_date_fee_collection=$this->NewFeeModel->today_course_wise_fee_collection($fee_date,$course_id,$acedemic_session);
                $get_date_fee_collection=$this->NewFeeModel->today_course_wise_fee_collection_new($from_date,$to_date,$course_id,$acedemic_session);
                
                if($get_date_fee_collection){
                    foreach($get_date_fee_collection as $collection){
                        $invoices=$invoices + 1;
                        $course_invoices =$course_invoices + 1;
                        if($collection['payment_mode'] != 'cash'){
                            $other_then_cash_count=$other_then_cash_count + 1;
                            $other_then_cash_amount=$other_then_cash_amount + $collection['received_amount'];                            
                        }else{
                            $cash_count=$cash_count + 1;
                            $cash_amount=$cash_amount + $collection['received_amount'];
                        }
                        // if($collection['payment_mode'] == 'cash'){
                        //     $cash_count=$cash_count + 1;
                        //     $cash_amount=$collection['received_amount'];
                        // }else{
                        //     $other_then_cash_count=$other_then_cash_count + 1;
                        //     $other_then_cash_amount=$collection['received_amount'];
                        // }
                    }
                }
                
                if($course_invoices >=1){
                    
                
                echo "<tr>";
                echo "<td>".$courses['course']." ".$courses['subject_stream']."</td>";    
                echo "<td>".$course_invoices."</td>";
                echo "<td>( ".$cash_count." / ".$cash_amount." )</td>";
                echo "<td>( ".$other_then_cash_count." / ".$other_then_cash_amount.")</td>";
                echo "<td></td>";
                echo "</tr>";
                }
                $total_cash=$total_cash + $cash_amount;
                $total_other_then_cash=$total_other_then_cash + $other_then_cash_amount;
            }
        }
        echo "<tr>";
        echo "<th></th>";
        echo "<th>".$invoices."</th>";
        echo "<th>".$total_cash."</th>";
        echo "<th>".$total_other_then_cash."</th>";
        echo '<th>
            <a href="'.base_url().'FeeManagement/day_collection/'.date('Y-m-d',strtotime($from_date)).'/'.date('Y-m-d',strtotime($to_date)).'" class="btn btn-sm btn-success" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye-fill" viewBox="0 0 16 16">
                    <path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z"/>
                    <path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8zm8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z"/>
                </svg>
            </a>
            <a href="'.base_url().'FeeManagement/day_collection_pdf/'.date('Y-m-d',strtotime($from_date)).'/'.date('Y-m-d',strtotime($to_date)).'" class="btn btn-sm btn-danger" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-pdf-fill" viewBox="0 0 16 16">
                    <path d="M5.523 10.424c.14-.082.293-.162.459-.238a7.878 7.878 0 0 1-.45.606c-.28.337-.498.516-.635.572a.266.266 0 0 1-.035.012.282.282 0 0 1-.026-.044c-.056-.11-.054-.216.04-.36.106-.165.319-.354.647-.548zm2.455-1.647c-.119.025-.237.05-.356.078a21.035 21.035 0 0 0 .5-1.05 11.96 11.96 0 0 0 .51.858c-.217.032-.436.07-.654.114zm2.525.939a3.888 3.888 0 0 1-.435-.41c.228.005.434.022.612.054.317.057.466.147.518.209a.095.095 0 0 1 .026.064.436.436 0 0 1-.06.2.307.307 0 0 1-.094.124.107.107 0 0 1-.069.015c-.09-.003-.258-.066-.498-.256zM8.278 4.97c-.04.244-.108.524-.2.829a4.86 4.86 0 0 1-.089-.346c-.076-.353-.087-.63-.046-.822.038-.177.11-.248.196-.283a.517.517 0 0 1 .145-.04c.013.03.028.092.032.198.005.122-.007.277-.038.465z"/>
                    <path fill-rule="evenodd" d="M4 0h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm.165 11.668c.09.18.23.343.438.419.207.075.412.04.58-.03.318-.13.635-.436.926-.786.333-.401.683-.927 1.021-1.51a11.64 11.64 0 0 1 1.997-.406c.3.383.61.713.91.95.28.22.603.403.934.417a.856.856 0 0 0 .51-.138c.155-.101.27-.247.354-.416.09-.181.145-.37.138-.563a.844.844 0 0 0-.2-.518c-.226-.27-.596-.4-.96-.465a5.76 5.76 0 0 0-1.335-.05 10.954 10.954 0 0 1-.98-1.686c.25-.66.437-1.284.52-1.794.036-.218.055-.426.048-.614a1.238 1.238 0 0 0-.127-.538.7.7 0 0 0-.477-.365c-.202-.043-.41 0-.601.077-.377.15-.576.47-.651.823-.073.34-.04.736.046 1.136.088.406.238.848.43 1.295a19.707 19.707 0 0 1-1.062 2.227 7.662 7.662 0 0 0-1.482.645c-.37.22-.699.48-.897.787-.21.326-.275.714-.08 1.103z"/>
                </svg>
            </a>
            <a href="#" class="btn btn-sm btn-info">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-spreadsheet-fill" viewBox="0 0 16 16">
                    <path d="M12 0H4a2 2 0 0 0-2 2v4h12V2a2 2 0 0 0-2-2zm2 7h-4v2h4V7zm0 3h-4v2h4v-2zm0 3h-4v3h2a2 2 0 0 0 2-2v-1zm-5 3v-3H6v3h3zm-4 0v-3H2v1a2 2 0 0 0 2 2h1zm-3-4h3v-2H2v2zm0-3h3V7H2v2zm4 0V7h3v2H6zm0 1h3v2H6v-2z"/>
                </svg>
            </a>
            </th>
        ';
        echo "</tr>";
        
    }
    public function ledger($sid){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/ledger');
        $this->load->view('erp/footer');
    }
    
    public function ledger_new($sid){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/ledger-new');
        $this->load->view('erp/footer');
    }
    
    public function ledger_pdf($sid){
        $this->load->view('erp/new-fee/ledger-pdf-view');    
                // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'landscape');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$sid", array("Attachment"=>0));
    }
    
    public function ledger_pdf_new($sid){
        $this->load->view('erp/new-fee/new-ledger-pdf-view');    
                // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A4', 'landscape');
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$sid", array("Attachment"=>0));
    }
    
    
    public function update_fee_invoice(){
        $est_fee= $_POST['est_fee'];
        $received_fee = $_POST['received_fee'];
        $prev_bal = $_POST['prev_bal'];
        $prev_extra = $_POST['prev_extra'];
        $discount = $_POST['discount'];
        $cal_total_amount = $_POST['cal_total_amount'];
        $balance_amount = $_POST['balance_amount'];
        $extra_amount = $_POST['extra_amount'];
        $fee_date =$_POST['fee_date'];
        $bill_book_number = $_POST['bill_book_number'];
        $txn_no =$_POST['txn_no'];
        $fee_info =$_POST['fee_info'];
        $sid = $_POST['sid'];
        $fee_no =$_POST['fee_no'];
        $course_id=$_POST['course_id'];
        $tid=$this->session->userdata('tid');
        $teacher_name=$this->session->userdata('teacher_name');
        $uat=date('Y-m-d H:i:s');
        $date=date('Y-m-d');
        $old_array=json_encode($this->NewFeeModel->get_invoice_data($fee_no));
            
        $data_array_update=array("estimate_amount"=>$est_fee,"received_amount"=>$received_fee,"balance_amount_added"=>$prev_bal,"extra_amount_used"=>$prev_extra,"discount"=>$discount,"total_amount"=>$cal_total_amount,"balance_amount"=>$balance_amount,"extra_amount"=>$extra_amount,"fee_date"=>$fee_date,"bill_book_no"=>$bill_book_number,"txn_no"=>$txn_no,"fee_note"=>$fee_info,"u_at"=>$uat,"u_by"=>$tid,"course_id"=>$course_id);
            
        // $data_array_update=array("fee_date"=>$fee_date,"fee_note"=>$fee_note,"bill_book_number"=>$bill_book_number,"txn_no"=>$txn_no,"fee_info"=>$fee_info,"u_at"=>$uat,"u_by"=>$tid);
            
        $update_fee_data=$this->NewFeeModel->update_fee_data($fee_no,$data_array_update);
            if($update_fee_data){
                echo 'Fee Updated Successfully ! ';
                $log_array=array("old_data"=>$old_array,"new_data"=>json_encode($data_array_update),"fee_no"=>$fee_no,"cat"=>$uat,"date"=>$date,"tid"=>$tid);
                $log_table='fee_data_log';
                $add_to_fee_log=$this->NewFeeModel->insert_data($log_array,$log_table);
                if($add_to_fee_log){
                    echo 'Fee Log Added Successfully';
                }else{
                    echo 'Error in updating data';
                }
            }else{
                echo 'Error in updating fee data';
            }

    }
    
    public function user_wise_fee_collection(){
        // $fee_date=$_POST['today_fee_date'];
        $from_date=$_POST['from_date'];
        $to_date=$_POST['to_date'];
        
        // $fee_date=date('Y-m-d');
        $count=0;
        $cash_total=0;
        $other_than_cash_total=0;
        $total_received=0;
        
        $grand_total_cash=0;
        $grand_total_other=0;
        $grand_total=0;
        
        $table='school_staff';
        
        echo '
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th colspan="8">User wise fee collection on '.date('d-M-Y',strtotime($from_date)).' to '.date('d-M-Y',strtotime($to_date)).'</th>
                    </tr>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Enquiry</th>
                        <th>Admission Fee</th>
                        <th>Monthly Fee</th>
                        <th>Opening Fee</th>
                        <th>Total</th>
                        
                        <th>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-cloud-arrow-down-fill" viewBox="0 0 16 16">
                                <path d="M8 2a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 6.095 0 7.555 0 9.318 0 11.366 1.708 13 3.781 13h8.906C14.502 13 16 11.57 16 9.773c0-1.636-1.242-2.969-2.834-3.194C12.923 3.999 10.69 2 8 2zm2.354 6.854-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 1 1 .708-.708L7.5 9.293V5.5a.5.5 0 0 1 1 0v3.793l1.146-1.147a.5.5 0 0 1 .708.708z"/>
                            </svg>
                        </th>
                    </tr>
                    <tr>
                        <td></td>
                        <td></td>
                        <td style="font-size:14px;text-align:center;" colspan="4" class="text-success">
                            <span class="text-danger font-weight-bold">[ Invoices ]</span><span class="text-warning font-weight-bold">( Received Fee )</span>(<span class="text-success font-weight-bold"> Cash </span>/ <span class="text-info font-weight-bold">Other</span> )
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                </thead>';
                    echo '<tbody class="font-weight-bolder">';
                    // $get_fee_admins_data=$this->NewFeeModel->get_data($table);
                    $get_fee_admins_data=$this->NewFeeModel->get_fee_admins();
                    if($get_fee_admins_data){
                        foreach($get_fee_admins_data as $data){
                            // if($data['fee_permission'] == 1 && $data['status'] ==0){
                                $staff_id=$data['id'];
                                $count=$count + 1;
                                $fee_table='student_fee';
                                
                                $total_fee_received=0;
                                echo "<tr>";
                                    echo "<td>".$count."</td>";
                                    echo "<td>".$data['salutation']." ".$data['name']."</td>";    
                            
                                    $enq_invoices_count=0;
                                    $enq_fee_received=0;
                                    $enq_cash_total=0;
                                    $enq_other_than_cash_total=0;
                                    $enq_fee_type='Enquiry Fee';
                                    // $get_today_enq_fee_invoices=$this->NewFeeModel->get_staf_fee_collection_by_date($staff_id,$fee_date,$enq_fee_type,$fee_table);
                                    
                                    $get_today_enq_fee_invoices=$this->NewFeeModel->get_staff_fee_collection_by_date_range($staff_id,$from_date,$to_date,$fee_type,$fee_table);
                                    if($get_today_enq_fee_invoices){
                                        foreach($get_today_enq_fee_invoices as $enq_fee_invoices){
                                            $enq_invoices_count=$enq_invoices_count + 1;
                                            $enq_fee_received=$enq_fee_received + $enq_fee_invoices['received_amount'];
                                            $total_fee_received=$total_fee_received + $enq_fee_invoices['received_amount'];
                                            $enq_discount_given=$enq_discount_given + $enq_fee_invoices['discount'];
                                            if($enq_fee_invoices['payment_mode'] == 'cash'){
                                                $enq_cash_total=$enq_cash_total + $enq_fee_invoices['received_amount'];
                                            }else{
                                                $enq_other_than_cash_total=$enq_other_than_cash_total + $enq_fee_invoices['received_amount'];
                                            }
                                        }
                                    }
                                    
                                    $grand_total_cash=$grand_total_cash + $enq_cash_total;
                                    $grand_total_other=$grand_total_other + $enq_other_than_cash_total;
                                    $grand_total=$grand_total + $enq_fee_received;
                                    
                                    echo '<td><span class="text-danger font-weight-bold">[ '.$enq_invoices_count.' ]</span><span class="text-warning font-weight-bold"> ( '.$enq_fee_received.' )</span>( <span class="text-success font-weight-bold">'.$enq_cash_total.'</span> /<span class="text-info font-weight-bold"> '.$enq_other_than_cash_total.' )</span></td>';
                                    $admission_invoices_count=0;
                                    $admission_fee_received=0;
                                    $admission_cash_total=0;
                                    $admission_discount_given=0;
                                    $admission_other_than_cash_total=0;
                                    $admission_fee_type='Admission Fee';
                                    // $get_today_admission_fee_invoices=$this->NewFeeModel->get_staf_fee_collection_by_date($staff_id,$fee_date,$admission_fee_type,$fee_table);
                                    
                                    
                                    $get_today_admission_fee_invoices=$this->NewFeeModel->get_staff_fee_collection_by_date_range($staff_id,$from_date,$to_date,$admission_fee_type,$fee_table);
                                    if($get_today_admission_fee_invoices){
                                        foreach($get_today_admission_fee_invoices as $admission_fee_invoices){
                                            $admission_invoices_count=$admission_invoices_count + 1;
                                            $admission_fee_received=$admission_fee_received + $admission_fee_invoices['received_amount'];
                                            $total_fee_received=$total_fee_received + $admission_fee_invoices['received_amount'];
                                            
                                            $admission_discount_given=$admission_discount_given + $admission_fee_invoices['discount'];
                                            if($admission_fee_invoices['payment_mode'] == 'cash'){
                                                $admission_cash_total=$admission_cash_total + $admission_fee_invoices['received_amount'];
                                            }else{
                                                $admission_other_than_cash_total=$admission_other_than_cash_total + $admission_fee_invoices['received_amount'];
                                            }
                                        }   
                                    }
                                    
                                    $grand_total_cash=$grand_total_cash + $admission_cash_total;
                                    $grand_total_other=$grand_total_other + $admission_other_than_cash_total;
                                    $grand_total=$grand_total + $admission_fee_received;
                                    
                                    echo '<td><span class="text-danger font-weight-bold">[ '.$admission_invoices_count.' ]</span><span class="text-warning font-weight-bold"> ( '.$admission_fee_received.' )</span> (<span class="text-success font-weight-bold"> '.$admission_cash_total.'</span> / <span class="text-info font-weight-bold">'.$admission_other_than_cash_total.'</span> )</td>';
                                    $monthly_fee_invoices_count=0;
                                    $monthly_fee_received=0;
                                    $monthly_fee_discount_given=0;
                                    $monthly_fee_cash_total=0;
                                    $monthly_fee_other_than_cash_total=0;

                            
                            $monthly_fee_type='Monthly';
                            // $get_today_monthly_fee_invoices=$this->NewFeeModel->get_staf_fee_collection_by_date($staff_id,$fee_date,$monthly_fee_type,$fee_table);
                            
                            
                            $get_today_monthly_fee_invoices=$this->NewFeeModel->get_staff_fee_collection_by_date_range($staff_id,$from_date,$to_date,$monthly_fee_type,$fee_table);
                            
                            if($get_today_monthly_fee_invoices){
                                foreach($get_today_monthly_fee_invoices as $today_monthly_fee_invoices){
                                    $monthly_fee_invoices_count=$monthly_fee_invoices_count + 1;
                                    $monthly_fee_received=$monthly_fee_received + $today_monthly_fee_invoices['received_amount'];
                                    
                                    $total_fee_received=$total_fee_received + $today_monthly_fee_invoices['received_amount'];
                                    
                                    $monthly_fee_discount_given=$monthly_fee_discount_given + $today_monthly_fee_invoices['discount'];
                                    if($today_monthly_fee_invoices['payment_mode'] == 'cash'){
                                        $monthly_fee_cash_total=$monthly_fee_cash_total + $today_monthly_fee_invoices['received_amount'];
                                    }else{
                                        $monthly_fee_other_than_cash_total=$monthly_fee_other_than_cash_total + $today_monthly_fee_invoices['received_amount'];
                                    }
                                    
                                    
                                }
                            }      
                            
                                $grand_total_cash=$grand_total_cash + $monthly_fee_cash_total;
                                $grand_total_other=$grand_total_other + $monthly_fee_other_than_cash_total;
                                $grand_total=$grand_total + $monthly_fee_received;
                                
                                echo '<td> <span class="text-danger font-weight-bold">[ '.$monthly_fee_invoices_count.' ]</span> <span class="text-warning font-weight-bold">( '.$monthly_fee_received.' )</span>( <span class="text-success font-weight-bold">'.$monthly_fee_cash_total.' </span>/ <span class="text-info font-weight-bold">'.$monthly_fee_other_than_cash_total.'</span> )</td>';    
                                
                                
                                $opening_fee_invoices_count=0;
                                $opening_fee_received=0;
                                $opening_fee_discount_given=0;
                                $opening_fee_cash_total=0;
                                $opening_fee_other_than_cash_total=0;
                                
                                $opening_fee_table='opening_balance_fee';
                                // $get_today_userwise_opening_fee=$this->NewFeeModel->get_today_userwise_opening_fee($staff_id,$fee_date,$opening_fee_table);
                                
                                $get_today_userwise_opening_fee=$this->NewFeeModel->get_date_range_userwise_opening_fee($staff_id,$from_date,$to_date);
                                if($get_today_userwise_opening_fee){
                                    foreach($get_today_userwise_opening_fee as $today_userwise_opening_fee){
                                        $opening_fee_invoices_count=$opening_fee_invoices_count + 1;
                                        $opening_fee_received=$opening_fee_received + $today_userwise_opening_fee['received_amount'];
                                        
                                        $total_fee_received=$total_fee_received + $today_userwise_opening_fee['received_amount'];
                                        
                                        $opening_fee_discount_given = $opening_fee_discount_given + $today_userwise_opening_fee['discount'];
                                        if($today_userwise_opening_fee['payment_mode'] =='cash'){
                                            $opening_fee_cash_total = $opening_fee_cash_total + $today_userwise_opening_fee['received_amount'];
                                        }else{
                                            $opening_fee_other_than_cash_total = $opening_fee_other_than_cash_total + $today_userwise_opening_fee['received_amount'];
                                        }
                                        
                                    }
                                }
                                
                                $grand_total_cash=$grand_total_cash + $opening_fee_cash_total;
                                $grand_total_other=$grand_total_other + $opening_fee_other_than_cash_total;
                                $grand_total=$grand_total + $opening_fee_received;
                                
                                echo '<td> <span class="text-danger font-weight-bold">[ '.$opening_fee_invoices_count.' ]</span> <span class="text-warning font-weight-bold">( '.$opening_fee_received.' )</span>(<span class="text-success font-weight-bold"> '.$opening_fee_cash_total.'</span> / <span class="text-info font-weight-bold">'.$opening_fee_other_than_cash_total.'</span> )</td>';
                                echo '<td><span class="text-success">'.$total_fee_received.'</span></td>';
                                // echo "<td>".$invoices_count."</td>";
                                
                                // echo "<td>".$discount_given."</td>";
                            
                                echo '<td>
                                        <a href="'.base_url().'FeeManagement/user_fee_collection/'.$data['id'].'/'.date('Y-m-d',strtotime($from_date)).'/'.date('Y-m-d',strtotime($to_date)).'" class="btn btn-sm btn-success" type="button" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye-fill" viewBox="0 0 16 16">
                                                <path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z"/>
                                                <path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8zm8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z"/>
                                            </svg>
                                        </a>
                                        <a href="'.base_url().'FeeManagement/user_fee_collection_pdf/'.$data['id'].'/'.date('Y-m-d',strtotime($from_date)).'/'.date('Y-m-d',strtotime($to_date)).'" class="btn btn-sm btn-danger" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-pdf-fill" viewBox="0 0 16 16">
                                                <path d="M5.523 10.424c.14-.082.293-.162.459-.238a7.878 7.878 0 0 1-.45.606c-.28.337-.498.516-.635.572a.266.266 0 0 1-.035.012.282.282 0 0 1-.026-.044c-.056-.11-.054-.216.04-.36.106-.165.319-.354.647-.548zm2.455-1.647c-.119.025-.237.05-.356.078a21.035 21.035 0 0 0 .5-1.05 11.96 11.96 0 0 0 .51.858c-.217.032-.436.07-.654.114zm2.525.939a3.888 3.888 0 0 1-.435-.41c.228.005.434.022.612.054.317.057.466.147.518.209a.095.095 0 0 1 .026.064.436.436 0 0 1-.06.2.307.307 0 0 1-.094.124.107.107 0 0 1-.069.015c-.09-.003-.258-.066-.498-.256zM8.278 4.97c-.04.244-.108.524-.2.829a4.86 4.86 0 0 1-.089-.346c-.076-.353-.087-.63-.046-.822.038-.177.11-.248.196-.283a.517.517 0 0 1 .145-.04c.013.03.028.092.032.198.005.122-.007.277-.038.465z"/>
                                                <path fill-rule="evenodd" d="M4 0h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm.165 11.668c.09.18.23.343.438.419.207.075.412.04.58-.03.318-.13.635-.436.926-.786.333-.401.683-.927 1.021-1.51a11.64 11.64 0 0 1 1.997-.406c.3.383.61.713.91.95.28.22.603.403.934.417a.856.856 0 0 0 .51-.138c.155-.101.27-.247.354-.416.09-.181.145-.37.138-.563a.844.844 0 0 0-.2-.518c-.226-.27-.596-.4-.96-.465a5.76 5.76 0 0 0-1.335-.05 10.954 10.954 0 0 1-.98-1.686c.25-.66.437-1.284.52-1.794.036-.218.055-.426.048-.614a1.238 1.238 0 0 0-.127-.538.7.7 0 0 0-.477-.365c-.202-.043-.41 0-.601.077-.377.15-.576.47-.651.823-.073.34-.04.736.046 1.136.088.406.238.848.43 1.295a19.707 19.707 0 0 1-1.062 2.227 7.662 7.662 0 0 0-1.482.645c-.37.22-.699.48-.897.787-.21.326-.275.714-.08 1.103z"/>
                                            </svg>
                                        </a>                            
                            
                            <a href="#" class="btn btn-sm btn-info" >
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-spreadsheet-fill" viewBox="0 0 16 16">
                                    <path d="M12 0H4a2 2 0 0 0-2 2v4h12V2a2 2 0 0 0-2-2zm2 7h-4v2h4V7zm0 3h-4v2h4v-2zm0 3h-4v3h2a2 2 0 0 0 2-2v-1zm-5 3v-3H6v3h3zm-4 0v-3H2v1a2 2 0 0 0 2 2h1zm-3-4h3v-2H2v2zm0-3h3V7H2v2zm4 0V7h3v2H6zm0 1h3v2H6v-2z"/>
                                </svg>
                            </a>
                            </td>
                            ';

                        echo "</tr>";
                        
                                // =$grand_total_cash + $opening_fee_cash_total;
                                // $grand_total_other=$grand_total_other + $opening_fee_other_than_cash_total;
                                // $grand_total=$grand_total + $opening_fee_received;

                        // }
                    }
            }
            echo "<tr>";
                echo "<td></td>";
                echo "<td colspan=''>Cash</td>";
                echo "<td class='text-success'>".$grand_total_cash."</td>";
                echo "<td>Other then cash</td>";
                echo "<td class='text-info'>".$grand_total_other."</td>";
                echo "<td>Total</td>";
                echo "<td class='text-success'>".$grand_total."</td>";
                echo "<td></td>";
            echo "</tr>";
        echo '</tbody></table>';
    }
    
    public function delete_invoice(){
        $item_id=$_POST['item_id'];
        $get_invoice_data=$this->NewFeeModel->get_invoice_data($item_id);
        // var_dump($get_invoice_data);
        $del_by=$this->session->userdata('tid');
        $del_at=date('Y-m-d H:i:s');
        if($get_invoice_data){
            foreach($get_invoice_data as $invoice_data){
                $invoice_array=array(
                    "fee_no"=>$invoice_data['fee_no'],
                    "acedemic_session"=>$invoice_data['acedemic_session'],
                    "sid"=>$invoice_data['sid'],
                    "sch_no"=>$invoice_data['sch_no'],
                    "student_class"=>$invoice_data['student_class'],
                    "course_id"=>$invoice_data['course_id'],
                    "section"=>$invoice_data['section'],
                    "total_amount"=>$invoice_data['total_amount'],
                    "y1"=>$invoice_data['y1'],
                    "y2"=>$invoice_data['y2'],
                    "cat"=>$invoice_data['cat'],
                    "cat_time"=>$invoice_data['cat_time'],
                    "txn_no"=>$invoice_data['txn_no'],
                    "payment_mode"=>$invoice_data['payment_mode'],
                    "fee_note"=>$invoice_data['fee_note'],
                    "fee_type"=>$invoice_data['fee_type'],
                    "months"=>$invoice_data['months'],
                    "no_of_months"=>$invoice_data['no_of_months'],
                    "bill_book_no"=>$invoice_data['bill_book_no'],
                    "january"=>$invoice_data['january'],
                    "may"=>$invoice_data['may'],
                    "june"=>$invoice_data['june'],
                    "july"=>$invoice_data['july'],
                    "august"=>$invoice_data['august'],
                    "september"=>$invoice_data['september'],
                    "october"=>$invoice_data['october'],
                    "november"=>$invoice_data['november'],
                    "december"=>$invoice_data['december'],
                    "april"=>$invoice_data['april'],
                    "february"=>$invoice_data['february'],
                    "march"=>$invoice_data['march'],
                    "discount"=>$invoice_data['discount'],
                    "estimate_amount"=>$invoice_data['estimate_amount'],
                    "day"=>$invoice_data['day'],
                    "month"=>$invoice_data['month'],
                    "year"=>$invoice_data['year'],
                    "fee_date"=>$invoice_data['fee_date'],
		            "tid"=>$invoice_data['tid'],
		            "bill_book_number"=> $invoice_data['bill_book_number'],
		            "enquiry_id"=>$invoice_data['enquiry_id'],
		            "fee_info"=>$invoice_data['fee_info'], 
		            "extra_amount"=>$invoice_data['extra_amount'],
		            "balance_amount"=>$invoice_data['balance_amount'],
		            "received_amount"=>$invoice_data['received_amount'],
		            "balance_amount_status"=>$invoice_data['balance_amount_status'],
		            "extra_amount_status"=>$invoice_data['extra_amount_status'],
		            "balance_amount_added"=>$invoice_data['balance_amount_added'],
		            "balance_amount_added_refrence"=>$invoice_data['balance_amount_added_refrence'],
		            "extra_amount_used"=>$invoice_data['extra_amount_used'],
		            "extra_amount_used_refrence"=>$invoice_data['extra_amount_used_refrence'],
		            "permission_by"=>$invoice_data['permission_by'],
		            "u_at"=>$invoice_data['u_at'],
		            "u_by"=>$invoice_data['u_by'],
		            "del_at"=>$del_at,
		            "del_by"=>$del_by
                );
                // var_dump( $invoice_array);
                $del_fee_table='student_fee_deleted';
                $fee_table='student_fee';
                $check_invoice_exist_in_deleted=$this->NewFeeModel->get_invoice_info($item_id,$del_fee_table);
                if($check_invoice_exist_in_deleted){
                    
                }else{
                    $add_to_deleted=$this->NewFeeModel->insert_data($invoice_array,$del_fee_table);
                    if($add_to_deleted){
                        
                        $delete_invoice_permanently=$this->NewFeeModel->delete_invoice_permanently($item_id,$fee_table);
                        if($delete_invoice_permanently){
                            echo "Deleted Successfully";
                        }
                    }
                }
            }
        }
    }
       
    public function deleted_invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/deleted-invoices');
        $this->load->view('erp/footer');
    }   
    
    public function deleted_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/deleted-students');
        $this->load->view('erp/footer');
    }
    public function del_invoice($fee_no){
        
        $this->load->view('erp/new-fee/del-fee-receipt-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
    }
    
    public function pay_balance_fee(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/pay-balance-fee');
        $this->load->view('erp/footer');
    }
    
    public function get_balance_fee_invoices(){
        echo $sid=$_POST['sid_url'];   
        echo $acedemic_session=$_POST['acedemic_session'];
    }
    
    public function add_balance_fee(){
        $sid=$_POST['sid'];
        $fee_no=$_POST['fee_no'];
        $course_id=$_POST['course_id'];
        $new_fee_date=$_POST['new_fee_date'];
        $estimate_fee_amount=$_POST['estimate_fee_amount'];
        $discount_amount=$_POST['discount_amount'];
        $received_fee_amount=$_POST['received_fee_amount'];
        $new_balance_fee=$_POST['new_balance_fee'];
        $new_extra_fee=$_POST['new_extra_fee'];
        
        $payment_mode=$_POST['payment_mode'];
        $fee_note=$_POST['fee_note'];
        $discount_permission_by=$_POST['discount_permission_by'];
        
        $fee_type="Monthly";
        $cat_time=date('Y-m-d H:i:s');
        $cat=date('Y-m-d');
        $acedemic_session=$this->session->userdata('acedemic_session');
        $tid=$this->session->userdata('tid');
        
        $balance_amount_status=0;
        $extra_amount_status=0;
        
        if($new_balance_fee >0){
            $balance_amount_status=$balance_amount_status + 1;    
        }
        
        if($new_extra_fee >0){
            $extra_amount_status=$extra_amount_status + 1;    
        }
        
        $data_array=array(
            "sid"=>$sid,
            "course_id"=>$course_id,
            "fee_type"=>$fee_type,
            "payment_mode"=>$payment_mode,
            "fee_note"=>$fee_note,
            "fee_date"=>$new_fee_date,
            "balance_amount_added"=>$estimate_fee_amount,
            "balance_amount_added_refrence"=>$fee_no,
            "estimate_amount"=>$estimate_fee_amount,
            "discount"=>$discount_amount,
            "received_amount"=>$received_fee_amount,
            "balance_amount"=>$new_balance_fee,
            "extra_amount"=>$new_extra_fee,
            "acedemic_session"=>$acedemic_session,
            "cat_time"=>$cat_time,
            "cat"=>$cat,
            "acedemic_session"=>$acedemic_session,
            "tid"=>$tid,
            "balance_amount_status"=>$balance_amount_status,
            "extra_amount_status"=>$extra_amount_status,
            "day"=>date('d',strtotime($new_fee_date)),
            "month"=>date('m',strtotime($new_fee_date)),
            "year"=>date('Y',strtotime($new_fee_date)),
            "permission_by"=>$discount_permission_by
            );
        $check_fee_paid_already=$this->NewFeeModel->check_balance_fee_paid_status($sid,$fee_no,$estimate_fee_amount,$received_fee_amount);
        if($check_fee_paid_already){
            echo "Already Paid";
        }else{
            $table='student_fee';
            $pay_balance_fee=$this->NewFeeModel->insert_data($data_array,$table);
            if($pay_balance_fee){
                echo "Fee Paid Successfully";
                $update_balance_paid_status=$this->NewFeeModel->update_balance_amount_status($fee_no);
                if($update_balance_paid_status){
                    echo "Balance Fee Status Updated Successfully.";
                }
            }
            
            // echo "hmm";
        }
    }
    
    public function opening_fee_collection_for_today(){
        $from_date=$_POST['from_date'];
        $to_date=$_POST['to_date'];
        
        // $fee_date=$_POST['today_fee_date'];
        echo '<table class="table table-bordered table-striped">';
            echo '<thead>';
                echo '<tr>';
                    echo '<th colspan="7">Opening fee collection on '.date('d-M-Y',strtotime($from_date)).' to '.date('d-M-Y',strtotime($to_date)).'</th>';
                echo '</tr>';       
                echo '<tr>';
                    echo '<th>Fee No.</th>';
                    echo '<th>Student Name</th>';
                    echo "<th>Father's Name</th>";
                    echo '<th>Est. Fee</th>';
                    echo '<th>Discount</th>';
                    echo '<th>Received</th>';
                    echo '<th>Balance</th>';
                echo '</tr>';    
            echo '</thead>';    
            echo '<tbody>';
            $total_received_fee=0;
            // $get_today_opening_fee_invoices=$this->NewFeeModel->get_day_opening_fee_invoices($fee_date);
            
            $get_today_opening_fee_invoices=$this->NewFeeModel->get_date_range_opening_fee_invoices($from_date,$to_date);
            if($get_today_opening_fee_invoices){
                foreach($get_today_opening_fee_invoices as $tofeei){
                    $total_received_fee=$total_received_fee + $tofeei['received_amount'];
                    echo '<tr>';
                            echo '<td>'.$tofeei['id'].'</td>';
                            $sid=$tofeei['sid'];
                            $student_table='student';
                            $get_student_info=$this->NewFeeModel->get_item_data($sid,$student_table);
                            if($get_student_info){
                                foreach($get_student_info as $student_info){
                                    echo '<td>'.$student_info['student_name'].'</td>';
                                    echo '<td>'.$student_info['father_name'].'</td>';
                                }
                            }

                            echo '<td>'.$tofeei['estimate_amount'].'</td>';
                            echo '<td>'.$tofeei['discount'].'</td>';
                            echo '<td>'.$tofeei['received_amount'].'</td>';
                            echo '<td>'.$tofeei['balance_amount'].'</td>';
                        echo '</tr>';                        
                    }
                }
                echo '<tr>';    
                    echo '<th>Total</th>';
                    echo '<th></th>';
                    echo '<th></th>';
                    echo '<th></th>';
                    echo '<th></th>';
                    echo '<th>'.$total_received_fee.'</th>';
                    echo '<th></th>';
                echo '</tr>';
            echo '</tbody>';
        echo '</table>';    
    }
    
    
    public function admission_and_enquiry_fee_for_today(){
        // $fee_date=$_POST['today_fee_date'];
        
        $from_date=$_POST['from_date'];
        $to_date=$_POST['to_date'];
        
        
        $total_fee=0;
        echo '<table class="table table-bordered table-striped">';
            echo '<thead>';
                echo '<tr>';
                    echo '<th colspan="10">Admission and Enquiry fee collection for '.date('d-M-Y',strtotime($from_date)).' to '.date('d-M-Y',strtotime($to_date)).'</th>';
                echo '</tr>';
                echo '<tr>';
                    echo '<th>Fee No.</th>';
                    echo '<th>Students Name</th>';
                    echo "<th>Father's Name</th>";
                    echo '<th>Course</th>';
                    echo '<th>Fee Type</th>';
                    echo '<th>Est. Fee</th>';
                    echo '<th>Discount</th>';
                    echo '<th>Received</th>';
                    echo '<th>Balance</th>';
                    echo '<th>Received By</th>';
                echo '</tr>';
            echo '</thead>';
            echo '<tbody>';
            // $get_day_admission_fee_invoices=$this->NewFeeModel->get_day_admission_fee_invoices($fee_date);
            
            $get_day_admission_fee_invoices=$this->NewFeeModel->get_date_range_admission_fee_invoices($from_date,$to_date);
            if($get_day_admission_fee_invoices){
                foreach($get_day_admission_fee_invoices as $day_admission_fee_invoices){
                    $enquiry_id=$day_admission_fee_invoices['enquiry_id'];
                    $enquiry_table='enquiry';
                        echo '<tr>';
                            echo '<td>'.$day_admission_fee_invoices['fee_no'].'</td>';
                            $get_enquiry_info=$this->NewFeeModel->get_item_data($enquiry_id,$enquiry_table);
                            if($get_enquiry_info){
                                foreach($get_enquiry_info as $enquiry_info){
                                    echo '<td>'.$enquiry_info['first_name'].' '.$enquiry_info['last_name'].'</td>';
                                    echo '<td>'.$enquiry_info['father_name'].'</td>'; 
                                    $course_id=$enquiry_info['course_id'];
                                    $courses_table='courses';
                                    $get_course_info=$this->NewFeeModel->get_item_data($course_id,$courses_table);
                                    if($get_course_info){
                                        foreach($get_course_info as $course_info){
                                            echo '<td>'.$course_info['course'].' '.$course_info['subject_stream'].' </td>';        
                                        }
                                    }
                                    
                                }
                            }
                            echo '<td>'.$day_admission_fee_invoices['fee_type'].'</td>';
                            echo '<td>'.$day_admission_fee_invoices['estimate_amount'].'</td>';
                            echo '<td>'.$day_admission_fee_invoices['discount'].'</td>';
                            echo '<td>'.$day_admission_fee_invoices['received_amount'].'</td>';
                            $total_fee=$total_fee + $day_admission_fee_invoices['received_amount'];
                            echo '<td>'.$day_admission_fee_invoices['balance_amount'].'</td>';
                            
                            $tid=$day_admission_fee_invoices['tid'];
                            $staff_table='school_staff';
                            $get_staff_info=$this->NewFeeModel->get_item_data($tid,$staff_table);
                            if($get_staff_info){
                                foreach($get_staff_info as $staff_info){
                                    echo '<td>'.$staff_info['name'].'</td>';
                                }
                            }
                        echo '</tr>';                    
                }
            }
            
            
            
            // $get_day_enquiry_fee_invoices=$this->NewFeeModel->get_day_enquiry_fee_invoices($fee_date);
            
            $get_day_enquiry_fee_invoices=$this->NewFeeModel->get_date_range_enquiry_fee_invoices($from_date,$to_date);
            
            if($get_day_enquiry_fee_invoices){
                foreach($get_day_enquiry_fee_invoices as $day_enquiry_fee_invoices){
                    $enquiry_id=$day_enquiry_fee_invoices['enquiry_id'];
                    $enquiry_table='enquiry';
                        echo '<tr>';
                            echo '<td>'.$day_enquiry_fee_invoices['fee_no'].'</td>';
                            $get_enquiry_info=$this->NewFeeModel->get_item_data($enquiry_id,$enquiry_table);
                            if($get_enquiry_info){
                                foreach($get_enquiry_info as $enquiry_info){
                                    echo '<td>'.$enquiry_info['first_name'].' '.$enquiry_info['last_name'].'</td>';
                                    echo '<td>'.$enquiry_info['father_name'].'</td>'; 
                                    $course_id=$enquiry_info['course_id'];
                                    $courses_table='courses';
                                    $get_course_info=$this->NewFeeModel->get_item_data($course_id,$courses_table);
                                    if($get_course_info){
                                        foreach($get_course_info as $course_info){
                                            echo '<td>'.$course_info['course'].' '.$course_info['subject_stream'].' </td>';
                                        }
                                    }
                                    
                                }
                            }
                            echo '<td>'.$day_enquiry_fee_invoices['fee_type'].'</td>';
                            echo '<td>'.$day_enquiry_fee_invoices['estimate_amount'].'</td>';
                            echo '<td>'.$day_enquiry_fee_invoices['discount'].'</td>';
                            echo '<td>'.$day_enquiry_fee_invoices['received_amount'].'</td>';
                            $total_fee=$total_fee + $day_enquiry_fee_invoices['received_amount'];
                            echo '<td>'.$day_enquiry_fee_invoices['balance_amount'].'</td>';
                            
                            $tid=$day_enquiry_fee_invoices['tid'];
                            $staff_table='school_staff';
                            $get_staff_info=$this->NewFeeModel->get_item_data($tid,$staff_table);
                            if($get_staff_info){
                                foreach($get_staff_info as $staff_info){
                                    echo '<td>'.$staff_info['name'].'</td>';
                                }
                            }
                        echo '</tr>';
                }
            }
                echo '<tr>';
                    echo '<th>Total</th>';
                    echo '<th colspan="6"></th>';
                    echo '<th>'.$total_fee.'</th>';
                    echo '<th colspan="2"></th>';
                echo '</tr>';
            echo '</tbody>';
        echo '</table>';
    }
    
    public function get_defaulter_manually($id,$course_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/new-fee/get-defaulter-manually');
        $this->load->view('erp/new-fee/get-defaulter-manually-new');
        $this->load->view('erp/footer');
    }
    
    public function all_course_fee_defaulter($id){
        $title='All-Courses';
        $this->load->view('erp/new-fee/all-course-fee-defaulter-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "5120M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }
    
    public function defaulter_manual_pdf($id,$course_id){
        $course_table='courses';
        $course='';
        $subject_stream='';
        $ace_session_table="academic_session_details";
        $acedemic_session=$this->session->userdata('acedemic_session');
        $get_sess_data=$this->NewFeeModel->get_item_data($acedemic_session,$ace_session_table);
        $academic_year="";
        if($get_sess_data){
            foreach($get_sess_data as $ace_data){
                $academic_year=$ace_data['year_long'];
            }
        }
        $get_course_data=$this->NewFeeModel->get_item_data($course_id,$course_table);
        if($get_course_data){
            foreach($get_course_data as $course_data){
                $course=$course_data['course'];
                $subject_stream=$course_data['subject_stream'];
            }
        }
        $title="Deafaulters".$course."_".$subject_stream."_".$academic_year;
        // if($acedemic_session == 2){
        //     $this->load->view('erp/new-fee/get-prev-defaulters');    
        // }
        
        
        // $this->load->view('erp/new-fee/get-fee-defaulter-manually-pdf');
        // if($acedemic_session == 3){
            // $this->load->view('erp/new-fee/get-manual-fee-defaulter-new-1');
            $this->load->view('erp/new-fee/get-fee-defaulter-new-pdf-23-06-2023');
        // }
        
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }
    
    public function my_class_fee_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/my-class-students-fee');
        $this->load->view('erp/footer');
    }
    
    public function user_day_collection(){
        $staff_id=$_POST['tid'];
        $fee_date=$_POST['today_fee_date'];
        // $fee_date=date('Y-m-d');
        $count=0;
        $cash_total=0;
        $other_than_cash_total=0;
        $total_received=0;
        
        $grand_total_cash=0;
        $grand_total_other=0;
        $grand_total=0;
        
        $table='school_staff';
        
                    echo '
                        <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th colspan="8">User wise fee collection on '.date('d-M-Y',strtotime($fee_date)).'</th>
                            </tr>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Enquiry</th>
                                <th>Admission Fee</th>
                                <th>Monthly Fee</th>
                                <th>Opening Fee</th>
                                <th>Total
                                <th>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-cloud-arrow-down-fill" viewBox="0 0 16 16">
                                        <path d="M8 2a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 6.095 0 7.555 0 9.318 0 11.366 1.708 13 3.781 13h8.906C14.502 13 16 11.57 16 9.773c0-1.636-1.242-2.969-2.834-3.194C12.923 3.999 10.69 2 8 2zm2.354 6.854-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 1 1 .708-.708L7.5 9.293V5.5a.5.5 0 0 1 1 0v3.793l1.146-1.147a.5.5 0 0 1 .708.708z"/>
                                    </svg>
                                </th>
                            </tr>
                            <tr>
                            <td></td>
                            <td></td>
                            <td style="font-size:14px;text-align:center;" colspan="4" class="text-success"><span class="text-danger font-weight-bold">[ Invoices ]</span><span class="text-warning font-weight-bold">( Received Fee )</span>(<span class="text-success font-weight-bold"> Cash </span>/ <span class="text-info font-weight-bold">Other</span> )</td>
                            <td></td>
                            <td></td>
                            </tr>
                        </thead>';
                    echo '<tbody class="font-weight-bolder">';
                    $get_fee_admins_data=$this->NewFeeModel->get_data($table);
                    if($get_fee_admins_data){
                        foreach($get_fee_admins_data as $data){
                            if($data['fee_permission'] ==1 && $data['status'] ==0 && $staff_id==$data['id']){
                                // $staff_id=$data['id'];
                                $count=$count + 1;
                                $fee_table='student_fee';
                                
                                $total_fee_received=0;
                                echo "<tr>";
                                    echo "<td>".$count."</td>";
                                    echo "<td>".$data['salutation']." ".$data['name']."</td>";    
                            
                                    $enq_invoices_count=0;
                                    $enq_fee_received=0;
                                    $enq_cash_total=0;
                                    $enq_other_than_cash_total=0;
                                    $enq_fee_type='Enquiry Fee';
                                    $get_today_enq_fee_invoices=$this->NewFeeModel->get_staf_fee_collection_by_date($staff_id,$fee_date,$enq_fee_type,$fee_table);
                                    if($get_today_enq_fee_invoices){
                                        foreach($get_today_enq_fee_invoices as $enq_fee_invoices){
                                            $enq_invoices_count=$enq_invoices_count + 1;
                                            $enq_fee_received=$enq_fee_received + $enq_fee_invoices['received_amount'];
                                            $total_fee_received=$total_fee_received + $enq_fee_invoices['received_amount'];
                                            $enq_discount_given=$enq_discount_given + $enq_fee_invoices['discount'];
                                            if($enq_fee_invoices['payment_mode'] == 'cash'){
                                                $enq_cash_total=$enq_cash_total + $enq_fee_invoices['received_amount'];
                                            }else{
                                                $enq_other_than_cash_total=$enq_other_than_cash_total + $enq_fee_invoices['received_amount'];
                                            }
                                        }
                                    }
                                    
                                    $grand_total_cash=$grand_total_cash + $enq_cash_total;
                                    $grand_total_other=$grand_total_other + $enq_other_than_cash_total;
                                    $grand_total=$grand_total + $enq_fee_received;
                                    
                                    echo '<td><span class="text-danger font-weight-bold">[ '.$enq_invoices_count.' ]</span><span class="text-warning font-weight-bold"> ( '.$enq_fee_received.' )</span>( <span class="text-success font-weight-bold">'.$enq_cash_total.'</span> /<span class="text-info font-weight-bold"> '.$enq_other_than_cash_total.' )</span></td>';
                                    $admission_invoices_count=0;
                                    $admission_fee_received=0;
                                    $admission_cash_total=0;
                                    $admission_discount_given=0;
                                    $admission_other_than_cash_total=0;
                                    $admission_fee_type='Admission Fee';
                                    $get_today_admission_fee_invoices=$this->NewFeeModel->get_staf_fee_collection_by_date($staff_id,$fee_date,$admission_fee_type,$fee_table);
                                    if($get_today_admission_fee_invoices){
                                        foreach($get_today_admission_fee_invoices as $admission_fee_invoices){
                                            $admission_invoices_count=$admission_invoices_count + 1;
                                            $admission_fee_received=$admission_fee_received + $admission_fee_invoices['received_amount'];
                                            $total_fee_received=$total_fee_received + $admission_fee_invoices['received_amount'];
                                            
                                            $admission_discount_given=$admission_discount_given + $admission_fee_invoices['discount'];
                                            if($admission_fee_invoices['payment_mode'] == 'cash'){
                                                $admission_cash_total=$admission_cash_total + $admission_fee_invoices['received_amount'];
                                            }else{
                                                $admission_other_than_cash_total=$admission_other_than_cash_total + $admission_fee_invoices['received_amount'];
                                            }
                                        }   
                                    }
                                    
                                    $grand_total_cash=$grand_total_cash + $admission_cash_total;
                                    $grand_total_other=$grand_total_other + $admission_other_than_cash_total;
                                    $grand_total=$grand_total + $admission_fee_received;
                                    
                                    echo '<td><span class="text-danger font-weight-bold">[ '.$admission_invoices_count.' ]</span><span class="text-warning font-weight-bold"> ( '.$admission_fee_received.' )</span> (<span class="text-success font-weight-bold"> '.$admission_cash_total.'</span> / <span class="text-info font-weight-bold">'.$admission_other_than_cash_total.'</span> )</td>';
                                    $monthly_fee_invoices_count=0;
                                    $monthly_fee_received=0;
                                    $monthly_fee_discount_given=0;
                                    $monthly_fee_cash_total=0;
                                    $monthly_fee_other_than_cash_total=0;

                            
                            $monthly_fee_type='Monthly';
                            $get_today_monthly_fee_invoices=$this->NewFeeModel->get_staf_fee_collection_by_date($staff_id,$fee_date,$monthly_fee_type,$fee_table);
                            if($get_today_monthly_fee_invoices){
                                foreach($get_today_monthly_fee_invoices as $today_monthly_fee_invoices){
                                    $monthly_fee_invoices_count=$monthly_fee_invoices_count + 1;
                                    $monthly_fee_received=$monthly_fee_received + $today_monthly_fee_invoices['received_amount'];
                                    
                                    $total_fee_received=$total_fee_received + $today_monthly_fee_invoices['received_amount'];
                                    
                                    $monthly_fee_discount_given=$monthly_fee_discount_given + $today_monthly_fee_invoices['discount'];
                                    if($today_monthly_fee_invoices['payment_mode'] == 'cash'){
                                        $monthly_fee_cash_total=$monthly_fee_cash_total + $today_monthly_fee_invoices['received_amount'];
                                    }else{
                                        $monthly_fee_other_than_cash_total=$monthly_fee_other_than_cash_total + $today_monthly_fee_invoices['received_amount'];
                                    }
                                    
                                    
                                }
                            }      
                            
                                $grand_total_cash=$grand_total_cash + $monthly_fee_cash_total;
                                $grand_total_other=$grand_total_other + $monthly_fee_other_than_cash_total;
                                $grand_total=$grand_total + $monthly_fee_received;
                                
                                echo '<td> <span class="text-danger font-weight-bold">[ '.$monthly_fee_invoices_count.' ]</span> <span class="text-warning font-weight-bold">( '.$monthly_fee_received.' )</span>( <span class="text-success font-weight-bold">'.$monthly_fee_cash_total.' </span>/ <span class="text-info font-weight-bold">'.$monthly_fee_other_than_cash_total.'</span> )</td>';    
                                
                                
                                $opening_fee_invoices_count=0;
                                $opening_fee_received=0;
                                $opening_fee_discount_given=0;
                                $opening_fee_cash_total=0;
                                $opening_fee_other_than_cash_total=0;
                                
                                $opening_fee_table='opening_balance_fee';
                                $get_today_userwise_opening_fee=$this->NewFeeModel->get_today_userwise_opening_fee($staff_id,$fee_date,$opening_fee_table);
                                if($get_today_userwise_opening_fee){
                                    foreach($get_today_userwise_opening_fee as $today_userwise_opening_fee){
                                        $opening_fee_invoices_count=$opening_fee_invoices_count + 1;
                                        $opening_fee_received=$opening_fee_received + $today_userwise_opening_fee['received_amount'];
                                        
                                        $total_fee_received=$total_fee_received + $today_userwise_opening_fee['received_amount'];
                                        
                                        $opening_fee_discount_given = $opening_fee_discount_given + $today_userwise_opening_fee['discount'];
                                        if($today_userwise_opening_fee['payment_mode'] =='cash'){
                                            $opening_fee_cash_total = $opening_fee_cash_total + $today_userwise_opening_fee['received_amount'];
                                        }else{
                                            $opening_fee_other_than_cash_total = $opening_fee_other_than_cash_total + $today_userwise_opening_fee['received_amount'];
                                        }
                                        
                                    }
                                }
                                
                                $grand_total_cash=$grand_total_cash + $opening_fee_cash_total;
                                $grand_total_other=$grand_total_other + $opening_fee_other_than_cash_total;
                                $grand_total=$grand_total + $opening_fee_received;
                                
                                echo '<td> <span class="text-danger font-weight-bold">[ '.$opening_fee_invoices_count.' ]</span> <span class="text-warning font-weight-bold">( '.$opening_fee_received.' )</span>(<span class="text-success font-weight-bold"> '.$opening_fee_cash_total.'</span> / <span class="text-info font-weight-bold">'.$opening_fee_other_than_cash_total.'</span> )</td>';
                                echo '<td><span class="text-success">'.$total_fee_received.'</span></td>';
                                // echo "<td>".$invoices_count."</td>";
                                
                                // echo "<td>".$discount_given."</td>";
                            
                                echo '<td>
                                        <a href="'.base_url().'FeeManagement/user_fee_collection/'.$data['id'].'/'.date('d',strtotime($fee_date)).'/'.date('m',strtotime($fee_date)).'/'.date('Y',strtotime($fee_date)).'" class="btn btn-sm btn-success" type="button" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye-fill" viewBox="0 0 16 16">
                                                <path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z"/>
                                                <path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8zm8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z"/>
                                            </svg>
                                        </a>
                                        <a href="'.base_url().'FeeManagement/user_fee_collection_pdf/'.$data['id'].'/'.date('d',strtotime($fee_date)).'/'.date('m',strtotime($fee_date)).'/'.date('Y',strtotime($fee_date)).'" class="btn btn-sm btn-danger" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-pdf-fill" viewBox="0 0 16 16">
                                                <path d="M5.523 10.424c.14-.082.293-.162.459-.238a7.878 7.878 0 0 1-.45.606c-.28.337-.498.516-.635.572a.266.266 0 0 1-.035.012.282.282 0 0 1-.026-.044c-.056-.11-.054-.216.04-.36.106-.165.319-.354.647-.548zm2.455-1.647c-.119.025-.237.05-.356.078a21.035 21.035 0 0 0 .5-1.05 11.96 11.96 0 0 0 .51.858c-.217.032-.436.07-.654.114zm2.525.939a3.888 3.888 0 0 1-.435-.41c.228.005.434.022.612.054.317.057.466.147.518.209a.095.095 0 0 1 .026.064.436.436 0 0 1-.06.2.307.307 0 0 1-.094.124.107.107 0 0 1-.069.015c-.09-.003-.258-.066-.498-.256zM8.278 4.97c-.04.244-.108.524-.2.829a4.86 4.86 0 0 1-.089-.346c-.076-.353-.087-.63-.046-.822.038-.177.11-.248.196-.283a.517.517 0 0 1 .145-.04c.013.03.028.092.032.198.005.122-.007.277-.038.465z"/>
                                                <path fill-rule="evenodd" d="M4 0h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm.165 11.668c.09.18.23.343.438.419.207.075.412.04.58-.03.318-.13.635-.436.926-.786.333-.401.683-.927 1.021-1.51a11.64 11.64 0 0 1 1.997-.406c.3.383.61.713.91.95.28.22.603.403.934.417a.856.856 0 0 0 .51-.138c.155-.101.27-.247.354-.416.09-.181.145-.37.138-.563a.844.844 0 0 0-.2-.518c-.226-.27-.596-.4-.96-.465a5.76 5.76 0 0 0-1.335-.05 10.954 10.954 0 0 1-.98-1.686c.25-.66.437-1.284.52-1.794.036-.218.055-.426.048-.614a1.238 1.238 0 0 0-.127-.538.7.7 0 0 0-.477-.365c-.202-.043-.41 0-.601.077-.377.15-.576.47-.651.823-.073.34-.04.736.046 1.136.088.406.238.848.43 1.295a19.707 19.707 0 0 1-1.062 2.227 7.662 7.662 0 0 0-1.482.645c-.37.22-.699.48-.897.787-.21.326-.275.714-.08 1.103z"/>
                                            </svg>
                                        </a>                            
                            
                            <a href="#" class="btn btn-sm btn-info" >
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-spreadsheet-fill" viewBox="0 0 16 16">
                                    <path d="M12 0H4a2 2 0 0 0-2 2v4h12V2a2 2 0 0 0-2-2zm2 7h-4v2h4V7zm0 3h-4v2h4v-2zm0 3h-4v3h2a2 2 0 0 0 2-2v-1zm-5 3v-3H6v3h3zm-4 0v-3H2v1a2 2 0 0 0 2 2h1zm-3-4h3v-2H2v2zm0-3h3V7H2v2zm4 0V7h3v2H6zm0 1h3v2H6v-2z"/>
                                </svg>
                            </a>
                            </td>
                            ';

                        echo "</tr>";
                        
                                // =$grand_total_cash + $opening_fee_cash_total;
                                // $grand_total_other=$grand_total_other + $opening_fee_other_than_cash_total;
                                // $grand_total=$grand_total + $opening_fee_received;

                        }
                    }
                }
                        echo "<tr>";
                            echo "<td></td>";
                            echo "<td colspan=''>Cash</td>";
                            echo "<td class='text-success'>".$grand_total_cash."</td>";
                            echo "<td>Other then cash</td>";
                            echo "<td class='text-info'>".$grand_total_other."</td>";
                            echo "<td>Total</td>";
                            echo "<td class='text-success'>".$grand_total."</td>";
                            echo "<td></td>";
                        echo "</tr>";
            echo '</tbody></table>';
    }
    
    
    public function rte_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/rte-students');
        $this->load->view('erp/footer');
    }
    
    public function defaulter_new(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/defaulter-new');
        $this->load->view('erp/footer');
    }
    
    public function defaulter_new_data($course_id){
        // $data['month_from']="";
        // $data['month_to']="";
        $data['course_id']=$course_id;
        // $data['status']="";
        // if(isset($_POST['search'])){
        //     $data['month_from']=$_POST['month_from'];
        //     $data['month_to']=$_POST['month_to'];
        //     $data['course_id']=$_POST['course'];
        //     $data['status']=$_POST['status'];
            
            
        // }
        
        
        
        $title='All-Courses';
        // $this->load->view('erp/new-fee/all-course-fee-defaulter-pdf');defaulter_new_data
        $this->load->view('erp/new-fee/defaulter-new-data',$data);
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "5120M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$title", array("Attachment"=>0));
    }
    
    
    
    public function get_course_sections(){
        $course=$_POST['course'];
        $acedemic_session=$this->session->userdata("acedemic_session");
        $def_sec=$this->session->userdata("search_filter_section");
        $get_course_sections=$this->NewFeeModel->get_course_sections($course,$acedemic_session);
        if($get_course_sections){
            echo '<option value="">--- Select Section ---</option>';
            foreach($get_course_sections as $sections){
                if($sections['section'] !=""){
                    
                    if($def_sec == $sections['section']){
                        echo '<option value="'.$sections['section'].'" selected>'.$sections['section'].'</option>';    
                    }else{
                        echo '<option value="'.$sections['section'].'">'.$sections['section'].'</option>';    
                    }
                    
                }
                
            }
        }
    }
    
    
    
    public function pay_student_fee(){
        
        $data['error']='';$data['success']='';
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }

        if(isset($_POST['opening_balance_submit'])){
            $sid=$this->input->post('sid');
            $opening_fee_amount=$this->input->post('opening_fee_amount');
            $fee_for_ac_sess=$this->input->post('fee_for_ac_sess');
            
            $fee_note=$this->input->post('fee_note');
            $table='opening_balance';
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $data_array=array("fee_note"=>$fee_note,"sid"=>$sid,"opening_fee_amount"=>$opening_fee_amount,"cat"=>$cat,"cat_by"=>$tid,"fee_for_ac_sess"=>$fee_for_ac_sess);
            $check_opening_balance=$this->OpeningBalanceModel->check_opening_balancce($sid);
            if($check_opening_balance){
                foreach($check_opening_balance as $opening_balance){
                    
                }
                $data['error']='Already Added';
            }else{
                $add_opening_balance=$this->OpeningBalanceModel->insert_data($data_array,$table);
                if($add_opening_balance){
                    $data['success']='Added Successfully';
                }else{
                    $data['error']='Error in adding opening balance';
                }

            }
        }
        $data['success1']='';  $data['error1']='';
        if(isset($_POST['update_course_id'])){
            
            $sid=$this->input->post('sid');
            $course_id=$this->input->post('course_id');
            $course=$this->input->post('course');
            $acedemic_session=$this->session->userdata('acedemic_session');
            
            
            $check_student_course_data_for_session=$this->NewFeeModel->get_studdents_current_course_data($sid,$acedemic_session);
            if($check_student_course_data_for_session){
                foreach($check_student_course_data_for_session as $course_data){
                    $active_course_id=$course_data['course_id'];
                    $active_course=$course_data['class'];
                    
                    if($course_id ==$active_course_id){
                        $data['error1']='Course is same as old';
                    }else if($course_id !=$active_course_id && $active_course == $course){
                        $data_array_update=array("course_id"=>$course_id);
                        $update_course_data=$this->NewFeeModel->update_course_data($sid,$acedemic_session,$data_array_update);
                        if($update_course_data){
                            $data['success1']='Student Course Updated Successfully';
                        }
                    }
                    
                }
            }
            
        }
        
        // pay-student-fee.php
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/pay-student-fee',$data);
        $this->load->view('erp/transport/pay-fee');
        $this->load->view('erp/footer');
    }
    
    
    
    public function get_balance_amount_new(){
            $acedemic_session=$_POST['acedemic_session'];
            $sid=$_POST['sid'];
            $fee_type=$_POST['fee_type'];
            $course_id=$_POST['course_id'];
            $new_admission=$_POST['new_admission'];
            $estimate_fee=0;
            $received_fee=0;
            $discount_fee=0;
            $last_invoice_id="";

            $get_fee_structure=$this->NewFeeModel->fee_structure($course_id,$acedemic_session);
            
            $get_student_fee_invoices=$this->NewFeeModel->get_student_fee_invoices($sid,$acedemic_session);
            if($get_student_fee_invoices){
                foreach($get_student_fee_invoices as $inv){
                    $last_invoice_id=$inv['fee_no'];
                    
                    $received_fee = $received_fee + $inv['received_amount'];
                    $discount_fee = $discount_fee + $inv['discount'];
                    // months
                    
                    $april_fee_status=$inv["april"];
                    $may_fee_status=$inv["may"];
                    $june_fee_status=$inv["june"];
                    $july_fee_status=$inv["july"];
                    $august_fee_status=$inv["august"];
                    $september_fee_status=$inv["september"];
                    $october_fee_status=$inv["october"];
                    $november_fee_status=$inv["november"];
                    $december_fee_status=$inv["december"];
                    $january_fee_status=$inv["january"];
                    $february_fee_status=$inv["february"];
                    $march_fee_status=$inv["march"];
                    
                    if($get_fee_structure){
                        foreach($get_fee_structure as $fee_structure){
                            if($april_fee_status == 1 && $fee_structure['april'] == 1){
                                if($new_admission == "Yes"){
                                    $estimate_fee = $estimate_fee + $fee_structure['amount'];
                                }else{
                                    if($fee_structure['fee_head'] == 2){
                                            
                                    }else{
                                        $estimate_fee = $estimate_fee + $fee_structure['amount'];
                                    }
                                }
                            }
                            if($may_fee_status == 1 && $fee_structure['may'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($june_fee_status == 1 && $fee_structure['june'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($july_fee_status == 1 && $fee_structure['july'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($august_fee_status == 1 && $fee_structure['august'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($september_fee_status == 1 && $fee_structure['september'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($october_fee_status == 1 && $fee_structure['october'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($november_fee_status == 1 && $fee_structure['november'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($december_fee_status == 1 && $fee_structure['december'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($january_fee_status == 1 && $fee_structure['january'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($february_fee_status == 1 && $fee_structure['february'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                            if($march_fee_status == 1 && $fee_structure['march'] == 1){
                                
                                $estimate_fee=$estimate_fee + $fee_structure['amount'];
                                
                            }
                        
                        }
                    }
                }
            }
            
            
            $balance_fee=0;
            $extra_fee=0;
            $total_rec_and_dis=$received_fee + $discount_fee;
            if($estimate_fee >= $total_rec_and_dis){
                $balance_fee=$estimate_fee - $total_rec_and_dis;
            }else{
                $extra_fee=$total_rec_and_dis - $estimate_fee; 
            }
            
            $response_array=array(
                "error"=>false,
                "estimate_fee"=>$estimate_fee,
                "received"=>$received_fee,
                "discount"=>$discount_fee,
                "balance"=>$balance_fee,
                "extra"=>$extra_fee,
                "last_invoice_id"=>$last_invoice_id
            );
            
            echo json_encode($response_array);
            
    }
    
    
    public function academic_year_fee_details(){
        $acedemic_session=$_POST['acedemic_session'];
        $sid=$_POST['sid'];
        $fee_type=$_POST['fee_type'];
        
        
        $estimate_fee=0;
        $received_fee=0;
        $discount_fee=0;
        
        
        $apr_status=0;
        $may_status=0;
        $jun_status=0;
        $jul_status=0;
        $aug_status=0;
        $sep_status=0;
        $oct_status=0;
        $nov_status=0;
        $dec_status=0;
        $jan_status=0;
        $feb_status=0;
        $mar_status=0;
        
        $course_id='';
        $new_admission="";
        $get_course_data=$this->NewFeeModel->get_studdents_current_course_data($sid,$acedemic_session);
        if($get_course_data){
            foreach($get_course_data as $course_data){
                $course_id=$course_data['course_id'];
                $new_admission=$course_data['new_admission'];
                
                $get_student_fee_data=$this->NewFeeModel->get_fee_data_for($sid,$acedemic_session);
                if($get_student_fee_data){
                    foreach($get_student_fee_data as $fee_data){
                        $received_fee=$received_fee + $fee_data['received_amount'];
                        $discount_fee=$discount_fee + $fee_data['discount'];
                    
                        $apr_status=$apr_status + $fee_data['april'];
                        $may_status=$may_status + $fee_data['may'];
                        $jun_status=$jun_status + $fee_data['june'];
                        $jul_status=$jul_status + $fee_data['july'];
                        $aug_status=$aug_status + $fee_data['august'];
                        $sep_status=$sep_status + $fee_data['september'];
                        $oct_status=$oct_status + $fee_data['october'];
                        $nov_status=$nov_status + $fee_data['november'];
                        $dec_status=$dec_status + $fee_data['december'];
                        $jan_status=$jan_status + $fee_data['january'];
                        $feb_status=$feb_status + $fee_data['february'];
                        $mar_status=$mar_status + $fee_data['march'];
                    }
                }
            
                $get_fee_structure=$this->NewFeeModel->fee_structure($course_id,$acedemic_session);
                if($get_fee_structure){
                    foreach($get_fee_structure as $fee_structure){
                        if($fee_structure['april'] == 1){
                            // $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                    
                    
                            if($new_admission == "Yes"){
                                $estimate_fee = $estimate_fee + $fee_structure['amount'];
                            }else{
                                if($fee_structure['fee_head'] == 2){
                                            
                                }else{
                                    $estimate_fee = $estimate_fee + $fee_structure['amount'];
                                }
                            }
                        } 
                        
                        if($fee_structure['may'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        } 
                
                        if($fee_structure['june'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        } 
                
                        if($fee_structure['july'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        } 
                
                        if($fee_structure['august'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        }  
                
                        if($fee_structure['september'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        }
                
                        if($fee_structure['october'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        } 
                
                        if($fee_structure['november'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        } 
                
                        if($fee_structure['december'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        }
                
                        if($fee_structure['january'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        } 
                
                        if($fee_structure['february'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        }
                
                        if($fee_structure['march'] == 1){
                            $estimate_fee = $estimate_fee + $fee_structure['amount']; 
                        }
                    }
                }
        
       
            }
        }
        
        
        
        $month_string="";
        if($apr_status == 0){
            $month_string .="April,";
        }
        if($may_status == 0){
            $month_string .="May,";
        }
        if($jun_status == 0){
            $month_string .=" June,";
        }
        if($jul_status == 0){
            $month_string .=" July,";
        } 
        if($aug_status == 0){
            $month_string .=" August,";
        } 
        
        if($sep_status == 0){
            $month_string .=" September,";
        } 
        
        if($oct_status == 0){
            $month_string .=" October,";
        } 
        
        if($nov_status  == 0){
            $month_string .=" November,";
        } 
        
        if($dec_status ==0){
            $month_string .=" December,";
        } 
        
        if($jan_status == 0){
            $month_string .=" January,";
        } 
        
        if($feb_status == 0){
            $month_string .=" February,";
        } 
        
        if($mar_status == 0){
            $month_string .=" March";
        }
        
        
        $balance_fee=0;
        $extra_fee=0;
        $total_rec_and_dis=$received_fee + $discount_fee;
        if($estimate_fee >= $total_rec_and_dis){
            $balance_fee=$estimate_fee - $total_rec_and_dis;
        }else{
            $extra_fee=$total_rec_and_dis - $estimate_fee; 
        }
            
        $response_array=array(
            "error"=>false,
            "estimate_fee"=>$estimate_fee,
            "received"=>$received_fee,
            "discount"=>$discount_fee,
            "balance"=>$balance_fee,
            "extra"=>$extra_fee,
            "due_months"=>$month_string
        );
            
        echo json_encode($response_array);
                                
                                
    }
    
}