<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Examination extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('StudentModel');
        $this->load->model('NewExamModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('FeeModel');
        $this->load->model('SchoolModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
         $this->load->library('Pdf');
    }
    
    public function index(){
        $data['success']=''; $data['error']='';
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/all-exams',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_new_exam(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_new_exam'])){
            $acedemic_session=$this->input->post('acedemic_session');
            $exam_title=$this->input->post('exam_title');
            $exam_type=$this->input->post('exam_type');
            // $course_id=$this->input->post('course_id');
            $table='all_exams';
            
            
            $data_array=array("acedemic_session"=>$acedemic_session,"exam_title"=>$exam_title,"exam_type"=>$exam_type);
            $check_exam_exist=$this->NewExamModel->check_exam_exist($acedemic_session,$exam_title,$exam_type);
            if($check_exam_exist){
            }else{
                $add_exam=$this->NewExamModel->insert_data($data_array,$table);
                if($add_exam){
                    $data['success']="Exam Added Successfully";
                }else{
                    $data['error']="Error in adding exam";
                }
            }
            
        }
        
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-new-exams',$data);
        $this->load->view('erp/footer');
    }
    
    
    public function schedule(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/all-courses-exam-schedule');
        $this->load->view('erp/exam/new/exam-schedule');
        $this->load->view('erp/footer');
    }
    
    public function course_exam_schedule(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/courses-exam-schedule');
        // $this->load->view('erp/exam/new/exam-schedule');
        $this->load->view('erp/footer');
    }
    
    public function add_exam_shift(){
        $data['success']='';$data['error']='';
        if(isset($_POST['add_exam_shift'])){
            $exam_id=$this->input->post('exam_id');
            $acedemic_session=$this->input->post('acedemic_session');
            $acedemic_session_info=$this->input->post('acedemic_session_info');
            $exam_start_time=$this->input->post('exam_start_time');
            $exam_end_time=$this->input->post('exam_end_time');
            $exam_shift_table='exam_shift';
            
            $data_array=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"acedemic_session_info"=>$acedemic_session_info,"start_time"=>$exam_start_time,"end_time"=>$exam_end_time);
            $check_exam_exist=$this->NewExamModel->check_exam_shift_exist($exam_id,$acedemic_session,$exam_start_time,$exam_end_time);
            if($check_exam_exist){
                $data['error']='Already Exist';
            }else{
                $add_exam_shift=$this->NewExamModel->insert_data($data_array,$exam_shift_table);
                if($add_exam_shift){
                    $data['success']='Exam Shift Added Successfully';
                }else{
                    $data['error']="Error in adding exam shift";
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-exam-shift',$data);
        $this->load->view('erp/footer');
    }
    
    public function exam_shift(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/exam-shift');
        $this->load->view('erp/footer');
    }
    
    public function dashboard(){
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/all-courses');
        $this->load->view('erp/footer');
    }
    
    public function add_subject(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-subject');
        $this->load->view('erp/footer');
    }
    
    public function insert_subjects(){
        $acedemic_session=$_POST['acedemic_session'];
        $course_id=$_POST['course_id'];
        $acedemic_session_info=$_POST['acedemic_session_info'];
        $subject=$_POST['subject'];
        $data_array=array("acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject"=>$subject,"cat"=>date('Y-m-d H:i:s'));
        $table='exam_subjects_'.$acedemic_session.'';
        
        $check_subject_exist=$this->NewExamModel->check_course_exam_subject_exist($acedemic_session,$course_id,$subject);
        if($check_subject_exist){
            echo "Already Added";
        }else{
            $add_subject=$this->NewExamModel->insert_data($data_array,$table); 
            if($add_subject){
                echo "Added Successfully";
            }
        }
        
    }
    
    public function insert_exam_heads(){
        $acedemic_session=$_POST['acedemic_session'];
        $course_id=$_POST['course_id'];
        $acedemic_session_info=$_POST['acedemic_session_info'];
        $exam_head=$_POST['exam_head'];
        $data_array=array("acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"exam_head"=>$exam_head);
        $table='exam_heads_'.$acedemic_session.'';
        
        $check_exam_head_exist=$this->NewExamModel->check_course_exam_head_exist($acedemic_session,$course_id,$exam_head);
        if($check_exam_head_exist){
            echo "Alreday Exist";
        }else{
            $add_exam_head=$this->NewExamModel->insert_data($data_array,$table);
            if($add_exam_head){ echo "Exam Head Added Successfully"; }
        }
    }
    
    
    
    public function course_subjects(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/course-subjects');
        $this->load->view('erp/footer');
    }
    
    public function update_subject_info(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['update_subject_info'])){
            $acedemic_session=$this->session->userdata('acedemic_session');
            
            $subject_id=$this->input->post('subject_id');
            $subject=$this->input->post('subject');
            $subject_order=$this->input->post('subject_order');
            $MM=$this->input->post('MM');
            $exam_type=$this->input->post('exam_type');
            $subject_type=$this->input->post('subject_type');
            $hic_subject_id=$_POST['hic_subject_id'];
            $class=$_POST['class'];
            
            $hic_subject="";
            $hic_subject_table="exam_subjects_3_new";
            $get_hic_subject_info=$this->NewExamModel->get_item_data($hic_subject_id,$hic_subject_table);
            if($get_hic_subject_info){
                foreach($get_hic_subject_info as $hic_subject_info){
                    $hic_subject=$hic_subject_info["subject"];
                }
            }
            
            $subject_table='exam_subjects_'.$acedemic_session.'';
            $data_array_update=array("subject"=>$subject,"subject_order"=>$subject_order,"MM"=>$MM,"exam_type"=>$exam_type,"subject_type"=>$subject_type,"hic_subject_id"=>$hic_subject_id,"hic_subject"=>$hic_subject,"class"=>$class);
            
            $update_subject_data=$this->NewExamModel->update_item_data($subject_id,$data_array_update,$subject_table);
            if($update_subject_data){
                $data['success']='Subject Updated Successfully';
            }
            
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/update-subject-info',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_exam_head(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-exam-head');
        $this->load->view('erp/footer');
    }
    
    public function course_exam_heads(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/course-exam-heads');
        $this->load->view('erp/footer');
    }
    
    public function update_exam_heads(){
        $data['success']='';$data['error']='';
        if(isset($_POST['update_fee_head_info'])){
            $acedemic_session=$this->input->post('acedemic_session');
            $acedemic_session_info=$this->input->post('acedemic_session_info');
            $exam_head_id=$this->input->post('exam_head_id');
            $exam_head=$this->input->post('exam_head');
            $mm=$this->input->post('mm');
            $exam_head_order=$this->input->post('exam_head_order');
            $exam_mode=$this->input->post('exam_mode');
            $freeze=$_POST['freeze'];
            $updated_by=$this->session->userdata('tid');
            $uat=date('Y-m-d H:i:s');
            $exam_head_table='exam_heads_'.$acedemic_session.'';
            $data_array_update=array("acedemic_session"=>$acedemic_session,"acedemic_session_info"=>$acedemic_session_info,"exam_head"=>$exam_head,"mm"=>$mm,"head_order"=>$exam_head_order,"exam_mode"=>$exam_mode,"updated_by"=>$updated_by,"uat"=>$uat,"status"=>1,"freeze"=>$freeze);
            $update_exam_head=$this->NewExamModel->update_item_data($exam_head_id,$data_array_update,$exam_head_table);
            if($update_exam_head){
                $data['success']='Updated Successfully';
            }else{
                $data['error']='Error in updating Exam Head';
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/update-exam-head',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_new_exam_schedule(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-exam-schedule');
        $this->load->view('erp/footer');
    }
    
    public function insert_exam_schedule(){
        
        $exam_id=$_POST['exam_id'];
        $acedemic_session=$_POST['acedemic_session'];
        $course_id=$_POST['course_id'];
        $acedemic_session_info=$_POST['acedemic_session_info'];
        $exam_paper=$_POST['exam_paper'];
        
        $exam_head=$_POST['exam_head'];
        
        
        $cat=date('Y-m-d H:i:s');
        $tid=$this->session->userdata('tid');
        $exam_schedule_table='exam_schedule';
        $data_array=array("exam_id"=>$exam_id,"course_id"=>$course_id,"exam_id"=>$exam_id,"cat"=>$cat,"tid"=>$tid,"acedemic_session"=>$acedemic_session,"acedemic_session_info"=>$acedemic_session_info,"exam_paper_name"=>$exam_paper);
        $check_subject_exist=$this->NewExamModel->check_exam_schedule_exist($exam_id,$course_id,$acedemic_session,$exam_paper,$exam_schedule_table);
        if($check_subject_exist){
                    
        }else{
            $insert_exam_paper=$this->NewExamModel->insert_data($data_array,$exam_schedule_table);
        }
    }
    
    public function insert_exam_date(){
        
        $exam_id=$_POST['exam_id'];
        $acedemic_session=$_POST['acedemic_session'];
        $acedemic_session_info=$_POST['acedemic_session_info'];
        $exam_date=$_POST['exam_date'];
        
        $cat=date('Y-m-d H:i:s');
        $tid=$this->session->userdata('tid');
        
        $exam_date_table='exam_date';
        
        $data_array=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"acedemic_session_info"=>$acedemic_session_info,"exam_date"=>$exam_date,"cat"=>$cat,"tid"=>$tid);
        $check_exam_date_exist=$this->NewExamModel->check_exam_date_exist($exam_id,$acedemic_session,$exam_date,$exam_date_table);
        if($check_exam_date_exist){
                    echo "Already Exist";
        }else{
            $insert_exam_date=$this->NewExamModel->insert_data($data_array,$exam_date_table);
        }
    }
    
    public function add_new_exam_date(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-exam-date');
        $this->load->view('erp/footer');
    }
    
    public function exam_dates($exam_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/exam-dates');
        $this->load->view('erp/footer');
    }
    
    public function update_exam_schedule(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['update_exam_paper_schedule'])){
            $exam_paper_schedule_id=$this->input->post('exam_paper_schedule_id');
            $exam_id=$this->input->post('exam_id');
            $acedemic_session=$this->input->post('acedemic_session');
            $exam_head=$this->input->post('exam_head');
            $subject_id=$this->input->post('subject_id');
            $course_id=$this->input->post('course_id');
            $acedemic_session_info=$this->input->post('acedemic_session_info');
            $exam_title=$this->input->post('exam_title');
            $course_info=$this->input->post('course_info');
            $exam_paper_name=$this->input->post('exam_paper_name');
            $exam_date_id=$this->input->post('exam_date_id');
            $exam_shift=$this->input->post('exam_shift');
            
            $start_time='';
            $end_time='';
            
            $exam_shift_table='exam_shift';
            $all_exam_shift=$this->NewExamModel->get_item_data($exam_shift,$exam_shift_table);
            if($all_exam_shift){
                foreach($all_exam_shift as $exam_shift_data){
                    $start_time=$exam_shift_data['start_time'];
                    $end_time=$exam_shift_data['end_time'];
                }
            }
        
            $exam_date='';
            $exam_date_table='exam_date';
            $all_exam_date=$this->NewExamModel->get_item_data($exam_date_id,$exam_date_table);
            if($all_exam_date){
                foreach($all_exam_date as $exam_date_info){
            $exam_date=$exam_date_info['exam_date'];
                }
            }
            
            $uat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $exam_schedule_table='exam_schedule';
            $data_array_update=array("exam_date_id"=>$exam_date_id,"exam_date"=>$exam_date,"exam_shift"=>$exam_shift,"exam_start_time"=>$start_time,"exam_end_time"=>$end_time,"uat"=>$uat,"upd_by"=>$tid,"subject_id"=>$subject_id,"exam_head"=>$exam_head);
            $update_schedule=$this->NewExamModel->update_item_data($exam_paper_schedule_id,$data_array_update,$exam_schedule_table);
            if($update_schedule){
                $data['success']='Updated Successfully';
            }
        }
        
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/update-exam-schedule',$data);
        $this->load->view('erp/footer');
    }
    
    public function course_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/course-students');
        $this->load->view('erp/footer');
    }
    
    public function exam_log(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/exam-log-sheet');
        $this->load->view('erp/footer');
    }
    
    public function new_exam_log(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_exam_log'])){
            $course_id=$_POST['course_id'];
            $sid=$_POST['sid'];
            
            $acedemic_session=$this->session->userdata('acedemic_session');
            $subject_table='exam_subjects_'.$acedemic_session.'';
            $all_active_subjects=$this->NewExamModel->get_course_active_subjects($course_id,$subject_table);
            if($all_active_subjects){
                foreach($all_active_subjects as $subjects){
                    $exam_type=$subjects['exam_type'];
                    // $sub_count=$sub_count + 1;
                    $subject_id=$subjects['id'];
                    $exam_head_table='exam_heads_'.$acedemic_session.'';
                    $all_exam_heads=$this->NewExamModel->get_course_exam_heads($course_id,$exam_head_table);
                    if($all_exam_heads){
                        foreach($all_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            $elog_name=  "s_".$subject_id."_h_".$ehid;
                            $exam_log=$_POST[$elog_name];
                            // $update_elog_data=$this->
                            
                            $cat=date('Y-m-d H:i:s');
                            $tid=$this->session->userdata('tid');
                            
                            $data_array=array();
                            $data_array_update=array();
                            if($exam_type == 'Marks'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"obtained_marks"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("obtained_marks"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->NewExamModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->NewExamModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->NewExamModel->insert_data($data_array,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                    }
                            
                            }else if($exam_type == 'Grade'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"grade"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("grade"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->NewExamModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->NewExamModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->NewExamModel->insert_data($data_array,$elog_table);
                                        
                                        
                                    }
                            }
                            
                            
                            
                        }
                    }
                }
            }
            $data['success']='Updated Successfully';
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/new-exam-log-sheet',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_exam_log(){
        $data['success']='';$data['error']='';
        if(isset($_POST['add_exam_log'])){
            $acedemic_session=$this->input->post('acedemic_session');
            $sid=$this->input->post('sid');
            $subject_id=$this->input->post('subject_id');
            $exam_type=$this->input->post('exam_type');
            $course_id=$this->input->post('course_id');
            
            $exam_head_table='exam_heads_'.$acedemic_session.'';
                    $get_exam_heads=$this->NewExamModel->get_course_active_exam_heads($course_id,$exam_head_table);
                    if($get_exam_heads){
                        foreach($get_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            $exam_log_item='exam_log_'.$ehid.'';
                            $exam_log=$this->input->post($exam_log_item);
                            $cat=date('Y-m-d H:i:s');
                            $tid=$this->session->userdata('tid');
                            
                            $data_array=array();
                            $data_array_update=array();
                            if($exam_type == 'Marks'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"obtained_marks"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("obtained_marks"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->NewExamModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->NewExamModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->NewExamModel->insert_data($data_array,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                    }
                            
                            }else if($exam_type == 'Grade'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"grade"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("grade"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->NewExamModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->NewExamModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->NewExamModel->insert_data($data_array,$elog_table);
                                        
                                    }
                            }
                            
                          
                        }
                        redirect(base_url().'Examination/exam_log/'.$sid.'');
                    }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-exam-log');
        $this->load->view('erp/footer');
    }
    
    public function active_inactive(){
        $id=$_POST['id'];
        $val=$_POST['val'];
        $table=$_POST['table'];
        $data_array_update=array("status"=>$val);
        $update_item_data=$this->NewExamModel->update_item_data($id,$data_array_update,$table);
        
    }
    
    
    public function my_class_exam_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/my-class-students-asc');
        $this->load->view('erp/footer');
    }
    
    public function student_subjects(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/student-subjects');
        $this->load->view('erp/footer');
    }
    
    public function add_student_subjects(){
        $data['success']=""; $data['error']="";
        if(isset($_POST['allot_subjects'])){
            $sid=$_POST['sid'];
            $course_id=$_POST['course_id'];
            $acedemic_session=$_POST['acedemic_session'];
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $table='student_subjects';
            if(!empty($_POST['subject_item'])){ 
            $allot_subjects_list=$_POST['subject_item'];
            
            
            
        //   echo "<br><br><br><br><br><br>";
            
            $subjects_table="exam_subjects_".$acedemic_session;
            $course_subject_list=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
            
            
            foreach($course_subject_list as $list){
                $subject_id=$list['id'];
                $sub_count=0;
                foreach($allot_subjects_list as $subjectid){
                    // echo $data."<br>";    
                     $data_array=array("sid"=>$sid,"course_id"=>$course_id,"acedemic_session"=>$acedemic_session,"subject_id"=>$subjectid,"status"=>1,"cat_by"=>$tid,"cat"=>$cat);
                     
                    $check_student_subject_exist=$this->NewExamModel->student_subject_info($sid,$course_id,$acedemic_session,$subjectid);
                    if($subject_id == $subjectid){
                        $sub_count=$sub_count + 1;    
                        // echo "<br>".$subjectid."-".$list['subject'];
                        if($check_student_subject_exist){
                            // echo "Subject already added for student.";
                        }else{
                            $add_subject=$this->NewExamModel->insert_data($data_array,$table);
                            if($add_subject){
                                echo "Subject added successfully.";
                            }else{
                                echo "Error in adding subject.";
                            }
                        }
                    }
                }
                
                if($sub_count == 1){
                    
                }else{
                    $check_student_subject_exist=$this->NewExamModel->student_subject_info($sid,$course_id,$acedemic_session,$subject_id);
                    if($check_student_subject_exist){
                        $remove_subject=$this->NewExamModel->delete_student_subject($sid,$subject_id,$course_id,$acedemic_session,$table);
                        if($remove_subject){
                            echo "deleted";
                        }
                    }
                }
            }
            }
            
            redirect(base_url()."Examination/student_subjects/".$sid);
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        // $this->load->view('erp/school/student-profile');
        $this->load->view('erp/exam/new/add-student-subjects-new');
        $this->load->view('erp/footer');
    }
    
    
    public function update_student_subjects(){
        $subjectid=$_POST['subjectid'];
        $sid=$_POST['sid'];
        $course_id=$_POST['course_id'];
        $acedemic_session=$_POST['acedemic_session'];
        $cat=date('Y-m-d H:i:s');
        $tid=$this->session->userdata('tid');
        $table='student_subjects';
        $subjects_table="exam_subjects_".$acedemic_session;
        $course_subject_list=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
         $data_array=array("sid"=>$sid,"course_id"=>$course_id,"acedemic_session"=>$acedemic_session,"subject_id"=>$subjectid,"status"=>1,"cat_by"=>$tid,"cat"=>$cat);
        $a_student_subject=0;
        $check_student_subject_exist=$this->NewExamModel->student_subject_info($sid,$course_id,$acedemic_session,$subjectid);
        if($course_subject_list){
            foreach($course_subject_list as $subject_list){
                if($subject_list['id'] == $subjectid){
                    $a_student_subject=$a_student_subject + 1;
                    if($check_student_subject_exist){
                        echo "Subject already added for student.";
                    }else{
                        $add_subject=$this->NewExamModel->insert_data($data_array,$table);
                        if($add_subject){
                            echo "Subject added successfully.";
                        }else{
                                echo "Error in adding subject.";
                        }
                    }
                }else{
                    
                }
            }
        }
        if($a_student_subject == 1){
            
        }else{
            if($check_student_subject_exist){
                     
                $remove_subject=$this->NewExamModel->delete_student_subject($sid,$subjectid,$course_id,$acedemic_session,$table);
                   
            }
        }
    }
    
    public function exam_heads(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/exam-heads');
        // $this->load->view('erp/exam/new/all-courses-exam-schedule');
        // $this->load->view('erp/exam/new/exam-schedule');
        $this->load->view('erp/footer');
    }
    
    public function primary_report_card(){
        $this->load->view('erp/exam/report-card/primary-class-report-card');    
        
        // Get output html
        $html = $this->output->get_output();
        
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        
        // $this->pdf->setPaper('A4', 'landscape');
        $this->pdf->setPaper('A4', 'portrait');
        
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("Report Card", array("Attachment"=>0));
    }
    
    public function remarks(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/remark-list');
        $this->load->view('erp/footer');
    }
    
    public function add_remark(){
        $data['success']=''; $data['error']='';
        $data['id']="";
        if(isset($_POST['edit'])){
            $data['id']=$_POST['edit'];
        }
        
        if(isset($_POST['add_remark'])){
            $remark_id=$_POST['remark_id'];
            $remark_category=$_POST['remark_category'];
            $remark=$_POST['remark'];
            $cat=date('Y-m-d H:i:s');
            $table='exam_quote_list';
            $data_array=array("quote_type"=>$remark_category,"quote"=>$remark,"cat"=>$cat,"status"=>1);
            $tid=$this->session->userdata('tid');
            $data_array_update=array("quote_type"=>$remark_category,"quote"=>$remark,"uat"=>$cat,"status"=>1,"upd_by"=>$tid);
            
            $get_remark_data=$this->NewExamModel->get_item_data($remark_id,$table);
            if($get_remark_data){
                $check_remark_exist=$this->NewExamModel->check_remark_exist($remark,$table);
                if($check_remark_exist){
                    $data['error']='Remark Already Exist';
                }else{
                    $add_remark=$this->NewExamModel->update_item_data($remark_id,$data_array_update,$table);
                    if($add_remark){
                        $data['success']='Remark Updated Successfully';
                    }else{
                        $data['error']='';
                    }    
                }  
            }else{
                $check_remark_exist=$this->NewExamModel->check_remark_exist($remark,$table);
                if($check_remark_exist){
                    $data['error']='Remark Already Exist';
                }else{
                    $add_remark=$this->NewExamModel->insert_data($data_array,$table);
                    if($add_remark){
                        $data['success']='Remark Added Successfully';
                    }else{
                        $data['error']='';
                    }    
                }        
            }
            
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-remark',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_working_days(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_working_days'])){
            $exam=$_POST['exam'];
            $course=$_POST['course'];
            $working_days=$_POST['working_days'];
            $userid=$this->session->userdata('tid');
            $cat=date('Y-m-d H:i:s');
            $table='exam_course_data';
            $data_array=array("exam_id"=>$exam,"course_id"=>$course,"working_days"=>$working_days,"cat"=>$cat,"cat_by"=>$userid);
            $data_array_update=array("exam_id"=>$exam,"course_id"=>$course,"working_days"=>$working_days,"uat"=>$cat,"upd_by"=>$userid);
            $check_data_exist=$this->NewExamModel->check_course_exam_data($exam,$course,$table);
            if($check_data_exist){
                $update_exam_data=$this->NewExamModel->update_course_exam_data($exam,$course,$data_array_update,$table);
                if($update_exam_data){
                    $data['success']='Updated Successfully';
                }else{
                    $data['error']='Error in updating exam course information';
                }
            }else{
                $add_exam_course_data=$this->NewExamModel->insert_data($data_array,$table);
                if($add_exam_course_data){
                    $data['success']='Added Successfully !!';
                }else{
                    $data['error']='Error in adding course exam information !!';
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-working-days',$data);
        $this->load->view('erp/footer');
    }
    
    public function student_exam_data(){
        $sid=$_POST['sid'];
        $remark=$_POST['remark'];
        $total_working_days=$_POST['total_working_days'];
        $attendance=$_POST['attendance'];
        $exam_id=$_POST['exam_id'];
        $course_id=$_POST['course_id'];
        $course=$_POST['course'];
        
        $roll_no=$_POST['roll_number'];
        
        $cat=date('Y-m-d H:i:s');
        $attendance_percentage=0;
        if($total_working_days == 0){
            $attendance_percentage = 0;
        }else{
            $attendance_percentage=$attendance*100/$total_working_days;    
        }
        
        $y1=$this->session->userdata('y1');
        $y2=$this->session->userdata('y2');
        $userid=$this->session->userdata('tid');
        $acedemic_session=$this->session->userdata('acedemic_session');
        
        
        
        $student_course_data_array=array("roll_no"=>$roll_no);
        $student_course_data_table="student_courses_data";
        
        $update_student_course_data=$this->NewExamModel->update_student_course_data_1($sid,$acedemic_session,$course_id,$student_course_data_array,$student_course_data_table);
        
        $data_array=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"course_id"=>$course_id,"sid"=>$sid,"working_days"=>$total_working_days,"attendance"=>$attendance_percentage,"attendance_days"=>$attendance,"class"=>$course,"cat"=>$cat,"cat_by"=>$userid,"remark"=>$remark,"roll_no"=>$roll_no);
        
        $data_array_update=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"course_id"=>$course_id,"sid"=>$sid,"working_days"=>$total_working_days,"attendance"=>$attendance_percentage,"attendance_days"=>$attendance,"class"=>$course,"uat"=>$cat,"updated_by"=>$userid,"remark"=>$remark,"roll_no"=>$roll_no);
        
        $table='exam_result';
        
        $check_student_data_exist=$this->NewExamModel->get_student_exam_data($sid,$exam_id,$course_id,$table);
        if($check_student_data_exist){
            $update_student_exam_data=$this->NewExamModel->update_student_exam_data($sid,$exam_id,$course_id,$data_array_update,$table);
            if($update_student_exam_data){
                echo "Updated Successfully";
            }else{ echo "Error in updating data"; }
        }else{
            $add_exam_course_data=$this->NewExamModel->insert_data($data_array,$table);
            if($add_exam_course_data){
                echo 'Added Successfully !!';
            }else{
                echo 'Error in adding course exam information !!';
            }   
        }
        
        
    }
    
    public function exam_attendance_log(){
        $data['success']="";
        $data['error']="";
        if(isset($_POST['add_exam_attendance_log'])){
            $sid=$_POST['sid'];
            $course_id=$_POST['course_id'];
            
            $acedemic_session=$this->session->userdata('acedemic_session');
            $subject_table='exam_subjects_'.$acedemic_session.'';
            $all_active_subjects=$this->NewExamModel->get_course_active_subjects($course_id,$subject_table);
            if($all_active_subjects){
                foreach($all_active_subjects as $subjects){
                    $exam_type=$subjects['exam_type'];
                    // $sub_count=$sub_count + 1;
                    $subject_id=$subjects['id'];
                    $exam_head_table='exam_heads_'.$acedemic_session.'';
                    $all_exam_heads=$this->NewExamModel->get_course_exam_heads($course_id,$exam_head_table);
                    if($all_exam_heads){
                        foreach($all_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            $elog_name=  "s_".$subject_id."_h_".$ehid;
                            $attendance_log=$_POST[$elog_name];
                            
                            
                            $cat=date('Y-m-d H:i:s');
                            $tid=$this->session->userdata('tid');
                            
                            $data_array=array();
                            $data_array_update=array();
                            
                            $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"attendance"=>$attendance_log,"cat"=>$cat,"inserted_by"=>$tid);
                            $data_array_update=array("attendance"=>$attendance_log,"uat"=>$cat,"updated_by"=>$tid);
                            $elog_table='exam_log_'.$acedemic_session.'';
                            $check_log_exist=$this->NewExamModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                            if($check_log_exist){
                                $update_log_data=$this->NewExamModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                $data['success']="Attendance Log Updated Successfully";
                                // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                            }else{
                                $add_log=$this->NewExamModel->insert_data($data_array,$elog_table);
                                // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                $data['success']="Attendance Log Added Successfully";
                            }
                            
                        }
                    }
                }
            }
        }
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/exam-attendance-log',$data);
        $this->load->view('erp/footer');    
    }
    
    
    public function all_classes(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/all-course-and-section');
        $this->load->view('erp/footer');    
    }
    
    public function second_term_exam(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/all-course-and-section-second-term');
        $this->load->view('erp/footer');    
    }
    
    public function class_section_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/report-card/class-section-students');
        $this->load->view('erp/footer');       
    }
    
    public function add_new_exam_subject(){
        $table="exam_subjects_3_new";    
        $data['success']="";    $data['error']="";
        
        if(isset($_POST['add_new_subject'])){
            $class=$_POST['class'];
            $subject=$_POST['subject'];
            $mm=$_POST['mm'];
            $exam_type=$_POST['exam_type'];
            $subject_type=$_POST['subject_type'];
            $subject_order=$_POST['subject_order'];
            $tid=$this->session->userdata('tid');
            $acedemic_session=$this->session->userdata('acedemic_session');
            $cat=date('Y-m-d H:i:s');
            
            $data_array=array("class"=>$class,"subject"=>$subject,"subject_type"=>$subject_type,"subject_order"=>$subject_order,"MM"=>$mm,"status"=>1,"acedemic_session"=>$acedemic_session,"cat"=>$cat,"cat_by"=>$tid,"exam_type"=>$exam_type);
            
            $check_subject_exist=$this->NewExamModel->check_new_subject($subject,$class,$table);
            if($check_subject_exist){
                $data['error']=$subject." in class ".$class." already exists.";
            }else{
                $add_new_subject=$this->NewExamModel->insert_data($data_array,$table);
                if($add_new_subject){
                    $data['success']=$subject." in class ".$class." added successfully.";
                }else{
                    $data['error']="Error in adding new subject";
                }
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/add-new-class-exam-subject',$data);
        $this->load->view('erp/footer');    
    }
    
    
    public function class_subjects(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/new/class-subjects');
        $this->load->view('erp/footer');    
    }
    
    
    public function generate_result(){
        $class=$_POST['exam_class'];
        $section=$_POST['section'];
        $exam_id=$_POST['exam_id'];
        $acedemic_session=$_POST['acedemic_session'];
        $exam_result_table="exam_result";
        $all_students=$this->NewExamModel->get_students_ac_session_by_course_and_class($acedemic_session,$class,$section);
        
        if($all_students){
            foreach($all_students as $students){
                $student_hy_total=0;
                $result_mm=0;
                
                $course_id=$students['course_id'];
                $sid=$students['sid'];
                $student_subjects_table="student_subjects";
                $get_student_subjects=$this->NewExamModel->get_student_subjects($sid,$course_id,$acedemic_session);
                
                
                
                $subject_failure_count=0;
                $subjects_table="exam_subjects_".$acedemic_session;
                $get_course_subjects=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
                $exam_log_table="exam_log_".$acedemic_session;
                $get_student_exam_log_data=$this->NewExamModel->students_exam_log($sid,$acedemic_session,$exam_log_table);
                
                $exam_heads_table="exam_heads_".$acedemic_session;
                $get_exam_heads=$this->NewExamModel->get_exam_heads($exam_heads_table);
                
                foreach($get_course_subjects as $course_subjects){
                    $hic_subject_id=$course_subjects['hic_subject_id'];
                    $hic_subject=$course_subjects['hic_subject'];
                    
                    $subject_id=$course_subjects['id'];
                    $subject=$course_subjects["subject"];
                    $subject_mm=$course_subjects['MM'];
                    $subject_type=$course_subjects['subject_type'];
                    $exam_type=$course_subjects['exam_type'];
                    $subject_marks_obtained=0;
                    
                    if($exam_type == "Marks" && $subject_type == "Main Subject"){
                        
                        $student_subject=0;
                        if($get_student_subjects){
                            foreach($get_student_subjects as $subjectss){
                                if($subjectss['subject_id'] == $subject_id){
                                    $student_subject=$student_subject + 1;    
                                }
                                            
                            }
                        }
                        
                        if($student_subject >= 1){
                            $result_mm=$result_mm + $subject_mm;
                        foreach($get_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            if($get_student_exam_log_data){
                                foreach($get_student_exam_log_data as $exam_log){
                                    if($ehid == $exam_log['exam_head'] && $subject_id == $exam_log['subject_id']){
                                        $subject_marks_obtained =$subject_marks_obtained + $exam_log['obtained_marks'];
                                    }else{
                                    
                                    }
                                }
                            }
                        }
                    $cat=date('Y-m-d H:i:s');
                    $tid=$this->session->userdata('tid');
                    $student_hy_total=$student_hy_total + $subject_marks_obtained;
                    
                    $sub_percentage=($subject_marks_obtained*100)/$subject_mm;
                    
                    $sub_p_r=round($sub_percentage,0);
                    
                    if($sub_p_r <33){
                        $subject_failure_count=$subject_failure_count + 1;
                    }
                    $data_array_update=array("hic_subject_id"=>$hic_subject_id,"hic_subject"=>$hic_subject,"subject"=>$subject,"subject_mm"=>$subject_mm,"hy_total_marks"=>$subject_marks_obtained,"uat"=>$cat,"upd_by"=>$tid,"class"=>$class,"section"=>$section);
                    
                    // $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"hy_total_marks"=>$subject_marks_obtained,"subject"=>$subject,"subject_mm"=>$subject_mm,"cat"=>$cat,"cat_by"=>$tid,"hic_subject_id"=>$hic_subject_id,"hic_subject"=>$hic_subject);
                    
                    $update_subject_data=$this->NewExamModel->update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update);
                    
                    
                    
                        }
                    }
                }
                
                $cat=date('Y-m-d H:i:s');
                $tid=$this->session->userdata('tid');
                $percentage1=0;
                if($result_mm !=0){
                    $percentage1=($student_hy_total * 100)/$result_mm; 
                }
                
                $percentage=number_format((float)$percentage1, 2, '.', '');
                
                
                $y1=$this->session->userdata("y1");
                $y2=$this->session->userdata("y2");
                
                $result_status="";
                if($subject_failure_count == 0){
                        $result_status="Pass";
                }else{
                    $result_status="Fail";    
                }
                
                $result_data_array=array("exam_id"=>$exam_id,"sid"=>$sid,"y1"=>$y1,"y2"=>$y2,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"cat"=>$cat,"cat_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                $result_data_array_update=array("class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"uat"=>$cat,"updated_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                $get_student_result_data=$this->NewExamModel->student_result($sid,$acedemic_session,$exam_id,$course_id,$exam_result_table);
                if($get_student_result_data){
                    $update_student_result_data=$this->NewExamModel->update_student_exam_data($sid,$exam_id,$course_id,$result_data_array_update,$exam_result_table);
                }else{
                    $add_exam_result=$this->NewExamModel->insert_data($result_data_array,$exam_result_table);
                }
            }
        }
        
        $rank_count=0;
        // $get_course_result=$this->NewExamModel->get_course_result($exam_id,$acedemic_session,$course_id,$exam_result_table);
        
        $get_course_result=$this->NewExamModel->get_class_section_result($exam_id,$acedemic_session,$class,$section,$exam_result_table);
        if($get_course_result){
            foreach($get_course_result as $result){
                $id=$result['id'];
                // $rank_count=$rank_count + 1;        
                // $cat=date("Y-m-d H:i:s");
                // $tid=$this->session->userdata('tid');
                // $data_array_update=array("rank_in_class"=>$rank_count,"uat"=>$cat,"updated_by"=>$tid);
                
                // $update_hic=$this->NewExamModel->update_item_data($id,$data_array_update,$exam_result_table);
                
                
                if($result['result_status'] == "Pass"){
                    $rank_count=$rank_count + 1;        
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $data_array_update=array("rank_in_class"=>$rank_count,"uat"=>$cat,"updated_by"=>$tid);
                
                    $update_hic=$this->NewExamModel->update_item_data($id,$data_array_update,$exam_result_table);
                }else{
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $data_array_update=array("rank_in_class"=>"","uat"=>$cat,"updated_by"=>$tid);
                
                    $update_hic=$this->NewExamModel->update_item_data($id,$data_array_update,$exam_result_table);
                }
            }
        }
        echo "success";
        
    }
    
    public function a1(){
        echo $this->session->userdata('acedemic_session');
    }
    public function generate_result_lower_classes(){
        $class=$_POST['exam_class'];
        $section=$_POST['section'];
        $exam_id=$_POST['exam_id'];
        $acedemic_session=$_POST['acedemic_session'];
        
        // $class="4";
        // $section="A";
        // $exam_id=3;
        // $acedemic_session=3;
        $exam_result_table="exam_result";
        $all_students=$this->NewExamModel->get_students_ac_session_by_course_and_class($acedemic_session,$class,$section);
        
        if($all_students){
            foreach($all_students as $students){
                $student_hy_total=0;
                $result_mm=0;
                
                $course_id=$students['course_id'];
                $sid=$students['sid'];
                $student_subjects_table="student_subjects";
                $get_student_subjects=$this->NewExamModel->get_student_subjects($sid,$course_id,$acedemic_session);
                
                
                
                
                $subjects_table="exam_subjects_".$acedemic_session;
                $get_course_subjects=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
                $exam_log_table="exam_log_".$acedemic_session;
                $get_student_exam_log_data=$this->NewExamModel->students_exam_log($sid,$acedemic_session,$exam_log_table);
                
                $exam_heads_table="exam_heads_".$acedemic_session;
                $get_exam_heads=$this->NewExamModel->get_exam_heads($exam_heads_table);
                $subject_failure_count=0;
                foreach($get_course_subjects as $course_subjects){
                    // $hic_subject_id=$course_subjects['hic_subject_id'];
                    // $hic_subject=$course_subjects['hic_subject'];
                    
                    $subject_id=$course_subjects['id'];
                    $subject=$course_subjects["subject"];
                    $subject_mm=$course_subjects['MM'];
                    $subject_type=$course_subjects['subject_type'];
                    $exam_type=$course_subjects['exam_type'];
                    $subject_marks_obtained=0;
                    
                    if($exam_type == "Marks" && $subject_type == "Main Subject"){
                        
                        $student_subject=0;
                        if($get_student_subjects){
                            foreach($get_student_subjects as $subjectss){
                                if($subjectss['subject_id'] == $subject_id){
                                    $student_subject=$student_subject + 1;    
                                }
                                            
                            }
                        }
                        
                        
                            $result_mm=$result_mm + $subject_mm;
                        foreach($get_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            if($get_student_exam_log_data){
                                foreach($get_student_exam_log_data as $exam_log){
                                    if($ehid == $exam_log['exam_head'] && $subject_id == $exam_log['subject_id']){
                                        $subject_marks_obtained =$subject_marks_obtained + $exam_log['obtained_marks'];
                                }else{
                                    
                                }
                            }
                        }
                    }
                    $cat=date('Y-m-d H:i:s');
                    $tid=$this->session->userdata('tid');
                    $student_hy_total=$student_hy_total + $subject_marks_obtained;
                    $subject_percentage=($subject_marks_obtained/$subject_mm)* 100;
                    $sp1=round($subject_percentage,0);
                    $p_p=33;
                    if($sp1 < $p_p){
                        // echo $subject_percentage."<br>";
                        $subject_failure_count=$subject_failure_count + 1;
                        // echo $sp1."<br>";
                    }
                    

                    
                    // $data_array_update=array("hic_subject_id"=>$hic_subject_id,"hic_subject"=>$hic_subject,"subject"=>$subject,"subject_mm"=>$subject_mm,"hy_total_marks"=>$subject_marks_obtained,"uat"=>$cat,"upd_by"=>$tid,"class"=>$class,"section"=>$section);
                    
                    // $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"hy_total_marks"=>$subject_marks_obtained,"subject"=>$subject,"subject_mm"=>$subject_mm,"cat"=>$cat,"cat_by"=>$tid,"hic_subject_id"=>$hic_subject_id,"hic_subject"=>$hic_subject);
                    
                    $data_array_update=array("subject"=>$subject,"subject_mm"=>$subject_mm,"hy_total_marks"=>$subject_marks_obtained,"uat"=>$cat,"upd_by"=>$tid,"class"=>$class,"section"=>$section);
                    
                    $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"hy_total_marks"=>$subject_marks_obtained,"subject"=>$subject,"subject_mm"=>$subject_mm,"cat"=>$cat,"cat_by"=>$tid);
                    
                    
                        if($student_subject >= 1){
                            $update_subject_data=$this->NewExamModel->update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update);
                    
                        }else{
                            $add_subject_data=$this->NewExamModel->insert_data($data_array,$student_subjects_table);
                        }
                    }
                }
                
                $cat=date('Y-m-d H:i:s');
                $tid=$this->session->userdata('tid');
                $percentage1=0;
                if($result_mm !=0){
                    $percentage1=($student_hy_total * 100)/$result_mm; 
                }
                
                $percentage=number_format((float)$percentage1, 2, '.', '');
                
                
                $y1=$this->session->userdata("y1");
                $y2=$this->session->userdata("y2");
                $result_status="";
                if($subject_failure_count == 0){
                        $result_status="Pass";
                }else{
                    $result_status="Fail";    
                }
                
                $result_data_array=array("exam_id"=>$exam_id,"sid"=>$sid,"y1"=>$y1,"y2"=>$y2,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"cat"=>$cat,"cat_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                $result_data_array_update=array("class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"uat"=>$cat,"updated_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                
                // echo $result_status."-".$subject_failure_count."<br><br>";
                // var_dump($result_data_array_update)."<br><br>";
                
                $get_student_result_data=$this->NewExamModel->student_result($sid,$acedemic_session,$exam_id,$course_id,$exam_result_table);
                if($get_student_result_data){
                    $update_student_result_data=$this->NewExamModel->update_student_exam_data($sid,$exam_id,$course_id,$result_data_array_update,$exam_result_table);
                }else{
                    $add_exam_result=$this->NewExamModel->insert_data($result_data_array,$exam_result_table);
                }
            }
        }
        
        $rank_count=0;
        $get_course_result=$this->NewExamModel->get_class_section_result($exam_id,$acedemic_session,$class,$section,$exam_result_table);
        if($get_course_result){
            foreach($get_course_result as $result){
                $id=$result['id'];
                if($result['result_status'] == "Pass"){
                    $rank_count=$rank_count + 1;        
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $data_array_update=array("rank_in_class"=>$rank_count,"uat"=>$cat,"updated_by"=>$tid);
                
                    $update_hic=$this->NewExamModel->update_item_data($id,$data_array_update,$exam_result_table);
                }else{
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $data_array_update=array("rank_in_class"=>"","uat"=>$cat,"updated_by"=>$tid);
                
                    $update_hic=$this->NewExamModel->update_item_data($id,$data_array_update,$exam_result_table);
                }
            }
        }
        echo "success";
        
    }
    
    
    public function exam_list(){
        $data['success']=""; $data['error']="";
        
        if(isset($_POST['add_new_exam'])){
            $acedemic_session=$_POST['acedemic_session'];
            $y1=$_POST['y1'];
            $y2=$_POST['y2'];
            $status=$_POST['status'];
            $exam_title=$_POST['exam_title'];
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $table="exam_list";
            
            $data_array=array("exam_title"=>$exam_title,"status"=>1,"cat"=>$cat,"cat_by"=>$tid,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2);
            
            $get_exam_list_data=$this->NewExamModel->get_exam_list_data($exam_title,$table);
            
            if($get_exam_list_data){
                // foreach($get_exam_list_data as $exam_list_data){
                        
                // }
                
                $data['error']="Already Exists";
            }else{
                
                $add_new_exam_title=$this->NewExamModel->insert_data($data_array,$table);
                if($add_new_exam_title){
                    $data['success']="Exam added successfully !";    
                }else{
                    $data['error']="Error in adding exam !";
                }
                
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/admit-card/add-new-exam',$data);
        $this->load->view('erp/footer');
    }
    
    public function update_exam_information(){
        
        $data['success']="";
        
        $data['error']="";
        
        if(isset($_POST['update_exam_information'])){
            $userid=$this->session->userdata('tid');
            $exam_id=$_POST['exam_id'];
            $exam_title=$_POST['exam_title'];
            $acedemic_session=$_POST['acedemic_session'];
            $status=$_POST['status'];
            $academic_session_table="academic_session_details";
            $get_academic_session_info=$this->NewExamModel->get_item_data($acedemic_session,$academic_session_table);
            $y1="";
            $y2="";
            if($get_academic_session_info){
                foreach($get_academic_session_info as $academic_session_data){
                    $y1=$academic_session_data["y1"];
                    $y2=$academic_session_data["y2"]; 
                }
            }
            
            $data_array_update=array(
                    "exam_title"=>$exam_title,
                    "acedemic_session"=>$acedemic_session,
                    "status"=>$status,
                    "y1"=>$y1,
                    "y2"=>$y2,
                    "uat"=>$cat,
                    "upd_by"=>$userid
                );
            $table="exam_list";
            $update_exam_information=$this->NewExamModel->update_item_data($exam_id,$data_array_update,$table);
            if($update_exam_information){
                $data['success']="Exam information updated successfully !";
            }
        }
        

        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/admit-card/update-exam-information',$data);
        $this->load->view('erp/footer');
    }
    
    public function generate_class_section_admit_card(){
        $data['success']=""; $data['error']="";
        
        if(isset($_POST['generate_admit_card'])){
            $courses=$_POST['course'];
            // echo "<br><br><br><br>";
            // var_dump($courses);
            $count=count($courses);
            $exam_id=$_POST['exam_id'];
            
            
            $exam_title="";
            $exam_table="exam_list";
            
            $get_exam_data=$this->NewExamModel->get_item_data($exam_id,$exam_table);
            if($get_exam_data){
                foreach($get_exam_data as $exam_data){
                    $exam_title=$exam_data["exam_title"];
                }
            }
            
            $acedemic_session=$_POST['acedemic_session'];
            $y1=$_POST['y1'];
            $y2=$_POST['y2'];
            $issue_date=$_POST['issue_date'];
            $end_date=$_POST['end_date'];
            for($i=0; $i<$count; $i++){
                $course_id=$courses[$i];
                $courses_table="courses";
                $get_course_data=$this->NewExamModel->get_item_data($course_id,$courses_table);
                $course="";
                $subject_stream="";
                if($get_course_data){
                    foreach($get_course_data as $course_data){
                        $course=$course_data["course"];
                        $subject_stream=$course_data["subject_stream"];
                    }
                }
                
                $cat=date("Y-m-d H:i:s");
                $cat_by=$this->session->userdata('tid');
                
                $data_array=array("exam_id"=>$exam_id,"exam_title"=>$exam_title,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"issue_date"=>$issue_date,"end_date"=>$end_date,"course_id"=>$course_id,"class"=>$course,"subject_stream"=>$subject_stream,"cat"=>$cat,"cat_by"=>$cat_by);
                
                $data_array_update=array("issue_date"=>$issue_date,"end_date"=>$end_date,"y1"=>$y1,"y2"=>$y2);
                
                $admin_card_table="admin_card_list";
                
                $check_course_exam_data=$this->NewExamModel->get_course_exam_data($exam_id,$exam_title,$acedemic_session,$course_id,$admin_card_table);
                if($check_course_exam_data){
                    $update_exam_data=$this->NewExamModel->update_exam_data($exam_id,$acedemic_session,$course_id,$data_array_update,$admin_card_table);
                    if($update_exam_data){
                        $data['success']="Exam data updated successfuly.";
                    }else{
                        $data['error']="Error in updating exam data";
                    }
                }else{
                    $add_new_admit_card_data=$this->NewExamModel->insert_data($data_array,$admin_card_table);
                    
                    if($add_new_admit_card_data){
                        $data['success']="Exam Data Added Successfully";
                    }else{
                        $data['error']="Error in adding exam data.";
                    }
                }
                
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/admit-card/generate-class-section-admit-card',$data);
        $this->load->view('erp/exam/admit-card/admit-card-list');
        $this->load->view('erp/footer'); 
    }
    
    public function admit_cards(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/admit-card/exam-admin-card-list');
        $this->load->view('erp/footer'); 
    }
    
    public function course_admit_card($class,$section){
        $course=$class."-".$section;
        // $this->load->view('erp/header');
        // $this->load->view('erp/sidebar');
        // $this->load->view('erp/exam/admit-card/course-admit-card-list');
        // $this->load->view('erp/footer'); 
        
        $this->load->view('erp/exam/admit-card/course-admit-card-list');
        
        // $this->load->view('erp/exam/admit-card/course-admit-card-list-new');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function exam_wise_courses(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam/new/exam-wise-courses');
        $this->load->view('erp/footer');  
    }
    
    public function view_exam_result($class,$section,$exam_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/report-card/class-section-students-and-result');
        $this->load->view('erp/footer');   
    }
    
    public function exam_subjects_master(){
        $data['success']="";
        $data['error']="";
        if(isset($_POST['aad_new_subject'])){
            $class=$_POST['class'];
            $subject=$_POST['subject'];
            $status=$_POST['status'];
            $subject_order=$_POST['subject_order'];
            
            $userid=$this->session->userdata("tid");
            $cat=date("Y-m-d H:i:s");
             	 	 	 	 	 	
            $data_array=array(
                "class"=>$class,
                "subject"=>$subject,
                "status"=>$status,
                "subject_order"=>$subject_order,
                "created_at"=>$cat,
                "created_by"=>$userid,
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            
            $check_exam_subject=$this->NewExamModel->check_exam_subject($class,$subject);
            $table="exam_subject_master";
            if($check_exam_subject){
                $data['error']="Subject already exists !";
            }else{
                $add_new_subject=$this->NewExamModel->insert_data($data_array,$table);
                if($add_new_subject){
                    $data['success']="Subject added successfully !";
                }
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exams/exam-subjects-master',$data);
        $this->load->view('erp/footer');   
    }
    
}