<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ExamManagement extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('StudentModel');
        $this->load->model('ExamManagementModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('FeeModel');
        $this->load->model('SchoolModel');
        $this->load->model('NewExamModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
         $this->load->library('Pdf');
    }
    
    public function index(){
        $academic_session=$this->session->userdata("acedemic_session");
        $table="all_exams";
        $data['all_exams']=$this->ExamManagementModel->get_exams($academic_session,$table);
        // $data['all_exams']="";
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/exam-dashboard',$data);
        $this->load->view('erp/footer');
    }
    
    public function all_exams(){
        $academic_session=$this->session->userdata("acedemic_session");
        $table="all_exams";
        $data['all_exams']=$this->ExamManagementModel->get_exams($academic_session,$table);
        // $data['all_exams']="";
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/all-exams',$data);
        $this->load->view('erp/footer');
    }
    
    public function class_and_sections(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/assigned-class-and-sections');
        $this->load->view('erp/footer');
    }
    
    public function exam_subjects_master(){
        $class="";
        $exam_type="";
        $subject_type="";
        $status="";
        if(isset($_POST['search'])){
            $class=$_POST['class'];
            $exam_type=$_POST['exam_type'];
            $subject_type=$_POST['subject_type'];
            $status=$_POST['status'];
            
            $this->session->set_userdata("subject_master_class",$class);
            $this->session->set_userdata("subject_master_exam_type",$exam_type);
            $this->session->set_userdata("subject_master_subject_type",$subject_type);
            $this->session->set_userdata("subject_master_status",$status);
        }
        
        



            if($this->session->userdata("subject_master_class") !=""){
                $class=$this->session->userdata("subject_master_class");
            }
                
            if($this->session->userdata("subject_master_exam_type") !=""){
                $exam_type=$this->session->userdata("subject_master_exam_type");
            }
            
            if($this->session->userdata("subject_master_subject_type") !=""){
                $subject_type=$this->session->userdata("subject_master_subject_type");    
            }
            
            if($this->session->userdata("subject_master_status") !=""){
                $status=$this->session->userdata("subject_master_status");
            }
                
        
        
        $acedemic_session=$this->session->userdata("acedemic_session");
        $table="exam_subject_master_".$acedemic_session;
        $data['all_subjects']=$this->ExamManagementModel->get_subject_master_data($class,$exam_type,$subject_type,$status,$table);
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/exam-subjects-master',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_new_subject(){
        $data['success']="";
        $data['error']="";
        if(isset($_POST['aad_new_subject'])){
            $class=$_POST['class'];
            $subject=$_POST['subject'];
            $status=$_POST['status'];
            $subject_order=$_POST['subject_order'];
            
            $max_marks=$_POST['max_marks'];
            $exam_type=$_POST['exam_type'];
            $subject_type=$_POST['subject_type'];
            $academic_session=$_POST['academic_session'];
            
            
            $userid=$this->session->userdata("tid");
            $cat=date("Y-m-d H:i:s");
             	 	 	 	 	 	
            $data_array=array(
                "class"=>$class,
                "subject"=>$subject,
                "status"=>$status,
                "subject_order"=>$subject_order,
                "academic_session"=>$academic_session,
                "subject_type"=>$subject_type,
                "exam_type"=>$exam_type,
                "MM"=>$max_marks,
                "created_at"=>$cat,
                "created_by"=>$userid,
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            $table="exam_subject_master_".$academic_session;
            $check_exam_subject=$this->ExamManagementModel->check_exam_subject($class,$subject,$table);
            
            if($check_exam_subject){
                $data['error']="Subject already exists !";
            }else{
                $add_new_subject=$this->ExamManagementModel->insert_data($data_array,$table);
                if($add_new_subject){
                    $data['success']="Subject added successfully !";
                }
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/add-exam-subject',$data);
        $this->load->view('erp/footer');
    }
    
    public function update_subject_master(){
            $data['success']=""; $data['error']="";
        
        if(isset($_POST['update_subject_information'])){
            $class=$_POST['class'];
            $subject_id=$_POST['subject_id'];
            $subject=$_POST['subject'];
            $subject_order=$_POST['subject_order'];
            $status=$_POST['status'];
            $max_marks=$_POST['max_marks'];
            $exam_type=$_POST['exam_type'];
            $subject_type=$_POST['subject_type'];
            $academic_session=$_POST['academic_session'];
            
            $practical=$_POST['practical'];
            $theory=$_POST['theory'];
            
            $cat=date("Y-m-d H:i:s");
            $userid=$this->session->userdata("tid");
            
            $data_array_update=array(
                "class"=>$class,
                "subject"=>$subject,
                "status"=>$status,
                "subject_order"=>$subject_order,
                "academic_session"=>$academic_session,
                "subject_type"=>$subject_type,
                "exam_type"=>$exam_type,
                "MM"=>$max_marks,
                "practical"=>$practical,
                "theory"=>$theory,
                "created_at"=>$cat,
                "created_by"=>$userid,
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            $table="exam_subject_master_".$academic_session;
            $update_subject_info=$this->ExamManagementModel->update_item_data($subject_id,$data_array_update,$table);
            if($update_subject_info){
                $data['success']="Subject information updated successfully !";
            }else{
                $data['error']="Error while updating subject information !";
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/update-exam-subject',$data);
        $this->load->view('erp/footer');
    }
    
    public function exam_head_master(){
        $academic_session=$this->session->userdata("acedemic_session");
        $class="";
        $status="";
        $exam_id="";
        $freeze_status="";
        if(isset($_POST['search_exam_head_filter'])){
            $class=$_POST['class'];
            $status=$_POST['status'];
            $exam_id=$_POST['exam_id'];
            $freeze_status=$_POST['freeze_status'];
            
            $this->session->set_userdata("exam_head_filter_class",$class);
            $this->session->set_userdata("exam_head_filter_status",$status);
            $this->session->set_userdata("exam_head_filter_exam_id",$exam_id);
            $this->session->set_userdata("exam_head_filter_freeze_status",$freeze_status);
        }
        
        if(isset($_POST['clear_search_filter'])){
            $this->session->set_userdata("exam_head_filter_class",$class);
            $this->session->set_userdata("exam_head_filter_status",$status);
            $this->session->set_userdata("exam_head_filter_exam_id",$exam_id);
            $this->session->set_userdata("exam_head_filter_freeze_status",$freeze_status);
        }
        if($this->session->userdata("exam_head_filter_class") !=""){
            $class=$this->session->userdata("exam_head_filter_class");    
        }
        
        if($this->session->userdata("exam_head_filter_status") !=""){
            $status=$this->session->userdata("exam_head_filter_status");    
        }
        
        if($this->session->userdata("exam_head_filter_exam_id") !=""){
            $exam_id=$this->session->userdata("exam_head_filter_exam_id");    
        }
        
        if($this->session->userdata("exam_head_filter_freeze_status") !=""){
            $freeze_status=$this->session->userdata("exam_head_filter_freeze_status");
        }
        
        
        $table="exam_head_master_".$academic_session;
        
        $data['all_exam_heads']=$this->ExamManagementModel->get_exam_heads_with_filter($class,$status,$exam_id,$freeze_status,$academic_session,$table);
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/exam-head-master',$data);
        $this->load->view('erp/footer');
    }
    
    public function add_exam_head(){
        $data['success']="";    $data['error']="";
        if(isset($_POST['add_exam_head'])){
            $academic_session=$_POST['academic_session'];
            $class=$_POST['class'];
            $exam_head=$_POST['exam_head'];
            $exam_head_order=$_POST['exam_head_order'];
            $max_marks=$_POST['max_marks'];
            $status=$_POST['status'];
            $exam_id=$_POST['exam_id'];
            $freeze_status=$_POST['freeze_status'];
            
            $cat=date("Y-m-d H:i:s");
            $userid=$this->session->userdata("tid");
            $exam_mode="";
            $data_array=array(
                "exam_id"=>$exam_id,
                "academic_session"=>$academic_session,
                "class"=>$class,
                "exam_head"=>$exam_head,
                "head_order"=>$exam_head_order,
                "mm"=>$max_marks,
                "freeze"=>$freeze_status,
                "status"=>$status,
                "created_at"=>$cat,
                "created_by"=>$userid,
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            $table="exam_head_master_".$academic_session;
            $check_exam_head=$this->ExamManagementModel->check_exam_head($exam_id,$exam_head,$class,$table);
            if($check_exam_head){
                $data['error']="Exam head already exists !";
            }else{
                $add_new_exam_head=$this->ExamManagementModel->insert_data($data_array,$table);
                if($add_new_exam_head){
                    $data['success']="Exam head added successfully !";
                }
            }
        }
        //  	 	
        
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/add-exam-head',$data);
        $this->load->view('erp/footer');
    }
    
    
   
    
    public function update_exam_head(){
        $data['success']="";    $data['error']="";
        if(isset($_POST['update_exam_head'])){
            
            $exam_head_id=$_POST['exam_head_id'];
            
            $class=$_POST['class'];
            $academic_session=$_POST['academic_session'];
            $exam_head=$_POST['exam_head'];
            $exam_head_order=$_POST['exam_head_order'];
            $max_marks=$_POST['max_marks'];
            $status=$_POST['status'];
            $exam_id=$_POST['exam_id'];
            
            $title=$_POST['title'];
            
            $freeze_status=$_POST['freeze_status'];
            $cat=date("Y-m-d H:i:s");
            $userid=$this->session->userdata("tid");
            
            $data_array_update=array(
                "exam_id"=>$exam_id,
                "academic_session"=>$academic_session,
                "class"=>$class,
                "exam_head"=>$exam_head,
                "head_order"=>$exam_head_order,
                "mm"=>$max_marks,
                "freeze"=>$freeze_status,
                "status"=>$status,
                "title"=>$title,
                "updated_at"=>$cat,
                "updated_by"=>$userid
            );
            $table="exam_head_master_".$academic_session;
            $update_exam_head_information=$this->ExamManagementModel->update_item_data($exam_head_id,$data_array_update,$table);
            if($update_exam_head_information){
                $data['success']="Exam head information updated successfully !";
            }else{
                $data['error']="Error while updating exam head information !";
            }
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/update-exam-head',$data);
        $this->load->view('erp/footer');
    }
    
    
     public function add_new_exam(){
        $data['success']="";    $data['error']="";
        if(isset($_POST['add_new_exam'])){
            $academic_session=$_POST['academic_session'];
            $exam_title=$_POST['exam_title'];
            $status=$_POST['status'];
            $cat=date("Y-m-d H:i:s");
            $userid=$this->session->userdata("tid");
            $table="all_exams";
            $data_array=array("acedemic_session"=>$academic_session,"exam_title"=>$exam_title,"status"=>$status,"created_at"=>$cat,"created_by"=>$userid,"updated_at"=>$cat,"updated_by"=>$userid);
            
            $check_exam_data=$this->ExamManagementModel->check_exam_exists($academic_session,$exam_title,$table);
            if($check_exam_data){
                $data['error']="Exam already exists !";
            }else{
                $add_new_exam=$this->ExamManagementModel->insert_data($data_array,$table);
                if($add_new_exam){
                    $data['success']="Exam added successfully !";
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/add-new-exam',$data);
        $this->load->view('erp/footer');
    }
    
    public function exam_schedule(){
        $data['abc']="";
        if(isset($_POST['update_exam_schedule'])){
            $exam_head=$_POST['exam_head'];
            $exam_data=$_POST['exam'];
            $academic_session=$_POST['academic_session'];
            $exam_id=$_POST['exam_id'];
            $class=$_POST['class'];
            
            
            $subject_id_s=$exam_data['subject_id'];
            $date_s=$exam_data['date'];
            $start_time_s=$exam_data['start_time'];
            $end_time_s=$exam_data['end_time'];
            
            $cat=date("Y-m-d H:i:s");
            
            
            $sch_table="exam_schedule";
            // echo "<br><br><br><br>".json_encode($exam_data);
            // echo $count=count($exam_data);
            // echo "<br><br>";
            // var_dump($exam_data);
            // echo "<br><br>";
            // var_dump($subject_id_s);
            // echo "<br><br>";
            
            foreach($subject_id_s as $key=>$val){
                $subject_id=$key;
                $date=$date_s[$key];
                $start_time=$start_time_s[$key];
                $end_time=$end_time_s[$key];
                
                // exam_date
                // status
                $userid=$this->session->userdata("tid");
                $data_array=array(
                    "academic_session"=>$academic_session,
                    "exam_id"=>$exam_id,
                    "exam_head"=>$exam_head,
                    "subject_id"=>$subject_id,
                    "exam_date"=>$date,
                    "exam_start_time"=>$start_time,
                    "exam_end_time"=>$end_time,
                    "class"=>$class,
                    "created_at"=>$cat,
                    "created_by"=>$userid,
                    "updated_at"=>$cat,
                    "updated_by"=>$userid
                );
                
                
                $data_array_update=array(
                    "exam_date"=>$date,
                    "exam_start_time"=>$start_time,
                    "exam_end_time"=>$end_time,
                    "updated_at"=>$cat,
                    "updated_by"=>$userid
                );
                if($date !=""){
                    $check_schedule_exists=$this->ExamManagementModel->check_schedule_exists($subject_id,$exam_head,$academic_session,$class,$sch_table);
                    if($check_schedule_exists){
                        // $data['error']="Exam schedule alrea";
                        $update_exam_schedule=$this->ExamManagementModel->update_exam_schedule($academic_session,$exam_head,$subject_id,$data_array_update,$sch_table);
                        if($update_exam_schedule){
                            $data['success']="Exam schedule updated successfully !";
                        }
                    }else{
                        $add_schedule=$this->ExamManagementModel->insert_data($data_array,$sch_table);
                        if($add_schedule){
                            $data['success']="Exam schedule added successfully !";
                        }
                    }
                }
                
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/exam-schedule',$data);
        $this->load->view('erp/footer');
    }
    
    public function exam_schedule_pdf(){
        
    }
    
    public function course_admit_card($ehid,$class,$section){
        $course=$class."-".$section;
        // $this->load->view('erp/header');
        // $this->load->view('erp/sidebar');
        // $this->load->view('erp/exam/admit-card/course-admit-card-list');
        // $this->load->view('erp/footer'); 
        
        // $this->load->view('erp/exam/admit-card/course-admit-card-list');
        
        // $this->load->view('erp/exam/admit-card/course-admit-card-list-new');
        
        $this->load->view('erp/exam-management/exam-schedule-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function course_admit_card_old($ehid,$class,$section){
          $this->load->view('erp/exam-management/exam-schedule-pdf-old');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course", array("Attachment"=>0));
    }
    
    public function class_structure(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/all-class-and-section-list');
        $this->load->view('erp/footer');
    }
    
    public function class_section_students(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/class-section-students');
        $this->load->view('erp/footer');
    }
    
    public function student_subjects(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/student-subjects');
        $this->load->view('erp/footer');
    }
    
    
    public function allot_subjects(){
        $data['success']=""; $data['error']="";
        if(isset($_POST['allot_subjects'])){
            $sid=$_POST['sid'];
            $course_id=$_POST['course_id'];
            $acedemic_session=$_POST['acedemic_session'];
            $class=$_POST['class'];
            $section=$_POST['section'];
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $added_subject_count=0;
            $removed_subject_count=0;
            if(!empty($_POST['subject_item'])){ 
            $allot_subjects_list=$_POST['subject_item'];
            
            
            
            //   echo "<br><br><br><br><br><br>";
            
            // $subjects_table="exam_subjects_".$acedemic_session;
            $exam_subjects_table='exam_subject_master_'.$acedemic_session;
            $course_subject_list=$this->ExamManagementModel->get_class_active_subjects($class,$exam_subjects_table);
            
            $student_subjects_table="student_subjects_".$acedemic_session;
            foreach($course_subject_list as $list){
                $subject_id=$list['id'];
                $sub_count=0;
                foreach($allot_subjects_list as $subjectid){
                    // echo $data."<br>";    
                    $data_array=array("sid"=>$sid,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"academic_session"=>$acedemic_session,"subject_id"=>$subjectid,"status"=>1,"created_by"=>$tid,"created_at"=>$cat,"updated_at"=>$cat,"updated_by"=>$tid);
                    
                    
                    $check_student_subject_exist=$this->ExamManagementModel->student_subject_info($sid,$acedemic_session,$subject_id,$student_subjects_table);
                    if($subject_id == $subjectid){
                        $sub_count=$sub_count + 1;    
                        // echo "<br>".$subjectid."-".$list['subject'];
                        if($check_student_subject_exist){
                            // echo "Subject already added for student.";
                        }else{
                            $add_subject=$this->ExamManagementModel->insert_data($data_array,$student_subjects_table);
                            if($add_subject){
                                // echo "Subject added successfully.";
                                $added_subject_count=$added_subject_count + 1;
                                
                            }else{
                                // echo "Error in adding subject.";
                            }
                        }
                    }
                }
                
                if($sub_count == 1){
                    
                }else{
                    // $check_student_subject_exist=$this->ExamManagementModel->student_subject_info($sid,$course_id,$acedemic_session,$subject_id);
                    // if($check_student_subject_exist){
                        $remove_subject=$this->ExamManagementModel->delete_student_subject($sid,$subject_id,$class,$acedemic_session,$student_subjects_table);
                        if($remove_subject){
                            // echo "deleted";
                            $removed_subject_count=$removed_subject_count + 1;
                        }
                    // }
                }
            }
            }
            $data['success']=$added_subject_count." subjects added successfully ! ";
            
            $data['success'].=$removed_subject_count." subjects removed ! ";
            
            
            // redirect(base_url()."ExamManagement/allot_subjects/".$sid);
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/allot-subjects',$data);
        $this->load->view('erp/footer');
    }
    
    
    
    public function exam_log($sid,$exam_id){
        
        $data['success']=""; $data['error']="";
        if(isset($_POST['allot_subjects'])){
            $sid=$_POST['sid'];
            $course_id=$_POST['course_id'];
            $acedemic_session=$_POST['acedemic_session'];
            $class=$_POST['class'];
            $section=$_POST['section'];
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
            $added_subject_count=0;
            $removed_subject_count=0;
            if(!empty($_POST['subject_item'])){ 
            $allot_subjects_list=$_POST['subject_item'];
            
            
            
            //   echo "<br><br><br><br><br><br>";
            
            // $subjects_table="exam_subjects_".$acedemic_session;
            $exam_subjects_table='exam_subject_master_'.$acedemic_session;
            $course_subject_list=$this->ExamManagementModel->get_class_active_subjects($class,$exam_subjects_table);
            
            $student_subjects_table="student_subjects_".$acedemic_session;
            foreach($course_subject_list as $list){
                $subject_id=$list['id'];
                $sub_count=0;
                foreach($allot_subjects_list as $subjectid){
                    // echo $data."<br>";    
                    $data_array=array("sid"=>$sid,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"academic_session"=>$acedemic_session,"subject_id"=>$subjectid,"status"=>1,"created_by"=>$tid,"created_at"=>$cat,"updated_at"=>$cat,"updated_by"=>$tid);
                    
                    
                    $check_student_subject_exist=$this->ExamManagementModel->student_subject_info($sid,$acedemic_session,$subject_id,$student_subjects_table);
                    if($subject_id == $subjectid){
                        $sub_count=$sub_count + 1;    
                        // echo "<br>".$subjectid."-".$list['subject'];
                        if($check_student_subject_exist){
                            // echo "Subject already added for student.";
                        }else{
                            $add_subject=$this->ExamManagementModel->insert_data($data_array,$student_subjects_table);
                            if($add_subject){
                                // echo "Subject added successfully.";
                                $added_subject_count=$added_subject_count + 1;
                                
                            }else{
                                // echo "Error in adding subject.";
                            }
                        }
                    }
                }
                
                if($sub_count == 1){
                    
                }else{
                    // $check_student_subject_exist=$this->ExamManagementModel->student_subject_info($sid,$course_id,$acedemic_session,$subject_id);
                    // if($check_student_subject_exist){
                        $remove_subject=$this->ExamManagementModel->delete_student_subject($sid,$subject_id,$class,$acedemic_session,$student_subjects_table);
                        if($remove_subject){
                            // echo "deleted";
                            $removed_subject_count=$removed_subject_count + 1;
                        }
                    // }
                }
            }
            }
            $data['success']=$added_subject_count." subjects added successfully ! ";
            
            $data['success'].=$removed_subject_count." subjects removed ! ";
            
            
            // redirect(base_url()."ExamManagement/allot_subjects/".$sid);
        }
        // Exam Attendance Data
        
        $data_1['success']="";
        $data_1['error']="";
        if(isset($_POST['add_exam_attendance_log'])){
            $sid=$_POST['sid'];
            $course_id=$_POST['course_id'];
            $class=$_POST['class'];
            $acedemic_session=$this->session->userdata('acedemic_session');
            $subject_table='exam_subject_master_'.$acedemic_session.'';
            // $all_active_subjects=$this->NewExamModel->get_course_active_subjects($course_id,$subject_table);
            
            $all_active_subjects=$this->ExamManagementModel->get_course_active_subjects($class,$subject_table);
            if($all_active_subjects){
                foreach($all_active_subjects as $subjects){
                    $exam_type=$subjects['exam_type'];
                    // $sub_count=$sub_count + 1;
                    $subject_id=$subjects['id'];
                    $exam_head_table='exam_head_master_'.$acedemic_session.'';
                    // $all_exam_heads=$this->NewExamModel->get_course_exam_heads($course_id,$exam_head_table);
                    
                    // $all_exam_heads=$this->ExamManagementModel->get_course_exam_heads($class,$exam_head_table);
                    
                    $all_exam_heads=$this->ExamManagementModel->get_course_exam_wise_heads($class,$exam_id,$exam_head_table);
                    if($all_exam_heads){
                        foreach($all_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            $elog_name=  "s_".$subject_id."_h_".$ehid;
                            $attendance_log=$_POST[$elog_name];
                            
                            
                            $cat=date('Y-m-d H:i:s');
                            $tid=$this->session->userdata('tid');
                            
                            $data_array=array();
                            $data_array_update=array();
                            
                            $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"attendance"=>$attendance_log,"cat"=>$cat,"inserted_by"=>$tid);
                            $data_array_update=array("attendance"=>$attendance_log,"uat"=>$cat,"updated_by"=>$tid);
                            $elog_table='exam_log_'.$acedemic_session.'';
                            $check_log_exist=$this->NewExamModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                            if($check_log_exist){
                                $update_log_data=$this->NewExamModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                $data_1['success']="Attendance Log Updated Successfully";
                                // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                            }else{
                                $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                $data_1['success']="Attendance Log Added Successfully";
                            }
                            
                        }
                    }
                }
            }
        }
        
        
        // Update Exam Log
        
        $data_2['success']=''; $data_2['error']='';
        if(isset($_POST['add_exam_log'])){
            $course_id=$_POST['course_id'];
            $sid=$_POST['sid'];
            $class=$_POST['class'];
            $acedemic_session=$this->session->userdata('acedemic_session');
            $subject_table='exam_subject_master_'.$acedemic_session.'';
            $all_active_subjects=$this->ExamManagementModel->get_course_active_subjects($class,$subject_table);
            if($all_active_subjects){
                foreach($all_active_subjects as $subjects){
                    $exam_type=$subjects['exam_type'];
                    // $sub_count=$sub_count + 1;
                    $subject_id=$subjects['id'];
                    $exam_head_table='exam_head_master_'.$acedemic_session.'';
                    // $all_exam_heads=$this->ExamManagementModel->get_course_exam_heads($class,$exam_head_table);
                    
                    $all_exam_heads=$this->ExamManagementModel->get_course_exam_wise_heads($class,$exam_id,$exam_head_table);
                    if($all_exam_heads){
                        foreach($all_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            $elog_name=  "s_".$subject_id."_h_".$ehid;
                            $exam_log=$_POST[$elog_name];
                            // $update_elog_data=$this->
                            
                            $cat=date('Y-m-d H:i:s');
                            $tid=$this->session->userdata('tid');
                            
                            $data_array=array();
                            $data_array_update=array();
                            if($exam_type == 'Marks'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"obtained_marks"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("obtained_marks"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->ExamManagementModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->ExamManagementModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                    }
                            
                            }else if($exam_type == 'Grade'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"grade"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("grade"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->ExamManagementModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->ExamManagementModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                        
                                        
                                    }
                            }
                            
                            
                            
                        }
                    }
                }
            }
            $data_2['success']='Updated Successfully';
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/allot-subjects',$data);
        // $this->load->view('erp/exam-management/exam-log-sheet');
        $this->load->view('erp/exam-management/update-exam-log-sheet',$data_2);
        $this->load->view('erp/exam-management/exam-attendance-log',$data_1);
        $this->load->view('erp/footer');
    }
    
    public function update_exam_log(){
        $data_2['success']=''; $data_2['error']='';
        if(isset($_POST['add_exam_log'])){
            $course_id=$_POST['course_id'];
            $sid=$_POST['sid'];
            $class=$_POST['class'];
            $acedemic_session=$this->session->userdata('acedemic_session');
            $subject_table='exam_subject_master_'.$acedemic_session.'';
            $all_active_subjects=$this->ExamManagementModel->get_course_active_subjects($class,$subject_table);
            if($all_active_subjects){
                foreach($all_active_subjects as $subjects){
                    $exam_type=$subjects['exam_type'];
                    // $sub_count=$sub_count + 1;
                    $subject_id=$subjects['id'];
                    $exam_head_table='exam_head_master_'.$acedemic_session.'';
                    // $all_exam_heads=$this->ExamManagementModel->get_course_exam_heads($class,$exam_head_table);
                    
                    $all_exam_heads=$this->ExamManagementModel->get_course_exam_wise_heads($class,$exam_id,$exam_head_table);
                    if($all_exam_heads){
                        foreach($all_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            $elog_name=  "s_".$subject_id."_h_".$ehid;
                            $exam_log=$_POST[$elog_name];
                            // $update_elog_data=$this->
                            
                            $cat=date('Y-m-d H:i:s');
                            $tid=$this->session->userdata('tid');
                            
                            $data_array=array();
                            $data_array_update=array();
                            if($exam_type == 'Marks'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"obtained_marks"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("obtained_marks"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->ExamManagementModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->ExamManagementModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                    }
                            
                            }else if($exam_type == 'Grade'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"grade"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("grade"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->ExamManagementModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->ExamManagementModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                        
                                        
                                    }
                            }
                            
                            
                            
                        }
                    }
                }
            }
            $data_2['success']='Updated Successfully';
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/update-exam-log-sheet',$data_2);
        
        
        $this->load->view('erp/footer');
    }
    
    
    public function working_days(){
        $data['success']=''; $data['error']='';
        if(isset($_POST['add_working_days'])){
            $exam=$_POST['exam'];
            $course=$_POST['course'];
            $working_days=$_POST['working_days'];
            $userid=$this->session->userdata('tid');
            $academic_session=$_POST['academic_session'];
            $cat=date('Y-m-d H:i:s');
            $table='exam_course_data';
            $data_array=array("exam_id"=>$exam,"course_id"=>$course,"working_days"=>$working_days,"cat"=>$cat,"cat_by"=>$userid,"academic_session"=>$academic_session);
            $data_array_update=array("exam_id"=>$exam,"course_id"=>$course,"working_days"=>$working_days,"uat"=>$cat,"upd_by"=>$userid,"academic_session"=>$academic_session);
            $check_data_exist=$this->NewExamModel->check_course_exam_data($exam,$course,$table);
            if($check_data_exist){
                $update_exam_data=$this->NewExamModel->update_course_exam_data($exam,$course,$data_array_update,$table);
                if($update_exam_data){
                    $data['success']='Updated Successfully';
                }else{
                    $data['error']='Error in updating exam course information';
                }
            }else{
                $add_exam_course_data=$this->NewExamModel->insert_data($data_array,$table);
                if($add_exam_course_data){
                    $data['success']='Added Successfully !!';
                }else{
                    $data['error']='Error in adding course exam information !!';
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/add-working-days',$data);
        $this->load->view('erp/footer');
    }
    
    
    
    public function student_exam_data(){
        
        // sid:sid,remark:remark,total_working_days:total_working_days,attendance:attendance,exam_id:exam_id,course_id:course_id,course:course,roll_no:roll_no
        $sid=$_POST['sid'];
        $remark=$_POST['remark'];
        $total_working_days=$_POST['total_working_days'];
        $attendance=$_POST['attendance'];
        $exam_id=$_POST['exam_id'];
        $course_id=$_POST['course_id'];
        $course=$_POST['course'];
        
        $roll_no=$_POST['roll_no'];
        $height=$_POST['height'];
        $weight=$_POST['weight'];
        
        $cat=date('Y-m-d H:i:s');
        $attendance_percentage=0;
        if($total_working_days == 0){
            $attendance_percentage = 0;
        }else{
            $attendance_percentage=$attendance*100/$total_working_days;    
        }
        $attendance_percentage=round($attendance_percentage,2);
        $y1=$this->session->userdata('y1');
        $y2=$this->session->userdata('y2');
        $userid=$this->session->userdata('tid');
        $acedemic_session=$this->session->userdata('acedemic_session');
        
        
        
        $student_course_data_array=array("roll_no"=>$roll_no,"height"=>$height,"weight"=>$weight);
        $student_course_data_table="student_courses_data";
        
        $update_student_course_data=$this->NewExamModel->update_student_course_data_1($sid,$acedemic_session,$course_id,$student_course_data_array,$student_course_data_table);
        
        // $data_array=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"course_id"=>$course_id,"sid"=>$sid,"working_days"=>$total_working_days,"attendance"=>$attendance_percentage,"attendance_days"=>$attendance,"class"=>$course,"cat"=>$cat,"cat_by"=>$userid,"remark"=>$remark,"roll_no"=>$roll_no);
        
        // $data_array_update=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"course_id"=>$course_id,"sid"=>$sid,"working_days"=>$total_working_days,"attendance"=>$attendance_percentage,"attendance_days"=>$attendance,"class"=>$course,"uat"=>$cat,"updated_by"=>$userid,"remark"=>$remark,"roll_no"=>$roll_no);
        
        $data_array=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"course_id"=>$course_id,"sid"=>$sid,"working_days"=>$total_working_days,"attendance"=>$attendance_percentage,"attendance_days"=>$attendance,"class"=>$course,"remark"=>$remark,"roll_no"=>$roll_no,"height"=>$height,"weight"=>$weight,"cat"=>$cat,"cat_by"=>$userid,);
        
        $data_array_update=array("exam_id"=>$exam_id,"acedemic_session"=>$acedemic_session,"y1"=>$y1,"y2"=>$y2,"course_id"=>$course_id,"sid"=>$sid,"working_days"=>$total_working_days,"attendance"=>$attendance_percentage,"attendance_days"=>$attendance,"class"=>$course,"remark"=>$remark,"roll_no"=>$roll_no,"height"=>$height,"weight"=>$weight,"uat"=>$cat,"updated_by"=>$userid);        

        $table='exam_result';
        
        $check_student_data_exist=$this->NewExamModel->get_student_exam_data($sid,$exam_id,$course_id,$table);
        if($check_student_data_exist){
            $update_student_exam_data=$this->NewExamModel->update_student_exam_data($sid,$exam_id,$course_id,$data_array_update,$table);
            if($update_student_exam_data){
                echo "Updated Successfully";
            }else{ echo "Error in updating data"; }
        }else{
            $add_exam_course_data=$this->NewExamModel->insert_data($data_array,$table);
            if($add_exam_course_data){
                echo 'Added Successfully !!';
            }else{
                echo 'Error in adding course exam information !!';
            }   
        }
        
        
    }
    
    
    public function remarks(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/remark-list');
        $this->load->view('erp/footer');
    }
    
    public function add_remark(){
        $data['success']=''; $data['error']='';
        $data['id']="";
        if(isset($_POST['edit'])){
            $data['id']=$_POST['edit'];
        }
        
        if(isset($_POST['add_remark'])){
            $remark_id=$_POST['remark_id'];
            $remark_category=$_POST['remark_category'];
            $remark=$_POST['remark'];
            $cat=date('Y-m-d H:i:s');
            $table='exam_quote_list';
            $data_array=array("quote_type"=>$remark_category,"quote"=>$remark,"cat"=>$cat,"status"=>1);
            $tid=$this->session->userdata('tid');
            $data_array_update=array("quote_type"=>$remark_category,"quote"=>$remark,"uat"=>$cat,"status"=>1,"upd_by"=>$tid);
            
            $get_remark_data=$this->NewExamModel->get_item_data($remark_id,$table);
            if($get_remark_data){
                $check_remark_exist=$this->NewExamModel->check_remark_exist($remark,$table);
                if($check_remark_exist){
                    $data['error']='Remark Already Exist';
                }else{
                    $add_remark=$this->NewExamModel->update_item_data($remark_id,$data_array_update,$table);
                    if($add_remark){
                        $data['success']='Remark Updated Successfully';
                    }else{
                        $data['error']='';
                    }    
                }  
            }else{
                $check_remark_exist=$this->NewExamModel->check_remark_exist($remark,$table);
                if($check_remark_exist){
                    $data['error']='Remark Already Exist';
                }else{
                    $add_remark=$this->NewExamModel->insert_data($data_array,$table);
                    if($add_remark){
                        $data['success']='Remark Added Successfully';
                    }else{
                        $data['error']='';
                    }    
                }        
            }
            
            
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/add-remark',$data);
        $this->load->view('erp/footer');
    }
    
    // public function generate_exam_result(){
        
    //     $class=$_POST['exam_class'];
    //     $section=$_POST['section'];
    //     $exam_id=$_POST['exam_id'];
    //     $acedemic_session=$_POST['acedemic_session'];
        
    //     $exam_result_table="exam_result";
    //     $all_students=$this->ExamManagementModel->get_students_ac_session_by_course_and_class($acedemic_session,$class,$section);
        
    //     if($all_students){
    //         foreach($all_students as $students){
    //             $student_hy_total=0;
    //             $result_mm=0;
                
    //             $course_id=$students['course_id'];
    //             $sid=$students['id'];
    //             $student_subjects_table="student_subjects_".$acedemic_session;
    //             $get_student_subjects=$this->ExamManagementModel->get_student_subjects($sid,$course_id,$acedemic_session,$student_subjects_table);
                
                
                
                
    //             $subjects_table="exam_subject_master_".$acedemic_session;
    //             // $get_course_subjects=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
                
    //             $get_course_subjects=$this->ExamManagementModel->get_course_active_subjects($class,$subjects_table);
                
    //             $exam_log_table="exam_log_".$acedemic_session;
    //             $get_student_exam_log_data=$this->ExamManagementModel->students_exam_log($sid,$acedemic_session,$exam_log_table);
                
    //             $exam_head_table='exam_head_master_'.$acedemic_session;
    //             $get_exam_heads=$this->ExamManagementModel->get_course_exam_heads($class,$exam_head_table);
    //             // $exam_heads_table="exam_head_master_".$acedemic_session;
    //             // $get_exam_heads=$this->NewExamModel->get_exam_heads($exam_heads_table);
    //             $subject_failure_count=0;
    //             foreach($get_course_subjects as $course_subjects){
                    
    //                 $subject_id=$course_subjects['id'];
    //                 $subject=$course_subjects["subject"];
    //                 $subject_mm=$course_subjects['MM'];
    //                 $subject_type=$course_subjects['subject_type'];
    //                 $exam_type=$course_subjects['exam_type'];
    //                 $subject_marks_obtained=0;
                    
    //                 if($exam_type == "Marks" && $subject_type == "Main Subject"){
                        
    //                     $student_subject=0;
    //                     if($get_student_subjects){
    //                         foreach($get_student_subjects as $subjectss){
    //                             if($subjectss['subject_id'] == $subject_id){
    //                                 $student_subject=$student_subject + 1;    
    //                             }
                                            
    //                         }
    //                     }
                        
                        
    //                         $result_mm=$result_mm + $subject_mm;
    //                     foreach($get_exam_heads as $exam_heads){
    //                         $ehid=$exam_heads['id'];
    //                         if($get_student_exam_log_data){
    //                             foreach($get_student_exam_log_data as $exam_log){
    //                                 if($ehid == $exam_log['exam_head'] && $subject_id == $exam_log['subject_id']){
    //                                     $subject_marks_obtained =$subject_marks_obtained + $exam_log['obtained_marks'];
    //                             }else{
                                    
    //                             }
    //                         }
    //                     }
    //                 }
    //                 $cat=date('Y-m-d H:i:s');
    //                 $tid=$this->session->userdata('tid');
    //                 $student_hy_total=$student_hy_total + $subject_marks_obtained;
    //                 $subject_percentage=($subject_marks_obtained/$subject_mm)* 100;
    //                 $sp1=round($subject_percentage,2);
    //                 $p_p=33;
    //                 if($sp1 < $p_p){
    //                     // echo $subject_percentage."<br>";
    //                     $subject_failure_count=$subject_failure_count + 1;
    //                     // echo $sp1."<br>";
    //                 }
                    

                  
    //                 $data_array_update=array("subject_mm"=>$subject_mm,"hy_total_marks"=>$subject_marks_obtained,"updated_at"=>$cat,"updated_by"=>$tid,"class"=>$class,"section"=>$section);
                    
    //                 $data_array=array("sid"=>$sid,"academic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"hy_total_marks"=>$subject_marks_obtained,"subject_mm"=>$subject_mm,"created_at"=>$cat,"created_by"=>$tid);
                    
                    
    //                     if($student_subject >= 1){
    //                         $update_subject_data=$this->ExamManagementModel->update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update);
                    
    //                     }else{
    //                         // $add_subject_data=$this->NewExamModel->insert_data($data_array,$student_subjects_table);
    //                     }
    //                 }
    //             }
                
    //             $cat=date('Y-m-d H:i:s');
    //             $tid=$this->session->userdata('tid');
    //             $percentage1=0;
    //             if($result_mm !=0){
    //                 $percentage1=($student_hy_total * 100)/$result_mm; 
    //             }
                
    //             // $percentage=number_format((float)$percentage1, 2, '.', '');
    //             $percentage=round($percentage1, 2);
                
                
    //             $y1=$this->session->userdata("y1");
    //             $y2=$this->session->userdata("y2");
    //             $result_status="";
    //             if($subject_failure_count == 0){
    //                     $result_status="Pass";
    //             }else{
    //                 $result_status="Fail";    
    //             }
                
    //             $result_data_array=array("exam_id"=>$exam_id,"sid"=>$sid,"y1"=>$y1,"y2"=>$y2,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"cat"=>$cat,"cat_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
    //             $result_data_array_update=array("class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"uat"=>$cat,"updated_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                
                
    //             $get_student_result_data=$this->ExamManagementModel->student_result($sid,$acedemic_session,$exam_id,$course_id,$exam_result_table);
    //             if($get_student_result_data){
    //                 $update_student_result_data=$this->ExamManagementModel->update_student_exam_data($sid,$exam_id,$course_id,$result_data_array_update,$exam_result_table);
    //             }else{
    //                 $add_exam_result=$this->ExamManagementModel->insert_data($result_data_array,$exam_result_table);
    //             }
    //         }
    //     }
        
    //     $rank_count=0;
    //     $get_course_result=$this->ExamManagementModel->get_class_section_result($exam_id,$acedemic_session,$class,$section,$exam_result_table);
    //     if($get_course_result){
    //         foreach($get_course_result as $result){
    //             $id=$result['id'];
    //             if($result['result_status'] == "Pass"){
    //                 $rank_count=$rank_count + 1;        
    //                 $cat=date("Y-m-d H:i:s");
    //                 $tid=$this->session->userdata('tid');
    //                 $data_array_update=array("rank_in_class"=>$rank_count,"uat"=>$cat,"updated_by"=>$tid);
                
    //                 $update_hic=$this->ExamManagementModel->update_item_data($id,$data_array_update,$exam_result_table);
    //             }else{
    //                 $cat=date("Y-m-d H:i:s");
    //                 $tid=$this->session->userdata('tid');
    //                 $data_array_update=array("rank_in_class"=>"","uat"=>$cat,"updated_by"=>$tid);
                
    //                 $update_hic=$this->ExamManagementModel->update_item_data($id,$data_array_update,$exam_result_table);
    //             }
    //         }
    //     }
    //     echo "success";
        
    // }
    
    public function generate_exam_result(){
        
        $class=$_POST['exam_class'];
        $section=$_POST['section'];
        $exam_id=$_POST['exam_id'];
        $acedemic_session=$_POST['acedemic_session'];
        
        $exam_result_table="exam_result";
        $all_students=$this->ExamManagementModel->get_students_ac_session_by_course_and_class($acedemic_session,$class,$section);
        
        if($all_students){
            foreach($all_students as $students){
                $student_hy_total=0;
                $result_mm=0;
                
                $course_id=$students['course_id'];
                $sid=$students['id'];
                $student_subjects_table="student_subjects_".$acedemic_session;
                $get_student_subjects=$this->ExamManagementModel->get_student_subjects($sid,$course_id,$acedemic_session,$student_subjects_table);
                
                
                
                
                $subjects_table="exam_subject_master_".$acedemic_session;
                // $get_course_subjects=$this->NewExamModel->get_course_subjects($course_id,$subjects_table);
                
                $get_course_subjects=$this->ExamManagementModel->get_course_active_subjects($class,$subjects_table);
                
                $exam_log_table="exam_log_".$acedemic_session;
                $get_student_exam_log_data=$this->ExamManagementModel->students_exam_log($sid,$acedemic_session,$exam_log_table);
                
                $exam_head_table='exam_head_master_'.$acedemic_session;
                // $get_exam_heads=$this->ExamManagementModel->get_course_exam_heads($class,$exam_head_table);
                
                $get_exam_heads=$this->ExamManagementModel->get_course_exam_wise_heads($class,$exam_id,$exam_head_table);
                // $exam_heads_table="exam_head_master_".$acedemic_session;
                // $get_exam_heads=$this->NewExamModel->get_exam_heads($exam_heads_table);
                $subject_failure_count=0;
                foreach($get_course_subjects as $course_subjects){
                    
                    $subject_id=$course_subjects['id'];
                    $subject=$course_subjects["subject"];
                    $subject_mm=$course_subjects['MM'];
                    $subject_type=$course_subjects['subject_type'];
                    $exam_type=$course_subjects['exam_type'];
                    $subject_marks_obtained=0;
                    $student_subject=0;
                        if($get_student_subjects){
                            foreach($get_student_subjects as $subjectss){
                                if($subjectss['subject_id'] == $subject_id){
                                    $student_subject=$student_subject + 1;    
                                }
                                            
                            }
                        }
                        
                        
                    if($exam_type == "Marks" && $subject_type == "Main Subject" && $student_subject == 1){
                        
                        
                        
                        // if($student_subject >= 1){
                            
                        // }
                        $result_mm=$result_mm + $subject_mm;    
                        foreach($get_exam_heads as $exam_heads){
                            $ehid=$exam_heads['id'];
                            if($get_student_exam_log_data){
                                foreach($get_student_exam_log_data as $exam_log){
                                    if($ehid == $exam_log['exam_head'] && $subject_id == $exam_log['subject_id']){
                                        $subject_marks_obtained =$subject_marks_obtained + $exam_log['obtained_marks'];
                                    }else{
                                    
                                    }
                                }
                            }
                        }
                        $cat=date('Y-m-d H:i:s');
                        $tid=$this->session->userdata('tid');
                        $student_hy_total=$student_hy_total + $subject_marks_obtained;
                        $subject_percentage=($subject_marks_obtained/$subject_mm)* 100;
                        $sp1=round($subject_percentage,2);
                        
                        $p_p=0;
                        if($class == 11 || $class == 12){
                            $p_p=33;    
                        }else{
                            $p_p=33;
                        }
                        
                        if($sp1 < $p_p){
                            // echo $subject_percentage."<br>";
                            $subject_failure_count=$subject_failure_count + 1;
                            // echo $sp1."<br>";
                        }
                    

                  
                        $data_array_update=array("subject_mm"=>$subject_mm,"hy_total_marks"=>$subject_marks_obtained,"updated_at"=>$cat,"updated_by"=>$tid,"class"=>$class,"section"=>$section);
                    
                        $data_array=array("sid"=>$sid,"academic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"hy_total_marks"=>$subject_marks_obtained,"subject_mm"=>$subject_mm,"created_at"=>$cat,"created_by"=>$tid);
                    
                    
                        // if($student_subject >= 1){
                            $update_subject_data=$this->ExamManagementModel->update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update);
                    
                        // }else{
                            // $add_subject_data=$this->NewExamModel->insert_data($data_array,$student_subjects_table);
                        // }
                    }
                }
                
                $cat=date('Y-m-d H:i:s');
                $tid=$this->session->userdata('tid');
                $percentage1=0;
                if($result_mm !=0){
                    $percentage1=($student_hy_total * 100)/$result_mm; 
                }
                
                // $percentage=number_format((float)$percentage1, 2, '.', '');
                $percentage=round($percentage1, 2);
                
                
                $y1=$this->session->userdata("y1");
                $y2=$this->session->userdata("y2");
                $result_status="";
                if($subject_failure_count == 0){
                        $result_status="Pass";
                }else{
                    $result_status="Fail";    
                }
                
                $result_data_array=array("exam_id"=>$exam_id,"sid"=>$sid,"y1"=>$y1,"y2"=>$y2,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"cat"=>$cat,"cat_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                $result_data_array_update=array("class"=>$class,"section"=>$section,"MM"=>$result_mm,"total_obtained_marks"=>$student_hy_total,"percentage"=>$percentage,"uat"=>$cat,"updated_by"=>$tid,"result_status"=>$result_status,"no_of_failure_subjects"=>$subject_failure_count);
                
                
                
                $get_student_result_data=$this->ExamManagementModel->student_result($sid,$acedemic_session,$exam_id,$course_id,$exam_result_table);
                if($get_student_result_data){
                    $update_student_result_data=$this->ExamManagementModel->update_student_exam_data($sid,$exam_id,$course_id,$result_data_array_update,$exam_result_table);
                }else{
                    $add_exam_result=$this->ExamManagementModel->insert_data($result_data_array,$exam_result_table);
                }
            }
        }
        $last_rank_obt_marks=0;
        $last_rank=0;
        $rank_count=0;
        $get_course_result=$this->ExamManagementModel->get_class_section_result($exam_id,$acedemic_session,$class,$section,$exam_result_table);
        if($get_course_result){
            foreach($get_course_result as $result){
                $id=$result['id'];
                if($result['result_status'] == "Pass"){
                    
                    $total_obtained_marks_cs=$result['total_obtained_marks'];
                    if($total_obtained_marks_cs == $last_rank_obt_marks){
                        $rank_count=$last_rank;
                    }else{
                        $rank_count=$rank_count + 1;
                    }
                    
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $data_array_update=array("rank_in_class"=>$rank_count,"uat"=>$cat,"updated_by"=>$tid);
                
                    $update_hic=$this->ExamManagementModel->update_item_data($id,$data_array_update,$exam_result_table);
                }else{
                    $cat=date("Y-m-d H:i:s");
                    $tid=$this->session->userdata('tid');
                    $data_array_update=array("rank_in_class"=>"","uat"=>$cat,"updated_by"=>$tid);
                
                    $update_hic=$this->ExamManagementModel->update_item_data($id,$data_array_update,$exam_result_table);
                }
                $last_rank_obt_marks=$result['total_obtained_marks'];
                $last_rank=$rank_count;
            }
        }
        echo "success";
        
    }
    
    public function class_section_sheet($class,$section,$exam_id){
        $data['success']="";    $data['error']="";
        if(isset($_POST['update_exam_log'])){
            $cat=date('Y-m-d H:i:s');
            $tid=$this->session->userdata('tid');
                            
            $class=$_POST['class'];
            $section=$_POST['section'];
            $exam_id=$_POST['exam_id'];
            $student_e_log=$_POST['student_e_log'];
            // var_dump($student_e_log);
            // echo $class;
            $acedemic_session=$this->session->userdata("acedemic_session");
            $all_students=$this->ExamManagementModel->get_students_ac_session_by_course_and_class($acedemic_session,$class,$section);
            if($all_students){
                foreach($all_students as $student){
                    $sid=$student['id'];
                    $course_id=$student['course_id'];
                    $exam_subjects_table='exam_subject_master_'.$acedemic_session;
                    $get_course_subjects=$this->ExamManagementModel->get_class_active_subjects($class,$exam_subjects_table);
                    
                    $student_subjects_table="student_subjects_".$acedemic_session;

                    
                    $eh_count=0;
                    $exam_head_table='exam_head_master_'.$acedemic_session.'';
                    // $all_exam_heads=$this->ExamManagementModel->get_course_exam_heads($class,$exam_head_table);
                    
                    $all_exam_heads=$this->ExamManagementModel->get_course_exam_wise_heads($class,$exam_id,$exam_head_table);
                    if($get_course_subjects){
                        foreach($get_course_subjects as $subjects){
                            $exam_type=$subjects['exam_type'];
                            $subject_id=$subjects['id'];
                            $student_sub_count=0;
                            $get_subject_info=$this->ExamManagementModel->student_subject_info($sid,$acedemic_session,$subject_id,$student_subjects_table);
                            // if($get_subject_info){
                                $student_sub_count=$student_sub_count + 1;
                            
                            
                                if($all_exam_heads){
                                    foreach($all_exam_heads as $exam_heads){
                                        $ehid=$exam_heads['id'];
                                        $elog_table='exam_log_'.$acedemic_session;
                                        $exam_log=$student_e_log[$sid][$subject_id][$ehid];
                                        
                                        
                                        if($exam_type == 'Marks'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"obtained_marks"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("obtained_marks"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->ExamManagementModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->ExamManagementModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');
                                    }
                            
                            }else if($exam_type == 'Grade'){
                                $data_array=array("sid"=>$sid,"acedemic_session"=>$acedemic_session,"course_id"=>$course_id,"subject_id"=>$subject_id,"exam_head"=>$ehid,"grade"=>$exam_log,"cat"=>$cat,"inserted_by"=>$tid);
                                $data_array_update=array("grade"=>$exam_log,"uat"=>$cat,"updated_by"=>$tid);
                                
                                    $elog_table='exam_log_'.$acedemic_session.'';
                                    $check_log_exist=$this->ExamManagementModel->get_log_item_data($sid,$ehid,$subject_id,$elog_table);
                                    if($check_log_exist){
                                        $update_log_data=$this->ExamManagementModel->update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table);
                                        // redirect(base_url().'Examination/exam_log/'.$sid.'');  
                                    }else{
                                        $add_log=$this->ExamManagementModel->insert_data($data_array,$elog_table);
                                        
                                        
                                    }
                            }
                                        
                                        // echo "<br>".$elog_data;
                                    }
                                }
                            
                            // }
                        }
                    }
                    
                    // $field_name="student_e_log[".$sid."][".$subject_id."][".$ehid."]";
                }
            }else{
                echo "No Students Found";
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/exam-management/class-section-sheet',$data);
        $this->load->view('erp/footer');
    }
    
    
    
    
}