<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Enquiry extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('InvoiceModel');
        $this->load->model('EnquiryModel');
        $this->load->model('AdminModel');
        $this->load->model('DeveloperModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function list_enquiry(){
        // if($this->session->userdata('admin')!=1){
            // redirect(base_url().'admin/');
        // }	
        $acedemic_session=$this->session->userdata('acedemic_session');
        $table = 'enquiry';
        $data['fetch_student_data']=$this->EnquiryModel->get_current_enquiry($acedemic_session,$table);    
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/list-enquiry',$data);
        $this->load->view('erp/footer');
    }

    public function shedule_sms(){
        $val=$_POST['val'];
        $id=$_POST['id'];
        $table=$_POST['table'];
        $data_array=array("shedule_sms"=>$val);
        $shedule_sms=$this->AdminModel->shedule_sms($data_array,$table,$id);
        if($shedule_sms){
            echo "Sheduled Successfully";
        }else{
            echo "Some Error Occured";
        }
    }

    public function grant_admission(){
        $val=$_POST['val'];
        $id=$_POST['id'];
        $table=$_POST['table'];
        $data_array=array("admission_status"=>$val);
        $shedule_sms=$this->AdminModel->shedule_sms($data_array,$table,$id);
        if($shedule_sms){
            echo "Sheduled Successfully";
        }else{
            echo "Some Error Occured";
        }   
    }

    public function re_shedule(){
        $data_array=array("shedule_sms"=>0);
        $table='enquiry';
        $shedule_sms=$this->AdminModel->re_shedule_sms($data_array,$table);
        if($shedule_sms){
            echo "Sheduled Successfully";
        }else{
            echo "Some Error Occured";
        }
    }

    public function new_enquiry(){
        $data['success']='';$data['error']='';
        $data['data']='';
        if(isset($_POST['edit'])){
            $data['data'] = $_POST['edit'];
        }

        if(isset($_POST['new_enquiry'])){
            $this->form_validation->set_rules('student_first_name', 'Student First Name', 'trim|required');
            $this->form_validation->set_rules('student_last_name', 'Student Last Name', 'trim|required');
            $this->form_validation->set_rules('father_name', 'Father Name', 'trim|required'); 
            $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'regex_match[/^[0-9]{10}$/]'); 
            $this->form_validation->set_rules('address', 'Address', 'trim|required'); 
            $this->form_validation->set_rules('course_id', 'Course', 'required'); 
            $this->form_validation->set_rules('section', 'Section', 'trim|required'); 


            if($this->form_validation->run() == false) {
            
                
            }else{
                $id=$this->input->post('id');
                $acedemic_session=$_POST['acedemic_session'];
                /*$scholor_number=$this->input->post('scholor_number');*/
                $first_name=$this->input->post('student_first_name');
                $last_name=$this->input->post('student_last_name');
                $father_name=$this->input->post('father_name');
                $course_id=$this->input->post('course_id');
                $mobile_number=$this->input->post('mobile_number');
                $address=$this->input->post('address');
                $section=$this->input->post('section');
                $gender=$this->input->post('gender');
                $table='enquiry';
                $cat=date('Y-m-d H:i:s');
                $courses_table='courses';
                $course='';
                $get_course_info=$this->NewFeeModel->get_item_data($course_id,$courses_table);
                if($get_course_info){
                    foreach($get_course_info as $course_info){
                        $course=$course_info['course'];
                    }
                }

                $data_array=array("first_name"=>$first_name,"last_name"=>$last_name,"class"=>$course,"course_id"=>$course_id,"mobile_number"=>$mobile_number,"father_name"=>$father_name,"address"=>$address,"c_at"=>$cat,"section"=>$section,"gender"=>$gender,"acedemic_session"=>$acedemic_session);
                $data_array_update=array("course_id"=>$course_id,"first_name"=>$first_name,"last_name"=>$last_name,"class"=>$course,"mobile_number"=>$mobile_number,"father_name"=>$father_name,"address"=>$address,"u_at"=>$cat,"section"=>$section,"gender"=>$gender,"acedemic_session"=>$acedemic_session);

                $get_enquiry_info=$this->WelcomeModel->get_item_data($id,$table);
                if($get_enquiry_info){
                    $update_enquiry=$this->EnquiryModel->update_item_data($data_array_update,$id,$table);
                    if($update_enquiry){
                        $data['success']="Updated Successfully";
                    }else{
                        $data['error']='Error in updating data';
                    }
                }else{
                    $check_enquiry=$this->EnquiryModel->check_short_enquiry($first_name,$last_name,$father_name,$mobile_number,$table);
                    if($check_enquiry){
                        $data['error']='Already Exist';
                    }else{
                        $add_enquiry = $this->EnquiryModel->add_enquiry($data_array,$table);
                        if($add_enquiry){
                            $data['success']='Added Successfully';
                        }
                    }    
                }
            }
        }
    
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/new-enquiry',$data);
        $this->load->view('erp/footer');
    }



    public function all_courses(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/all-courses');
        $this->load->view('erp/footer');
    }


    public function course_admissions($course){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/course-admissions');
        $this->load->view('erp/footer');
    }


    public function fee(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/fee');
        $this->load->view('erp/footer');
    }


    public function add_fee(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $tid=$this->session->userdata('tid');
        $fee_amount=$_POST['fee_amount']; echo "<br>";
        $fee_type=$_POST['fee_type'];     echo "<br>";
        $enquiry_id=$_POST['enquiry_id'];
        $fee_info=$_POST['fee_info'];
        $fee_date=$_POST['fee_date'];
        $balance_amount=$_POST['balance_amount'];
        $extra_amount=$_POST['extra_amount'];
        $acedemic_session=$this->session->userdata('acedemic_session');
        $received_amount=$_POST['received_amount'];
        $permission_by=$_POST['permission_by'];
    
        $check_fee=$this->EnquiryModel->check_fee_exist($fee_info,$enquiry_id,$acedemic_session);
        if($check_fee){
            echo "Fee Submitted earlier";
        }else{
            // echo "ok fine let me make sure about it";
            $cat=date('Y-m-d H:i:s');
            $day=date('d');
            $month=date('m');
            $year=date('Y');
            $table='student_fee';
            $data_array=array("acedemic_session"=>$acedemic_session,"estimate_amount"=>$fee_amount,"received_amount"=>$received_amount,"fee_type"=>$fee_type,"enquiry_id"=>$enquiry_id,"fee_info"=>$fee_info,"cat_time"=>$cat,"fee_date"=>$fee_date,"day"=>$day,"month"=>$month,"year"=>$year,"tid"=>$tid,"balance_amount"=>$balance_amount,"extra_amount"=>$extra_amount,"permission_by"=>$permission_by);
            $add_fee=$this->EnquiryModel->insert_data($data_array,$table);
            if($add_fee){
                echo "Fee Submitted Successfully";
            }else{echo "Some error occured !";}
    
                var_dump($data_array);
    
        }

    }

    public function loadallfeeinvoices(){
        $enquiry_id=$_POST['enquiry_id'];
            echo "<table class='table table-bordered table-striped'>";
            echo "<thead>";
            echo "<tr>";
            echo "<th>#</th>";
            echo "<th>Fee Dedcription</th>";
            echo "<th>Fee Amount</th>";
            echo "<th>Recieved</th>";
            echo "<th>Fee Date</th>";
            echo "<th>Invoice</th>";
            echo "</tr>";
            echo "</thead>";
            echo "<tbody>";
            $enquiry_fee_invoices=$this->EnquiryModel->enquiry_fee_invoices($enquiry_id);
            if($enquiry_fee_invoices){
                foreach($enquiry_fee_invoices as $fee){
                    echo "<tr>";
                        echo "<td></td>";
                        echo "<td>".$fee['fee_type']."</td>";
                        echo "<td>".$fee['estimate_amount']."</td>";
                        echo "<td>".$fee['total_amount']."</td>";
                        echo "<td>".date('d-m-Y',strtotime($fee['fee_date']))."</td>";
                        echo '<td><a href="'.base_url().'Enquiry/fee_receipt/'.$fee['fee_no'].'" style="text-decoration:none;color:#000;"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-printer-fill" viewBox="0 0 16 16"><path d="M5 1a2 2 0 0 0-2 2v1h10V3a2 2 0 0 0-2-2H5zm6 8H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1z"/><path d="M0 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-1v-2a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2H2a2 2 0 0 1-2-2V7zm2.5 1a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1z"/></svg></a></td>';
                    echo "</tr>";
                }
            }
            echo "</tbody>";
    }


    public function convert_to_admission(){
        $data['success']='';
        $data['error']='';

        if(isset($_POST['convert_to_admission'])){
            $enquiry_id=$this->input->post('enquiry_id');
            $acedemic_session=$this->input->post('acedemic_session');
            $section=$this->input->post('section');
            $course_id=$this->input->post('course_id');
                
            $course ='';
            $courses_table='courses';
            $get_course_info=$this->NewFeeModel->get_item_data($course_id,$courses_table);
            if($get_course_info){
                foreach($get_course_info as $course_info){
                    $course=$course_info['course'];
                }
            }
            $tid=$this->session->userdata("tid");
            $eq_table='enquiry';
            $student_table='student';
            // $acedemic_session=2;
            $ac_year='';
            $y1="";
            $y2="";
            $acd_table='academic_session_details';
            $get_session_data=$this->EnquiryModel->get_item_info($acedemic_session,$acd_table);
            if($get_session_data){
                foreach($get_session_data as $session_data){
                    $ac_year=$session_data['year_long'];
                    $y1=$session_data['y1'];
                    $y2=$session_data['y2'];
                }
            }


        $student_courses_table='student_courses_data';
        $get_student_data=$this->DeveloperModel->get_item_data($enquiry_id,$eq_table);
        if($get_student_data){
            foreach($get_student_data as $student_data){
                $cat=date('Y-m-d H:i:s');
                $mobile_number=$student_data['mobile_number'];
                $student_name="".$student_data['first_name']." ".$student_data['last_name'];
                // echo $student_name;

                $check_enquiry_student_exist=$this->DeveloperModel->check_enquiry_student_exist($enquiry_id,$student_table);
                if($check_enquiry_student_exist){
                    $data['error']="Error Already Added";
                }else{
                    $student_array=array(
                        "sch_no"=>$student_data['enquiry_no'],
                        "enquiry_id"=>$student_data['id'],
                        "student_name"=>$student_name,
                        "father_name"=>$student_data['father_name'],
                        "dob"=>$student_data['dob'],
                        "class"=>$course,
                        "section"=>$section,
                        "contact_no"=>$student_data['mobile_number'],
                        "password"=>$student_data['mobile_number'],
                        "email"=>$student_data['email'],
                        "admission_class"=>$course,
                        "status"=>1,
                        "course_id"=>$course_id,
                        "admission_date"=>date("Y-m-d"),
                        "admission_acedemic_session"=>$acedemic_session,
                        "y1"=>$y1,
                        "y2"=>$y2,
                        "cat"=>$cat,
                        "cat_by"=>$tid
                    );
                    $add_to_student=$this->DeveloperModel->insert_data($student_array,$student_table);
                    if($add_to_student){
                        $data_array=array(
                            "sid"=>$add_to_student,
                            "acedemic_session"=>$acedemic_session,
                            "class"=>$course,
                            "section"=>$section,
                            "ac_year"=>$ac_year,
                            "course_id"=>$course_id,
                            "date_of_admission"=>date("Y-m-d"),
                            "new_admission"=>"Yes",
                            "cat"=>$cat,
                            "cat_by"=>$tid,
                            "uat"=>$cat,
                            "upd_by"=>$tid
                        );
                        $add_to_student_courses_data=$this->DeveloperModel->insert_data($data_array,$student_courses_table);
                        if($add_to_student_courses_data){
                            $data['success']="Added to course data";
                            $login_data_array=array(
                                "sch_no"=>$add_to_student,
                                "user_id"=>$add_to_student,
                                "username"=>$add_to_student,
                                "Name"=>$student_name,
                                "mob_number"=>$mobile_number,
                                "usertype"=>'student',
                                "status"=>1,
                                "password"=>md5($mobile_number),
                                "cat"=>$cat,
                                "created_by"=>$tid
                            );
                            $cred_table='login_credentials';
                            $add_login_credentials=$this->DeveloperModel->insert_data($login_data_array,$cred_table);
                            if($add_login_credentials){
                                $data['success']="Login Cred Added successfully";
                            }
                        }

                    }
    
                }


            }
        }



        
        
        
    }
    
    
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/convert-to-admission',$data);
        $this->load->view('erp/footer');
    }

    public function fee_receipt($fee_no){
        // $this->load->view('erp/enquiry/enquiry-fee-receipt-pdf');
        // // Get output html
        // $html = $this->output->get_output();
        // // Load HTML content
        // $this->pdf->loadHtml($html);
    
        // $old_limit = ini_set("memory_limit", "512M");
        // // (Optional) Setup the paper size and orientation
        // $this->pdf->setPaper('A5', 'landscape');
        // // Render the HTML as PDF
        // $this->pdf->render();
   
        // // Output the generated PDF (1 = download and 0 = preview)
        // $this->pdf->stream("$fee_no", array("Attachment"=>0));
        
        $this->load->view('erp/enquiry/enquiry-fee-receipt-pdf');
        
        
        $html = $this->output->get_output();
        $this->pdf->loadHtml($html);
        $old_limit = ini_set("memory_limit", "512M");
        $this->pdf->setPaper('A5', 'landscape');
        $this->pdf->render();
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
        
    }
    
    public function invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/all-invoices');
        $this->load->view('erp/footer');       
    }
    
}