<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Barcodelist extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('FeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('LoginModel');
        $this->load->model('AttendenceModel');
        // $this->load->model('CalenderModel');
        $this->load->model('SchoolModel');
        $this->load->model('NewFeeModel');
        $this->load->model('OpeningBalanceModel');
        $this->load->model('UserModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function course_wise_codes($course_id){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $get_course_students=$this->WelcomeModel->get_course_students_by_ac_session_by_course_id($acedemic_session,$course_id);
        if($get_course_students){
            foreach($get_course_students as $data){
                $sid=$data['sid'];
                $table='student';
                $check_status=$this->WelcomeModel->get_item_data($sid,$table);
                if($check_status){
                    foreach($check_status as $student_data){
                        $status=$student_data['status'];
                        $barcode=$student_data['barcode'];
                        if($status == 1){
                            if($barcode ==''){
                                $student_barcode_id=barcode_prefix."-".$sid;
                                $barcode_img=$this->set_barcode($student_barcode_id); 
                                $data_array_update=array("barcode"=>$barcode_img);
                                $update_data=$this->WelcomeModel->update_item_data($data_array_update,$sid,$table);
                            }
                        }
                        
                    }
                }
            }
        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/barcode/course-wise-codes');
        $this->load->view('erp/footer');
    }
    
    public function download_barcodes($course_id){
        $course_table='courses';
        $course_name='';
        $subject_stream='';
        $get_course_info=$this->WelcomeModel->get_item_data($course_id,$course_table);
        if($get_course_info){
            foreach($get_course_info as $info){
                $course_name=$info['course']."-".$info['subject_stream']."-Barcode-List";
                
            }
        }
        $this->load->view('erp/barcode/course-barcode-pdf');
        
        $html = $this->output->get_output();
        
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        
        $this->pdf->setPaper('A4', 'portrait');
        
        $this->pdf->render();
   
        
        $this->pdf->stream("$course_name", array("Attachment"=>0));
    }
    
    
    public function test()
	{
		$data['barcode']='';
        $sid="SJEC-1";
		echo "<br>";
		$barcodePath =$_SERVER['DOCUMENT_ROOT']. '/barcode/'.$sid.'.png';
		$barcodeRealPath = base_url().'barcode/'.$sid.'.png';
		echo $bar_status= file_exists("$barcodeRealPath");
		if($bar_status == 1){
		    echo "Already Exists";
		}else{
		    echo $this->set_barcode($sid);    
		}
		
		
	}
    
    public function set_barcode($code){
        //load library
		$this->load->library('zend');
		//load in folder Zend
		$this->zend->load('Zend/Barcode');
		//generate barcode
        // 		$file = Zend_Barcode::draw('code128', 'image', array('text'=>$code), array());
            $file = Zend_Barcode::draw('code128', 'image', array('text'=>$code), array());
		  //  $code = date('Y-m-d-H-i-s')."-".$code;
		    $barcodeRealPath = $_SERVER['DOCUMENT_ROOT']. '/barcode/'.$code.'.png';
		    $barcodePath = base_url().'barcode/';

		  //  header('Content-Type: image/png');
		    $store_image = imagepng($file,$barcodeRealPath);
		    return $code.'.png';
    }
}